/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.mongodb.statement;

import com.mongodb.client.MongoDatabase;
import com.mongodb.client.model.CreateCollectionOptions;
import com.mongodb.client.model.ValidationAction;
import com.mongodb.client.model.ValidationLevel;
import com.mongodb.client.model.ValidationOptions;
import java.util.Objects;
import java.util.Optional;
import liquibase.ext.mongodb.statement.AbstractMongoStatement;
import liquibase.ext.mongodb.statement.BsonUtils;
import org.bson.Document;
import org.bson.conversions.Bson;

public class CreateCollectionStatement
extends AbstractMongoStatement {
    public static final String COMMAND_NAME = "createCollection";
    protected String collectionName;
    protected Document options;

    public CreateCollectionStatement(String collectionName, String options) {
        this(collectionName, BsonUtils.orEmptyDocument(options));
    }

    public CreateCollectionStatement(String collectionName, Document options) {
        this.collectionName = collectionName;
        this.options = options;
    }

    @Override
    public String toJs() {
        return "db.createCollection(" + this.collectionName + ", " + this.options.toJson() + ");";
    }

    @Override
    public void execute(MongoDatabase db) {
        CreateCollectionOptions createCollectionOptions = new CreateCollectionOptions();
        if (Objects.nonNull(this.options)) {
            ValidationAction validationAction = Optional.ofNullable(this.options.getString((Object)"validationAction")).map(ValidationAction::fromString).orElse(null);
            ValidationLevel validationLevel = Optional.ofNullable(this.options.getString((Object)"validationLevel")).map(ValidationLevel::fromString).orElse(null);
            createCollectionOptions.validationOptions(new ValidationOptions().validationAction(validationAction).validationLevel(validationLevel).validator((Bson)this.options.get((Object)"validator", Document.class)));
        }
        db.createCollection(this.collectionName, createCollectionOptions);
    }

    public String toString() {
        return this.toJs();
    }

    public String getCollectionName() {
        return this.collectionName;
    }

    public Document getOptions() {
        return this.options;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CreateCollectionStatement)) {
            return false;
        }
        CreateCollectionStatement other = (CreateCollectionStatement)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$collectionName = this.getCollectionName();
        String other$collectionName = other.getCollectionName();
        if (this$collectionName == null ? other$collectionName != null : !this$collectionName.equals(other$collectionName)) {
            return false;
        }
        Document this$options = this.getOptions();
        Document other$options = other.getOptions();
        return !(this$options == null ? other$options != null : !this$options.equals(other$options));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CreateCollectionStatement;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $collectionName = this.getCollectionName();
        result = result * 59 + ($collectionName == null ? 43 : $collectionName.hashCode());
        Document $options = this.getOptions();
        result = result * 59 + ($options == null ? 43 : $options.hashCode());
        return result;
    }
}

