/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.mongodb.statement;

import com.mongodb.client.MongoDatabase;
import com.mongodb.client.model.IndexOptions;
import liquibase.ext.mongodb.statement.AbstractMongoStatement;
import liquibase.ext.mongodb.statement.BsonUtils;
import org.bson.Document;
import org.bson.conversions.Bson;

public class CreateIndexStatement
extends AbstractMongoStatement {
    public static final String COMMAND_NAME = "createIndex";
    private final String collectionName;
    private final Document keys;
    private final Document options;

    public CreateIndexStatement(String collectionName, Document keys, Document options) {
        this.collectionName = collectionName;
        this.keys = keys;
        this.options = options;
    }

    public CreateIndexStatement(String collectionName, String keys, String options) {
        this(collectionName, BsonUtils.orEmptyDocument(keys), BsonUtils.orEmptyDocument(options));
    }

    @Override
    public String toJs() {
        return "db." + this.collectionName + ". " + COMMAND_NAME + "(" + this.keys.toJson() + ", " + this.options.toJson() + ");";
    }

    @Override
    public void execute(MongoDatabase db) {
        db.getCollection(this.collectionName).createIndex((Bson)this.keys, this.createIndexOptions());
    }

    private IndexOptions createIndexOptions() {
        IndexOptions indexOptions = new IndexOptions();
        if (this.options.containsKey((Object)"unique") && this.options.getBoolean((Object)"unique").booleanValue()) {
            indexOptions.unique(true);
        }
        if (this.options.containsKey((Object)"name")) {
            indexOptions.name(this.options.getString((Object)"name"));
        }
        return indexOptions;
    }

    public String toString() {
        return this.toJs();
    }

    public String getCollectionName() {
        return this.collectionName;
    }

    public Document getKeys() {
        return this.keys;
    }

    public Document getOptions() {
        return this.options;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CreateIndexStatement)) {
            return false;
        }
        CreateIndexStatement other = (CreateIndexStatement)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$collectionName = this.getCollectionName();
        String other$collectionName = other.getCollectionName();
        if (this$collectionName == null ? other$collectionName != null : !this$collectionName.equals(other$collectionName)) {
            return false;
        }
        Document this$keys = this.getKeys();
        Document other$keys = other.getKeys();
        if (this$keys == null ? other$keys != null : !this$keys.equals(other$keys)) {
            return false;
        }
        Document this$options = this.getOptions();
        Document other$options = other.getOptions();
        return !(this$options == null ? other$options != null : !this$options.equals(other$options));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CreateIndexStatement;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $collectionName = this.getCollectionName();
        result = result * 59 + ($collectionName == null ? 43 : $collectionName.hashCode());
        Document $keys = this.getKeys();
        result = result * 59 + ($keys == null ? 43 : $keys.hashCode());
        Document $options = this.getOptions();
        result = result * 59 + ($options == null ? 43 : $options.hashCode());
        return result;
    }
}

