/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.mongodb.statement;

import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import liquibase.ext.mongodb.statement.AbstractMongoStatement;

public class DropCollectionStatement
extends AbstractMongoStatement {
    public static final String COMMAND_NAME = "drop";
    private final String collectionName;

    @Override
    public String toJs() {
        return "db." + this.collectionName + "." + COMMAND_NAME + "();";
    }

    @Override
    public void execute(MongoDatabase db) {
        MongoCollection collection = db.getCollection(this.collectionName);
        collection.drop();
    }

    public String toString() {
        return this.toJs();
    }

    public DropCollectionStatement(String collectionName) {
        this.collectionName = collectionName;
    }

    public String getCollectionName() {
        return this.collectionName;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DropCollectionStatement)) {
            return false;
        }
        DropCollectionStatement other = (DropCollectionStatement)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$collectionName = this.getCollectionName();
        String other$collectionName = other.getCollectionName();
        return !(this$collectionName == null ? other$collectionName != null : !this$collectionName.equals(other$collectionName));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DropCollectionStatement;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $collectionName = this.getCollectionName();
        result = result * 59 + ($collectionName == null ? 43 : $collectionName.hashCode());
        return result;
    }
}

