/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.mongodb.statement;

import com.mongodb.client.MongoDatabase;
import java.util.ArrayList;
import java.util.List;
import liquibase.exception.DatabaseException;
import liquibase.ext.mongodb.statement.AbstractMongoStatement;
import liquibase.ext.mongodb.statement.BsonUtils;
import org.bson.Document;
import org.bson.conversions.Bson;

public class FindAllStatement
extends AbstractMongoStatement {
    public static final String COMMAND_NAME = "find";
    private final String collectionName;
    private final Document filter;
    private final Document sort;

    public FindAllStatement(String collectionName) {
        this(collectionName, new Document(), new Document());
    }

    public FindAllStatement(String collectionName, String filter, String sort) {
        this(collectionName, BsonUtils.orEmptyDocument(filter), BsonUtils.orEmptyDocument(sort));
    }

    public FindAllStatement(String collectionName, Document filter, Document sort) {
        this.collectionName = collectionName;
        this.filter = filter;
        this.sort = sort;
    }

    @Override
    public String toJs() {
        return "db." + this.collectionName + "." + COMMAND_NAME + "(" + this.filter.toJson() + ");";
    }

    public List queryForList(MongoDatabase db, Class elementType) throws DatabaseException {
        ArrayList result = new ArrayList();
        db.getCollection(this.collectionName, elementType).find((Bson)this.filter).sort((Bson)this.sort).into(result);
        return result;
    }

    public String toString() {
        return this.toJs();
    }

    public String getCollectionName() {
        return this.collectionName;
    }

    public Document getFilter() {
        return this.filter;
    }

    public Document getSort() {
        return this.sort;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FindAllStatement)) {
            return false;
        }
        FindAllStatement other = (FindAllStatement)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$collectionName = this.getCollectionName();
        String other$collectionName = other.getCollectionName();
        if (this$collectionName == null ? other$collectionName != null : !this$collectionName.equals(other$collectionName)) {
            return false;
        }
        Document this$filter = this.getFilter();
        Document other$filter = other.getFilter();
        if (this$filter == null ? other$filter != null : !this$filter.equals(other$filter)) {
            return false;
        }
        Document this$sort = this.getSort();
        Document other$sort = other.getSort();
        return !(this$sort == null ? other$sort != null : !this$sort.equals(other$sort));
    }

    protected boolean canEqual(Object other) {
        return other instanceof FindAllStatement;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $collectionName = this.getCollectionName();
        result = result * 59 + ($collectionName == null ? 43 : $collectionName.hashCode());
        Document $filter = this.getFilter();
        result = result * 59 + ($filter == null ? 43 : $filter.hashCode());
        Document $sort = this.getSort();
        result = result * 59 + ($sort == null ? 43 : $sort.hashCode());
        return result;
    }
}

