/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.mongodb.statement;

import com.mongodb.MongoException;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import java.util.ArrayList;
import java.util.List;
import liquibase.exception.DatabaseException;
import liquibase.ext.mongodb.statement.AbstractMongoStatement;
import liquibase.ext.mongodb.statement.BsonUtils;
import org.bson.Document;

public class InsertManyStatement
extends AbstractMongoStatement {
    public static final String COMMAND_NAME = "insertMany";
    private final String collectionName;
    private final List<Document> documents;
    private Document options;

    public InsertManyStatement(String collectionName, String documents, String options) {
        this(collectionName, new ArrayList<Document>(BsonUtils.orEmptyList(documents)), BsonUtils.orEmptyDocument(options));
    }

    public InsertManyStatement(String collectionName, List<Document> documents, Document options) {
        this.collectionName = collectionName;
        this.documents = documents;
        this.options = options;
    }

    @Override
    public String toJs() {
        return "db." + this.collectionName + "." + COMMAND_NAME + "(" + this.documents.toString() + ", " + this.options.toJson() + ");";
    }

    @Override
    public void execute(MongoDatabase db) throws DatabaseException {
        try {
            MongoCollection collection = db.getCollection(this.collectionName);
            collection.insertMany(this.documents);
        }
        catch (MongoException e) {
            throw new DatabaseException((Throwable)e);
        }
    }

    public String toString() {
        return this.toJs();
    }

    public String getCollectionName() {
        return this.collectionName;
    }

    public List<Document> getDocuments() {
        return this.documents;
    }

    public Document getOptions() {
        return this.options;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof InsertManyStatement)) {
            return false;
        }
        InsertManyStatement other = (InsertManyStatement)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$collectionName = this.getCollectionName();
        String other$collectionName = other.getCollectionName();
        if (this$collectionName == null ? other$collectionName != null : !this$collectionName.equals(other$collectionName)) {
            return false;
        }
        List<Document> this$documents = this.getDocuments();
        List<Document> other$documents = other.getDocuments();
        if (this$documents == null ? other$documents != null : !((Object)this$documents).equals(other$documents)) {
            return false;
        }
        Document this$options = this.getOptions();
        Document other$options = other.getOptions();
        return !(this$options == null ? other$options != null : !this$options.equals(other$options));
    }

    protected boolean canEqual(Object other) {
        return other instanceof InsertManyStatement;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $collectionName = this.getCollectionName();
        result = result * 59 + ($collectionName == null ? 43 : $collectionName.hashCode());
        List<Document> $documents = this.getDocuments();
        result = result * 59 + ($documents == null ? 43 : ((Object)$documents).hashCode());
        Document $options = this.getOptions();
        result = result * 59 + ($options == null ? 43 : $options.hashCode());
        return result;
    }
}

