/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.mongodb.statement;

import com.mongodb.MongoException;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import liquibase.exception.DatabaseException;
import liquibase.ext.mongodb.statement.AbstractMongoStatement;
import liquibase.ext.mongodb.statement.BsonUtils;
import org.bson.Document;

public class InsertOneStatement
extends AbstractMongoStatement {
    public static final String COMMAND_NAME = "insertOne";
    private final String collectionName;
    private final Document document;
    private final Document options;

    public InsertOneStatement(String collectionName, String document, String options) {
        this(collectionName, BsonUtils.orEmptyDocument(document), BsonUtils.orEmptyDocument(options));
    }

    public InsertOneStatement(String collectionName, Document document, Document options) {
        this.collectionName = collectionName;
        this.document = document;
        this.options = options;
    }

    @Override
    public String toJs() {
        return "db." + this.collectionName + "." + COMMAND_NAME + "(" + this.document.toJson() + ", " + this.options.toJson() + ");";
    }

    @Override
    public void execute(MongoDatabase db) throws DatabaseException {
        try {
            MongoCollection collection = db.getCollection(this.collectionName);
            collection.insertOne((Object)this.document);
        }
        catch (MongoException e) {
            throw new DatabaseException((Throwable)e);
        }
    }

    public String toString() {
        return this.toJs();
    }

    public String getCollectionName() {
        return this.collectionName;
    }

    public Document getDocument() {
        return this.document;
    }

    public Document getOptions() {
        return this.options;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof InsertOneStatement)) {
            return false;
        }
        InsertOneStatement other = (InsertOneStatement)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$collectionName = this.getCollectionName();
        String other$collectionName = other.getCollectionName();
        if (this$collectionName == null ? other$collectionName != null : !this$collectionName.equals(other$collectionName)) {
            return false;
        }
        Document this$document = this.getDocument();
        Document other$document = other.getDocument();
        if (this$document == null ? other$document != null : !this$document.equals(other$document)) {
            return false;
        }
        Document this$options = this.getOptions();
        Document other$options = other.getOptions();
        return !(this$options == null ? other$options != null : !this$options.equals(other$options));
    }

    protected boolean canEqual(Object other) {
        return other instanceof InsertOneStatement;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $collectionName = this.getCollectionName();
        result = result * 59 + ($collectionName == null ? 43 : $collectionName.hashCode());
        Document $document = this.getDocument();
        result = result * 59 + ($document == null ? 43 : $document.hashCode());
        Document $options = this.getOptions();
        result = result * 59 + ($options == null ? 43 : $options.hashCode());
        return result;
    }
}

