/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.mongodb.statement;

import com.mongodb.client.MongoDatabase;
import liquibase.ext.mongodb.statement.AbstractMongoDocumentStatement;
import liquibase.ext.mongodb.statement.BsonUtils;
import org.bson.Document;
import org.bson.conversions.Bson;

public class RunCommandStatement
extends AbstractMongoDocumentStatement<Document> {
    public static final String COMMAND_NAME = "runCommand";
    protected Document command;

    public RunCommandStatement(String command) {
        this(BsonUtils.orEmptyDocument(command));
    }

    public RunCommandStatement(Document command) {
        this.command = command;
    }

    @Override
    public String toJs() {
        return "db.runCommand(" + this.command.toJson() + ");";
    }

    @Override
    public Document run(MongoDatabase db) {
        return db.runCommand((Bson)this.command);
    }

    public String toString() {
        return this.toJs();
    }

    public Document getCommand() {
        return this.command;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RunCommandStatement)) {
            return false;
        }
        RunCommandStatement other = (RunCommandStatement)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Document this$command = this.getCommand();
        Document other$command = other.getCommand();
        return !(this$command == null ? other$command != null : !this$command.equals(other$command));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RunCommandStatement;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Document $command = this.getCommand();
        result = result * 59 + ($command == null ? 43 : $command.hashCode());
        return result;
    }
}

