/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.mongodb.change;

import liquibase.change.Change;
import liquibase.change.DatabaseChange;
import liquibase.database.Database;
import liquibase.ext.mongodb.change.AbstractMongoChange;
import liquibase.ext.mongodb.change.DropIndexChange;
import liquibase.ext.mongodb.statement.CreateIndexStatement;
import liquibase.statement.SqlStatement;

@DatabaseChange(name="createIndex", description="Creates index for collectionhttps://docs.mongodb.com/manual/reference/method/db.collection.createIndex/#db.collection.createIndex\nhttps://docs.mongodb.com/manual/reference/command/createIndexes/", priority=5, appliesTo={"collection"})
public class CreateIndexChange
extends AbstractMongoChange {
    private String collectionName;
    private String keys;
    private String options;

    public String getConfirmationMessage() {
        return "Index created for collection " + this.getCollectionName();
    }

    public SqlStatement[] generateStatements(Database database) {
        return new SqlStatement[]{new CreateIndexStatement(this.collectionName, this.keys, this.options)};
    }

    protected Change[] createInverses() {
        DropIndexChange inverse = new DropIndexChange();
        inverse.setCollectionName(this.getCollectionName());
        inverse.setKeys(this.getKeys());
        return new Change[]{inverse};
    }

    public String getCollectionName() {
        return this.collectionName;
    }

    public String getKeys() {
        return this.keys;
    }

    public String getOptions() {
        return this.options;
    }

    public void setCollectionName(String collectionName) {
        this.collectionName = collectionName;
    }

    public void setKeys(String keys) {
        this.keys = keys;
    }

    public void setOptions(String options) {
        this.options = options;
    }
}

