/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.mongodb.change;

import liquibase.change.DatabaseChange;
import liquibase.database.Database;
import liquibase.ext.mongodb.change.AbstractMongoChange;
import liquibase.ext.mongodb.statement.DropIndexStatement;
import liquibase.statement.SqlStatement;

@DatabaseChange(name="dropIndex", description="Drops index for a collection by keyshttps://docs.mongodb.com/manual/reference/method/db.collection.dropIndex/#db.collection.dropIndex", priority=5, appliesTo={"collection"})
public class DropIndexChange
extends AbstractMongoChange {
    private String collectionName;
    private String keys;

    public String getConfirmationMessage() {
        return "Index dropped for collection " + this.getCollectionName();
    }

    public SqlStatement[] generateStatements(Database database) {
        return new SqlStatement[]{new DropIndexStatement(this.collectionName, this.keys)};
    }

    public String getCollectionName() {
        return this.collectionName;
    }

    public String getKeys() {
        return this.keys;
    }

    public void setCollectionName(String collectionName) {
        this.collectionName = collectionName;
    }

    public void setKeys(String keys) {
        this.keys = keys;
    }
}

