/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.mongodb.database;

import com.mongodb.client.MongoDatabase;
import liquibase.CatalogAndSchema;
import liquibase.Scope;
import liquibase.changelog.ChangeLogHistoryServiceFactory;
import liquibase.database.Database;
import liquibase.exception.LiquibaseException;
import liquibase.executor.Executor;
import liquibase.executor.ExecutorService;
import liquibase.ext.mongodb.configuration.MongoConfiguration;
import liquibase.ext.mongodb.database.MongoClientDriver;
import liquibase.ext.mongodb.database.MongoConnection;
import liquibase.ext.mongodb.statement.DropAllCollectionsStatement;
import liquibase.nosql.database.AbstractNoSqlDatabase;
import liquibase.statement.SqlStatement;

public class MongoLiquibaseDatabase
extends AbstractNoSqlDatabase {
    public static final String MONGODB_PRODUCT_NAME = "MongoDB";
    public static final String MONGODB_PRODUCT_SHORT_NAME = "mongodb";
    public static final String ADMIN_DATABASE_NAME = "admin";
    private Boolean adjustTrackingTablesOnStartup;
    private Boolean supportsValidator;

    @Override
    public void dropDatabaseObjects(CatalogAndSchema schemaToDrop) throws LiquibaseException {
        Executor executor = ((ExecutorService)Scope.getCurrentScope().getSingleton(ExecutorService.class)).getExecutor("jdbc", (Database)this);
        DropAllCollectionsStatement dropAllCollectionsStatement = new DropAllCollectionsStatement();
        executor.execute((SqlStatement)dropAllCollectionsStatement);
        ((ChangeLogHistoryServiceFactory)Scope.getCurrentScope().getSingleton(ChangeLogHistoryServiceFactory.class)).getChangeLogService((Database)this).destroy();
    }

    @Override
    public String getDefaultDriver(String url) {
        if (url.startsWith("mongodb+srv://") || url.startsWith("mongodb://")) {
            return MongoClientDriver.class.getName();
        }
        return null;
    }

    public MongoDatabase getMongoDatabase() {
        return ((MongoConnection)this.getConnection()).getMongoDatabase();
    }

    @Override
    public String getDatabaseProductName() {
        return MONGODB_PRODUCT_NAME;
    }

    public String getShortName() {
        return MONGODB_PRODUCT_SHORT_NAME;
    }

    public Integer getDefaultPort() {
        return 27017;
    }

    protected String getDefaultDatabaseProductName() {
        return MONGODB_PRODUCT_NAME;
    }

    @Override
    public String getSystemSchema() {
        return ADMIN_DATABASE_NAME;
    }

    public Boolean getAdjustTrackingTablesOnStartup() {
        if (this.adjustTrackingTablesOnStartup != null) {
            return this.adjustTrackingTablesOnStartup;
        }
        return (Boolean)MongoConfiguration.ADJUST_TRACKING_TABLES_ON_STARTUP.getCurrentValue();
    }

    public Boolean getSupportsValidator() {
        if (this.supportsValidator != null) {
            return this.supportsValidator;
        }
        return (Boolean)MongoConfiguration.SUPPORTS_VALIDATOR.getCurrentValue();
    }

    public void setAdjustTrackingTablesOnStartup(Boolean adjustTrackingTablesOnStartup) {
        this.adjustTrackingTablesOnStartup = adjustTrackingTablesOnStartup;
    }

    public void setSupportsValidator(Boolean supportsValidator) {
        this.supportsValidator = supportsValidator;
    }
}

