/*
 * Decompiled with CFR 0.152.
 */
package liquibase.nosql.snapshot;

import java.util.ResourceBundle;
import liquibase.database.Database;
import liquibase.exception.DatabaseException;
import liquibase.ext.mongodb.database.MongoLiquibaseDatabase;
import liquibase.snapshot.DatabaseSnapshot;
import liquibase.snapshot.InvalidExampleException;
import liquibase.snapshot.SnapshotGenerator;
import liquibase.snapshot.SnapshotGeneratorChain;
import liquibase.structure.DatabaseObject;

public class NoSqlSnapshotGenerator
implements SnapshotGenerator {
    private static final ResourceBundle mongoBundle = ResourceBundle.getBundle("liquibase/i18n/liquibase-mongo");

    public int getPriority(Class<? extends DatabaseObject> objectType, Database database) {
        if (database instanceof MongoLiquibaseDatabase) {
            return 10;
        }
        return -1;
    }

    public <T extends DatabaseObject> T snapshot(T example, DatabaseSnapshot snapshot, SnapshotGeneratorChain chain) throws DatabaseException, InvalidExampleException {
        throw new DatabaseException(String.format(mongoBundle.getString("command.unsupported"), "db-doc, diff*, generate-changelog, and snapshot*"));
    }

    public Class<? extends DatabaseObject>[] addsTo() {
        return new Class[0];
    }

    public Class<? extends SnapshotGenerator>[] replaces() {
        return new Class[0];
    }
}

