/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.ora.disabletrigger;

import liquibase.change.AbstractChange;
import liquibase.change.Change;
import liquibase.change.DatabaseChange;
import liquibase.database.Database;
import liquibase.ext.ora.disabletrigger.DisableTriggerStatement;
import liquibase.ext.ora.enabletrigger.EnableTriggerChange;
import liquibase.statement.SqlStatement;

@DatabaseChange(name="disableTrigger", description="Disable Trigger", priority=201)
public class DisableTriggerChange
extends AbstractChange {
    private String schemaName;
    private String triggerName;

    public String getSchemaName() {
        return this.schemaName;
    }

    public void setSchemaName(String schemaName) {
        this.schemaName = schemaName;
    }

    public String getTriggerName() {
        return this.triggerName;
    }

    public void setTriggerName(String triggerName) {
        this.triggerName = triggerName;
    }

    public String getConfirmationMessage() {
        return "Trigger has been disabled.";
    }

    protected Change[] createInverses() {
        EnableTriggerChange inverse = new EnableTriggerChange();
        inverse.setSchemaName(this.getSchemaName());
        inverse.setTriggerName(this.getTriggerName());
        return new Change[]{inverse};
    }

    public SqlStatement[] generateStatements(Database database) {
        DisableTriggerStatement statement = new DisableTriggerStatement(this.getSchemaName(), this.getTriggerName());
        return new SqlStatement[]{statement};
    }
}

