/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.checks.snapshot;

import java.util.concurrent.atomic.AtomicReference;
import liquibase.GlobalConfiguration;
import liquibase.command.CommandScope;
import liquibase.command.core.SnapshotCommandStep;
import liquibase.database.Database;
import liquibase.database.OfflineConnection;
import liquibase.diff.output.ObjectChangeFilter;
import liquibase.diff.output.StandardObjectChangeFilter;
import liquibase.exception.DatabaseException;
import liquibase.snapshot.DatabaseSnapshot;
import liquibase.snapshot.SnapshotControl;
import liquibase.structure.core.DatabaseObjectFactory;

public class DatabaseSnapshotHelper {
    private DatabaseSnapshotHelper() {
    }

    public static DatabaseSnapshot takeSnapshot(String string, Database database, String string2) {
        AtomicReference<DatabaseSnapshot> atomicReference = new AtomicReference<DatabaseSnapshot>();
        try {
            CommandScope commandScope = new CommandScope(new String[]{"snapshot"});
            commandScope.addArgumentValue(SnapshotCommandStep.DATABASE_ARG, (Object)database);
            commandScope.addArgumentValue(SnapshotCommandStep.URL_ARG, (Object)string);
            commandScope.addArgumentValue(SnapshotCommandStep.SCHEMAS_ARG, (Object)string2);
            commandScope.setOutput(null);
            commandScope.addArgumentValue(SnapshotCommandStep.SNAPSHOT_CONTROL_ARG, (Object)DatabaseSnapshotHelper.createSnapshotControl(database));
            string = commandScope.execute();
            atomicReference.set((DatabaseSnapshot)string.getResult("snapshot"));
        }
        catch (Exception exception) {
            string = database.getConnection() instanceof OfflineConnection ? "The snapshot specified in the URL property cannot be accessed. Database-scoped checks cannot be completed.\nPlease check all database properties and credentials and try again." : "The database target specified in the URL property cannot be accessed. Database-scoped checks cannot be completed.\nPlease check all database properties and credentials and try again.";
            throw new DatabaseException(string, (Throwable)exception);
        }
        return (DatabaseSnapshot)atomicReference.get();
    }

    private static SnapshotControl createSnapshotControl(Database database) {
        String string = (String)GlobalConfiguration.DATABASECHANGELOG_TABLE_NAME.getCurrentValue();
        Class[] classArray = (Class[])GlobalConfiguration.DATABASECHANGELOGLOCK_TABLE_NAME.getCurrentValue();
        string = new StandardObjectChangeFilter(StandardObjectChangeFilter.FilterType.EXCLUDE, "table:(?i)" + string + ", table:(?i)" + (String)classArray);
        classArray = DatabaseObjectFactory.getInstance().getStandardTypes().toArray(new Class[0]);
        return new SnapshotControl(database, (ObjectChangeFilter)string, classArray);
    }
}

