/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.command.checks;

import com.datical.liquibase.ext.checks.config.CheckSettingsConfigHelper;
import com.datical.liquibase.ext.checks.config.cli.RuleParameter;
import com.datical.liquibase.ext.checks.config.model.AbstractConfigurableRule;
import com.datical.liquibase.ext.checks.config.model.CheckSettingsConfig;
import com.datical.liquibase.ext.checks.config.model.DynamicRule;
import com.datical.liquibase.ext.checks.config.model.DynamicRuleParameter;
import com.datical.liquibase.ext.command.checks.AbstractChecksCommandStep;
import com.datical.liquibase.ext.command.checks.ChecksCopyCommandStep;
import com.datical.liquibase.ext.command.checks.ChecksShowCommandStep;
import com.datical.liquibase.ext.rules.core.AbstractLiquibaseRule;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import liquibase.Scope;
import liquibase.command.CommandArgumentDefinition;
import liquibase.command.CommandBuilder;
import liquibase.command.CommandDefinition;
import liquibase.command.CommandResultsBuilder;
import liquibase.exception.CommandExecutionException;
import liquibase.license.pro.LicenseTier;

public class ChecksCustomizeCommandStep
extends AbstractChecksCommandStep {
    public static final String[] COMMAND_NAME = new String[]{"checks", "customize"};
    public static final CommandArgumentDefinition<String> CHECK_NAME_ARG;
    public static final CommandArgumentDefinition<String> CHECKS_SETTINGS_FILE_ARG;
    public static final CommandArgumentDefinition<String> CHECKS_AUTO_UPDATE_ARG;

    public final void run(CommandResultsBuilder commandResultsBuilder) {
        Object object;
        Object object2 = commandResultsBuilder.getCommandScope();
        String string2 = (String)object2.getConfiguredValue(CHECKS_SETTINGS_FILE_ARG).getValue();
        Object object3 = (String)object2.getConfiguredValue(CHECK_NAME_ARG).getValue();
        Object object4 = ChecksCustomizeCommandStep.listAllRules();
        object2 = (String)object2.getConfiguredValue(CHECKS_AUTO_UPDATE_ARG).getValue();
        CheckSettingsConfig checkSettingsConfig = ((CheckSettingsConfigHelper)(object2 = new CheckSettingsConfigHelper(string2, (String)object2))).read((List<AbstractLiquibaseRule>)object4);
        if (checkSettingsConfig == null) {
            commandResultsBuilder.addResult("statusCode", (Object)0);
            return;
        }
        Object object5 = object4.stream().filter(arg_0 -> ChecksCustomizeCommandStep.lambda$run$1((String)object3, arg_0)).findFirst();
        if (((Optional)object5).isPresent()) {
            object = ((Optional)object5).get();
            this.checkMinimumRequiredLicense(((AbstractLiquibaseRule)object).getMinimumAllowableLicense());
        }
        if (((Optional)object5).isPresent() && !((Optional)object5).get().isConfigurable()) {
            object = ((Optional)object5).get();
            if ((object5 = checkSettingsConfig.getRuleById(((AbstractLiquibaseRule)object).getId())) == null) {
                throw new CommandExecutionException("Unable to locate check to modify '" + ((AbstractLiquibaseRule)object).getShortName() + "' in configuration settings.");
            }
            if (ChecksCustomizeCommandStep.modifySeverity((AbstractConfigurableRule)object5)) {
                ((CheckSettingsConfigHelper)object2).write(checkSettingsConfig);
            }
            Scope.getCurrentScope().getUI().sendMessage("Customization complete. Review the table below to confirm your changes.");
            ChecksShowCommandStep.writeTableToOutput(commandResultsBuilder, string2, false);
            commandResultsBuilder.addResult("statusCode", (Object)0);
            return;
        }
        object = checkSettingsConfig.getDynamicConfigurableRuleByShortName((String)object3, "does not have customization options");
        object5 = ChecksCustomizeCommandStep.findConfigurableParentRule((AbstractConfigurableRule)object, object4, (String)object3, "does not have customization options");
        if (!((AbstractLiquibaseRule)object5).hasDefaultParameterValues() && !((DynamicRule)object).isCopy()) {
            Scope.getCurrentScope().getUI().sendMessage(System.lineSeparator() + "This check can not be customized directly because one or more fields does not have a default value.  Creating a copy of this check and initiating the customization workflow.");
            ChecksCopyCommandStep.doCopy(checkSettingsConfig, (String)object3, object4, string2, commandResultsBuilder, (CheckSettingsConfigHelper)object2);
        } else {
            this.checkMinimumRequiredLicense(((AbstractLiquibaseRule)object5).getMinimumAllowableLicense());
            ChecksCustomizeCommandStep.modifySeverity((AbstractConfigurableRule)object);
            object3 = ChecksCustomizeCommandStep.promptForParameters(((AbstractLiquibaseRule)object5).getParameters(), (DynamicRule)object);
            if (!((AbstractConfigurableRule)object).isEnabled() && (object4 = (String)Scope.getCurrentScope().getUI().prompt("This check is disabled.  Enable it? (Y/n)", null, (string, clazz) -> {
                if (string == null || !string.equalsIgnoreCase("y") && !string.equalsIgnoreCase("n")) {
                    throw new IllegalArgumentException();
                }
                return string;
            }, String.class)) != null && ((String)object4).equalsIgnoreCase("y")) {
                ((AbstractConfigurableRule)object).setEnabled(true);
            }
            ((DynamicRule)object).getParameters().clear();
            ((DynamicRule)object).getParameters().addAll((Collection<DynamicRuleParameter>)object3);
            ((CheckSettingsConfigHelper)object2).write(checkSettingsConfig);
            Scope.getCurrentScope().getUI().sendMessage("Customization complete. Review the table below to confirm your changes.");
            ChecksShowCommandStep.writeTableToOutput(commandResultsBuilder, string2, false);
        }
        checkSettingsConfig.outputWarningMessage();
        commandResultsBuilder.addResult("statusCode", (Object)0);
    }

    private void checkMinimumRequiredLicense(LicenseTier object) {
        if (!object.isValid()) {
            object = "To copy or customize " + object.getSubject() + "-licensed checks requires a valid " + object.getSubject() + " license key in liquibase.licenseKey property. To get a trial " + object.getSubject() + " license visit https://liquibase.com/trial";
            throw new CommandExecutionException((String)object);
        }
    }

    public static List<DynamicRuleParameter> promptForParameters(List<RuleParameter<?>> object, DynamicRule dynamicRule) {
        ArrayList<DynamicRuleParameter> arrayList = new ArrayList<DynamicRuleParameter>(object.size());
        object = object.iterator();
        while (object.hasNext()) {
            Object object2 = (RuleParameter)object.next();
            if (!((RuleParameter)object2).shouldPrompt(arrayList)) continue;
            Optional<DynamicRuleParameter> optional = dynamicRule.getParameters().stream().filter(arg_0 -> ChecksCustomizeCommandStep.lambda$promptForParameters$3((RuleParameter)object2, arg_0)).findFirst();
            optional = !optional.isPresent() ? null : optional.get().getValue();
            optional = ((RuleParameter)object2).getInteractiveCommandLineValueGetter().prompt((RuleParameter<?>)object2, (List<DynamicRuleParameter>)arrayList, optional);
            object2 = new DynamicRuleParameter(((RuleParameter)object2).getParameter(), optional);
            arrayList.add((DynamicRuleParameter)object2);
        }
        return arrayList;
    }

    public String[][] defineCommandNames() {
        return new String[][]{COMMAND_NAME};
    }

    @Override
    public void adjustCommandDefinition(CommandDefinition commandDefinition) {
        super.adjustCommandDefinition(commandDefinition);
        commandDefinition.setShortDescription("CLI-guided configuration of the named check");
        commandDefinition.setGroupShortDescription(new String[]{"checks"}, "Quality Checks commands");
    }

    private static /* synthetic */ boolean lambda$promptForParameters$3(RuleParameter ruleParameter, DynamicRuleParameter dynamicRuleParameter) {
        return dynamicRuleParameter.getParameterAsEnum() == ruleParameter.getParameter();
    }

    private static /* synthetic */ boolean lambda$run$1(String string, AbstractLiquibaseRule abstractLiquibaseRule) {
        return abstractLiquibaseRule.getShortName().equalsIgnoreCase(string);
    }

    static {
        CommandBuilder commandBuilder = new CommandBuilder((String[][])new String[][]{COMMAND_NAME});
        CHECK_NAME_ARG = commandBuilder.argument("checkName", String.class).required().description("Name of check to configure").build();
        CHECKS_SETTINGS_FILE_ARG = commandBuilder.argument("checksSettingsFile", String.class).description("Relative or fully qualified path to a configuration file for checks execution").build();
        CHECKS_AUTO_UPDATE_ARG = commandBuilder.argument("autoUpdate", String.class).description("Allows automatic backup and updating of liquibase.checks.conf file when new quality checks are available. Options: [on|off]").setValueHandler(object -> {
            if (object == null) {
                return null;
            }
            if (((String)(object = (String)object)).equalsIgnoreCase("on") || ((String)object).equalsIgnoreCase("off")) {
                return object;
            }
            object = "\nWARNING:  The autoUpdate value '" + (String)object + "' is not valid.  Valid values include: 'on' or 'off'";
            throw new IllegalArgumentException((String)object);
        }).build();
    }
}

