/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.license;

import liquibase.Scope;
import liquibase.change.AbstractChange;
import liquibase.change.Change;
import liquibase.change.ChangeFactory;
import liquibase.database.Database;
import liquibase.exception.ValidationErrors;
import liquibase.license.LicenseService;
import liquibase.license.LicenseServiceFactory;
import liquibase.license.pro.LicenseTier;

public abstract class LicenseValidationChange
extends AbstractChange {
    public ValidationErrors validate(Database database) {
        ValidationErrors validationErrors = LicenseValidationChange.checkForValidLicense(LicenseTier.PRO, (Change)this);
        if (validationErrors.hasErrors()) {
            return validationErrors;
        }
        return super.validate(database);
    }

    public static ValidationErrors checkForValidLicense(LicenseTier object, Change object2) {
        LicenseService licenseService = ((LicenseServiceFactory)Scope.getCurrentScope().getSingleton(LicenseServiceFactory.class)).getLicenseService();
        if (licenseService == null) {
            return new ValidationErrors();
        }
        if (licenseService.licenseIsValid(object.getSubject())) {
            object = String.format("Found valid license with subject '%s' for '%s'", object.getSubject(), object2.getDescription());
            Scope.getCurrentScope().getLog(LicenseService.class).fine((String)object);
            return new ValidationErrors();
        }
        object = object2.getChangeSet();
        object2 = ((ChangeFactory)Scope.getCurrentScope().getSingleton(ChangeFactory.class)).getChangeMetaData(object2).getName();
        licenseService = new ValidationErrors();
        object = "Change Set ID: " + object.getId() + " Change Set Author: " + object.getAuthor() + "\n";
        object = (String)object + "Change Type 'pro:" + (String)object2 + "' is not allowed without a valid Liquibase Pro License.\n";
        object = (String)object + "To purchase or renew a Liquibase Pro license key, please contact sales@liquibase.com or\ngo to https://www.liquibase.com/pricing";
        licenseService.addError((String)object);
        return licenseService;
    }
}

