/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.changelog.filter;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import liquibase.Scope;
import liquibase.change.Change;
import liquibase.changelog.ChangeSet;
import liquibase.changelog.DatabaseChangeLog;
import liquibase.changelog.RanChangeSet;
import liquibase.changelog.filter.ChangeSetFilter;
import liquibase.changelog.filter.ChangeSetFilterResult;
import liquibase.database.Database;
import liquibase.exception.LiquibaseException;

public class DeploymentIdFilter
implements ChangeSetFilter {
    private String commandName;
    private Map<String, ChangeSet> deployedChangeSets = new LinkedHashMap<String, ChangeSet>();
    private Map<String, ChangeSet> noInverseChangeSets = new LinkedHashMap<String, ChangeSet>();

    public DeploymentIdFilter(String string, Database database, List<RanChangeSet> object, DatabaseChangeLog databaseChangeLog, String object2) {
        this.commandName = object2;
        object = object.iterator();
        while (object.hasNext()) {
            object2 = (RanChangeSet)object.next();
            if (object2.getDeploymentId() == null || !object2.getDeploymentId().equals(string)) continue;
            boolean bl2 = true;
            ChangeSet changeSet = databaseChangeLog.getChangeSet(object2.getChangeLog(), object2.getAuthor(), object2.getId());
            if (changeSet == null) {
                object2 = this.createNotFoundErrorMessage(databaseChangeLog, object2.getId(), object2.getAuthor(), object2.getChangeLog());
                Scope.getCurrentScope().getLog(this.getClass()).warning((String)object2);
                throw new LiquibaseException((String)object2);
            }
            if (changeSet.getRollback().getChanges().size() == 0) {
                object2 = changeSet.getChanges().iterator();
                while (object2.hasNext()) {
                    if (((Change)object2.next()).supportsRollback(database)) continue;
                    this.noInverseChangeSets.put(changeSet.toString(), changeSet);
                    bl2 = false;
                    break;
                }
            }
            if (!bl2) continue;
            this.deployedChangeSets.put(changeSet.toString(), changeSet);
        }
    }

    private String createNotFoundErrorMessage(DatabaseChangeLog object, String string, String string2, String string3) {
        List list = object.getChangeSets();
        String string4 = "\nWARNING: The command '" + this.commandName + "' failed because the changeset targeted by '" + string + "::" + string2 + "::" + string3 + "'\ncannot be located.  ";
        for (ChangeSet changeSet : list) {
            if (!DatabaseChangeLog.normalizePath((String)changeSet.getFilePath()).equalsIgnoreCase(DatabaseChangeLog.normalizePath((String)string3))) {
                return string4 + "The path '" + changeSet.getFilePath() + "' does not resolve to the desired changelog. One solution may be to control the lookup path of\nyour changeLogFile by adding it's base directory to the --classpath flag and removing any relative path information from the --changeLogFile flag.";
            }
            if (!changeSet.getAuthor().equalsIgnoreCase(string2)) {
                return string4 + "The changelog author '" + changeSet.getAuthor() + "' does not match the change set author '" + string2 + "'";
            }
            if (!changeSet.getId().equalsIgnoreCase(string)) {
                return string4 + "The changelog ID '" + changeSet.getId() + "' does not match the change set ID '" + string + "'";
            }
            if (object.isDbmsMatch(changeSet.getDbmsSet())) continue;
            object = object.getChangeLogParameters().getValue("database.typeName", object).toString();
            return string4 + "The changelog DBMS: '" + (String)object + "'  does not match the change set DBMS '" + changeSet.getDbmsSet().toString() + "'";
        }
        if (list.isEmpty()) {
            return string4 + "There are no changesets associated with this changelog";
        }
        return "";
    }

    public Map<String, ChangeSet> getNoInverseChangeSets() {
        return this.noInverseChangeSets;
    }

    public boolean isEmpty() {
        return this.deployedChangeSets.isEmpty();
    }

    public ChangeSetFilterResult accepts(ChangeSet object) {
        if (this.deployedChangeSets.containsKey(object = object.toString())) {
            return new ChangeSetFilterResult(true, "Change set to rollback is ".concat(String.valueOf(object)), this.getClass());
        }
        return new ChangeSetFilterResult(false, "Change set " + (String)object + " will not rollback", this.getClass());
    }
}

