/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.flow.action;

import com.datical.liquibase.ext.command.FlowCommandStep;
import com.datical.liquibase.ext.flow.action.Action;
import com.datical.liquibase.ext.flow.file.FlowVariableExpander;
import com.datical.liquibase.ext.flow.provider.ActionGlobalArgsValueProvider;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import liquibase.Scope;
import liquibase.command.CommandDefinition;
import liquibase.command.CommandFactory;
import liquibase.command.CommandResultsBuilder;
import liquibase.command.CommandScope;
import liquibase.command.core.StartH2CommandStep;
import liquibase.configuration.ConfigurationValueProvider;
import liquibase.configuration.LiquibaseConfiguration;
import liquibase.exception.CommandExecutionException;
import liquibase.exception.CommandValidationException;
import liquibase.integration.commandline.LiquibaseCommandLineConfiguration;
import liquibase.util.StringUtil;

public class LiquibaseCommandAction
implements Action {
    private String command;
    private static final String CMD_ARGS = "cmdArgs";
    private static final String GLOBAL_ARGS = "globalArgs";
    private Map<String, Object> cmdArgs = new HashMap<String, Object>();
    private Map<String, Object> globalArgs = new HashMap<String, Object>();
    private static final Set<String[]> forbiddenCommandNames = new HashSet<String[]>();
    private static final String[] forbiddenGlobalArgs = new String[]{"CLASSPATH", "SEARCHPATH", "PROMPT_FOR_NON_LOCAL_DATABASE", "INCLUDE_SYSTEM_CLASSPATH", "DEFAULTS_FILE", "LOG_LEVEL", "LOG_CHANNELS", "LOG_FILE", "SHOULD_RUN", "ARGUMENT_CONVERTER", "MONITOR_PERFORMANCE", "SHOW_BANNER"};

    public LiquibaseCommandAction() {
        forbiddenCommandNames.add(StartH2CommandStep.COMMAND_NAME);
    }

    @Override
    public String getType() {
        return "liquibase";
    }

    public String getCommand() {
        return this.command;
    }

    public void setCommand(String string) {
        this.command = string;
    }

    public Map<String, Object> getCmdArgs() {
        return this.cmdArgs;
    }

    public void setCmdArgs(Map<String, Object> map) {
        this.cmdArgs = map;
    }

    public Map<String, Object> getGlobalArgs() {
        return this.globalArgs;
    }

    public void setGlobalArgs(Map<String, Object> map) {
        this.globalArgs = map;
    }

    @Override
    public Action fromAction(Map<String, Object> map, Map<String, Object> map2) {
        LiquibaseCommandAction liquibaseCommandAction = new LiquibaseCommandAction();
        liquibaseCommandAction.setCommand((String)map.get("command"));
        liquibaseCommandAction.setCmdArgs(FlowVariableExpander.expandVariables((Map)map.get(CMD_ARGS), map2));
        map = FlowVariableExpander.expandVariables((Map)map.get(GLOBAL_ARGS), map2);
        liquibaseCommandAction.setGlobalArgs(map);
        return liquibaseCommandAction;
    }

    @Override
    public void execute(CommandResultsBuilder commandResultsBuilder) {
        Scope.getCurrentScope().getLog(LiquibaseCommandAction.class).info("Executing command '" + this.command + "'");
        CommandScope commandScope = this.createActionCommandScope(commandResultsBuilder);
        LiquibaseConfiguration liquibaseConfiguration = (LiquibaseConfiguration)Scope.getCurrentScope().getSingleton(LiquibaseConfiguration.class);
        ActionGlobalArgsValueProvider actionGlobalArgsValueProvider = new ActionGlobalArgsValueProvider(this.globalArgs);
        try {
            liquibaseConfiguration.registerProvider((ConfigurationValueProvider)actionGlobalArgsValueProvider);
            this.handleOutputStream(commandResultsBuilder, commandScope);
            commandScope = commandScope.execute();
            if (commandResultsBuilder != null) {
                commandResultsBuilder.addResult("statusCode:" + this.getCommand().toLowerCase(), commandScope.getResult("statusCode"));
            }
            return;
        }
        catch (Exception exception) {
            throw new CommandExecutionException((Throwable)exception);
        }
        finally {
            liquibaseConfiguration.unregisterProvider((ConfigurationValueProvider)actionGlobalArgsValueProvider);
        }
    }

    @Override
    public void validate(String string) {
        if (StringUtil.isEmpty((String)this.getCommand())) {
            throw new CommandValidationException("Command cannot be empty.");
        }
        StringBuilder stringBuilder = new StringBuilder();
        if (this.globalArgs != null) {
            this.checkForForbiddenGlobals(stringBuilder);
        }
        if (this.cmdArgs != null) {
            LiquibaseCommandAction liquibaseCommandAction = this;
            liquibaseCommandAction.checkForUnexpandedVariables(liquibaseCommandAction.cmdArgs, "command", stringBuilder);
        }
        if (this.globalArgs != null) {
            LiquibaseCommandAction liquibaseCommandAction = this;
            liquibaseCommandAction.checkForUnexpandedVariables(liquibaseCommandAction.globalArgs, "global", stringBuilder);
        }
        if (stringBuilder.length() > 0) {
            throw new CommandValidationException(stringBuilder.toString());
        }
        stringBuilder = this.createActionCommandScope(null);
        this.checkForForbiddenCommand((CommandScope)stringBuilder);
        this.checkForCircularReference(string, (CommandScope)stringBuilder);
        stringBuilder.validate();
    }

    private void checkForCircularReference(String string, CommandScope object) {
        if (Arrays.equals(object.getCommand().getName(), FlowCommandStep.COMMAND_NAME) && string.equals(object = (String)object.getArgumentValue(FlowCommandStep.FLOW_FILE))) {
            throw new CommandValidationException("Circular references between flow files are not allowed.");
        }
    }

    private void checkForForbiddenCommand(CommandScope commandScope) {
        if (forbiddenCommandNames.contains((commandScope = commandScope.getCommand()).getName())) {
            throw new CommandValidationException("Command " + StringUtil.join((String[])commandScope.getName(), (String)" ") + " is not allowed in flow files.");
        }
    }

    public String toString() {
        return String.format("'%s' %s", this.getType(), this.command);
    }

    private void handleOutputStream(CommandResultsBuilder commandResultsBuilder, CommandScope commandScope) {
        OutputStream outputStream = this.getOutputStream();
        if (outputStream != null) {
            commandScope.setOutput(outputStream);
            return;
        }
        if (commandResultsBuilder != null) {
            commandScope.setOutput(commandResultsBuilder.getOutputStream());
        }
    }

    private void checkForUnexpandedVariables(Map<String, Object> map, String string3, StringBuilder stringBuilder) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        map.forEach((string, object) -> {
            if (((String)(object = String.valueOf(object))).contains("${") && ((String)object).contains("}")) {
                hashMap.put((String)string, (String)object);
            }
        });
        if (!hashMap.isEmpty()) {
            stringBuilder.append(System.lineSeparator());
            stringBuilder.append(String.format("The following %s arguments for the command '%s' were not resolved:%n", string3, this.getCommand()));
            hashMap.forEach((string, string2) -> stringBuilder.append(String.format("    %s : %s%n", string, string2)));
        }
    }

    private void checkForForbiddenGlobals(StringBuilder stringBuilder) {
        Object object3 = new ArrayList();
        this.globalArgs.forEach((object, object2) -> {
            object = Arrays.stream(forbiddenGlobalArgs).filter(arg_0 -> LiquibaseCommandAction.lambda$null$2((String)object, arg_0)).collect(Collectors.toList());
            object3.addAll(object);
        });
        if (!object3.isEmpty()) {
            Scope.getCurrentScope().getUI().sendMessage("");
            String string = String.format("The following global arguments cannot be set within the flow file.%nThey must be set in the flow command, such as 'liquibase --the-global-arg=<somevalue> flow'.", new Object[0]);
            stringBuilder.append(System.lineSeparator());
            stringBuilder.append(string);
            stringBuilder.append(System.lineSeparator());
            object3 = object3.iterator();
            while (object3.hasNext()) {
                string = (String)object3.next();
                stringBuilder.append(String.format("    %s%n", string));
            }
        }
    }

    private OutputStream getOutputStream() {
        File file = (File)LiquibaseCommandLineConfiguration.OUTPUT_FILE.getCurrentValue();
        FileOutputStream fileOutputStream = null;
        try {
            if (file != null) {
                fileOutputStream = new FileOutputStream(file);
            }
        }
        catch (IOException iOException) {}
        return fileOutputStream;
    }

    private CommandScope createActionCommandScope(CommandResultsBuilder commandResultsBuilder) {
        CommandScope commandScope = this.getActualCommandName();
        commandScope = new CommandScope((String[])commandScope);
        if (this.cmdArgs != null) {
            for (Map.Entry<String, Object> entry : this.cmdArgs.entrySet()) {
                commandScope.addArgumentValue(entry.getKey(), entry.getValue());
            }
        }
        if (commandResultsBuilder != null) {
            commandScope.setOutput(commandResultsBuilder.getOutputStream());
        }
        return commandScope;
    }

    private String[] getActualCommandName() {
        Object object = (CommandFactory)Scope.getCurrentScope().getSingleton(CommandFactory.class);
        Object[] objectArray = StringUtil.toCamelCase((String)this.getCommand()).split(" ");
        if ((object = object.getCommands(false).stream().filter(arg_0 -> LiquibaseCommandAction.lambda$getActualCommandName$4((String[])objectArray, arg_0)).collect(Collectors.toList())).isEmpty()) {
            throw new CommandExecutionException("Unable to locate command " + Arrays.toString(objectArray));
        }
        return ((CommandDefinition)object.get(0)).getName();
    }

    private static /* synthetic */ boolean lambda$getActualCommandName$4(String[] stringArray, CommandDefinition stringArray2) {
        stringArray2 = stringArray2.getName();
        boolean bl2 = true;
        for (int i2 = 0; i2 < stringArray2.length; ++i2) {
            String string = stringArray2[i2];
            if (stringArray.length > i2) {
                if (!bl2) continue;
                bl2 = string.equalsIgnoreCase(stringArray[i2]);
                continue;
            }
            bl2 = false;
        }
        return bl2;
    }

    private static /* synthetic */ boolean lambda$null$2(String string, String string2) {
        return string2.equalsIgnoreCase(string);
    }
}

