/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.storedlogic.databasepackage;

import com.datical.liquibase.ext.storedlogic.AbstractMissingStoredLogicChangeGenerator;
import com.datical.liquibase.ext.storedlogic.databasepackage.DatabasePackage;
import com.datical.liquibase.ext.storedlogic.databasepackage.DatabasePackageBody;
import com.datical.liquibase.ext.storedlogic.databasepackage.change.CreatePackageBodyChange;
import com.datical.liquibase.ext.storedlogic.function.Function;
import liquibase.change.Change;
import liquibase.database.Database;
import liquibase.diff.output.DiffOutputControl;
import liquibase.diff.output.changelog.ChangeGeneratorChain;
import liquibase.structure.DatabaseObject;
import liquibase.structure.core.StoredDatabaseLogic;
import liquibase.structure.core.StoredProcedure;

public class MissingPackageBodyChangeGenerator
extends AbstractMissingStoredLogicChangeGenerator {
    @Override
    public int getPriority(Class<? extends DatabaseObject> clazz, Database database) {
        if (DatabasePackageBody.class.isAssignableFrom(clazz)) {
            return 101;
        }
        return -1;
    }

    @Override
    public Class<? extends DatabaseObject>[] runAfterTypes() {
        return new Class[]{Function.class, StoredProcedure.class, DatabasePackage.class};
    }

    public Change[] fixMissing(DatabaseObject databaseObject, DiffOutputControl diffOutputControl, Database object, Database database, ChangeGeneratorChain changeGeneratorChain) {
        object = new CreatePackageBodyChange();
        if (diffOutputControl.getIncludeCatalog()) {
            object.setCatalogName(databaseObject.getSchema().getCatalogName());
        }
        if (diffOutputControl.getIncludeSchema()) {
            object.setSchemaName(databaseObject.getSchema().getName());
        }
        ((CreatePackageBodyChange)((Object)object)).setPackageBodyName(databaseObject.getName());
        ((CreatePackageBodyChange)((Object)object)).setPackageBodyText(((StoredDatabaseLogic)databaseObject).getBody());
        return new Change[]{object};
    }
}

