/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.storedlogic.function.change;

import com.datical.liquibase.ext.storedlogic.function.Function;
import com.datical.liquibase.ext.storedlogic.function.change.DropFunctionStatement;
import liquibase.database.Database;
import liquibase.database.core.MSSQLDatabase;
import liquibase.database.core.PostgresDatabase;
import liquibase.database.core.SnowflakeDatabase;
import liquibase.exception.ValidationErrors;
import liquibase.sql.Sql;
import liquibase.sql.UnparsedSql;
import liquibase.sqlgenerator.SqlGeneratorChain;
import liquibase.sqlgenerator.core.AbstractSqlGenerator;
import liquibase.structure.DatabaseObject;
import liquibase.structure.core.Schema;

public class DropFunctionGenerator
extends AbstractSqlGenerator<DropFunctionStatement> {
    public ValidationErrors validate(DropFunctionStatement dropFunctionStatement, Database database, SqlGeneratorChain sqlGeneratorChain) {
        sqlGeneratorChain = new ValidationErrors();
        sqlGeneratorChain.checkRequiredField("functionName", (Object)dropFunctionStatement.getFunctionName());
        sqlGeneratorChain.checkDisallowedField("catalogName", (Object)dropFunctionStatement.getCatalogName(), database, new Class[]{MSSQLDatabase.class});
        return sqlGeneratorChain;
    }

    public Sql[] generateSql(DropFunctionStatement dropFunctionStatement, Database database, SqlGeneratorChain object) {
        String string;
        object = database.escapeObjectName(dropFunctionStatement.getCatalogName(), dropFunctionStatement.getSchemaName(), dropFunctionStatement.getFunctionName(), Function.class);
        if (database instanceof PostgresDatabase || database instanceof SnowflakeDatabase) {
            string = dropFunctionStatement.getSchemaName() == null ? database.getDefaultSchemaName() : dropFunctionStatement.getSchemaName();
            if (string != null) {
                object = database.escapeObjectName(string, Schema.class) + "." + dropFunctionStatement.getFunctionName();
            }
            if (database instanceof PostgresDatabase && !DropFunctionGenerator.supportsUniqueFunctionDrop(database)) {
                object = (String)object + "()";
            }
        }
        string = new UnparsedSql("DROP FUNCTION ".concat(String.valueOf(object)), new DatabaseObject[]{((Function)new Function().setName(dropFunctionStatement.getFunctionName())).setSchema(new Schema(dropFunctionStatement.getCatalogName(), dropFunctionStatement.getSchemaName()))});
        return new Sql[]{string};
    }

    private static boolean supportsUniqueFunctionDrop(Database database) {
        try {
            return database.getDatabaseMajorVersion() > 9;
        }
        catch (Exception exception) {
            return false;
        }
    }
}

