/*
 * Decompiled with CFR 0.152.
 */
package liquibase.repackaged.net.sf.jsqlparser.statement.insert;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import liquibase.repackaged.net.sf.jsqlparser.expression.Expression;
import liquibase.repackaged.net.sf.jsqlparser.schema.Column;
import liquibase.repackaged.net.sf.jsqlparser.statement.insert.ConflictActionType;
import liquibase.repackaged.net.sf.jsqlparser.statement.update.UpdateSet;

public class InsertConflictAction {
    ConflictActionType conflictActionType;
    private final ArrayList<UpdateSet> updateSets = new ArrayList();
    Expression whereExpression;

    public InsertConflictAction(ConflictActionType conflictActionType) {
        this.conflictActionType = Objects.requireNonNull(conflictActionType, "The Conflict Action Type is mandatory and must not be Null.");
    }

    public ConflictActionType getConflictActionType() {
        return this.conflictActionType;
    }

    public void setConflictActionType(ConflictActionType conflictActionType) {
        this.conflictActionType = Objects.requireNonNull(conflictActionType, "The Conflict Action Type is mandatory and must not be Null.");
    }

    public InsertConflictAction withConflictActionType(ConflictActionType conflictActionType) {
        this.setConflictActionType(conflictActionType);
        return this;
    }

    public InsertConflictAction addUpdateSet(Column column, Expression expression) {
        this.updateSets.add(new UpdateSet(column, expression));
        return this;
    }

    public InsertConflictAction addUpdateSet(UpdateSet updateSet) {
        this.updateSets.add(updateSet);
        return this;
    }

    public InsertConflictAction withUpdateSets(Collection<UpdateSet> collection) {
        this.updateSets.clear();
        this.updateSets.addAll(collection);
        return this;
    }

    public Expression getWhereExpression() {
        return this.whereExpression;
    }

    public void setWhereExpression(Expression expression) {
        this.whereExpression = expression;
    }

    public InsertConflictAction withWhereExpression(Expression expression) {
        this.setWhereExpression(expression);
        return this;
    }

    public StringBuilder appendTo(StringBuilder stringBuilder) {
        switch (this.conflictActionType) {
            case DO_NOTHING: {
                stringBuilder.append(" DO NOTHING");
                break;
            }
            case DO_UPDATE: {
                stringBuilder.append(" DO UPDATE ");
                UpdateSet.appendUpdateSetsTo(stringBuilder, this.updateSets);
                if (this.whereExpression == null) break;
                stringBuilder.append(" WHERE ").append(this.whereExpression);
            }
        }
        return stringBuilder;
    }

    public String toString() {
        return this.appendTo(new StringBuilder()).toString();
    }
}

