/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.checks.config;

import com.datical.liquibase.ext.checks.config.CheckSettingsConfigYaml;
import com.datical.liquibase.ext.checks.config.ChecksFileAccessor;
import com.datical.liquibase.ext.checks.config.FileAccessor;
import com.datical.liquibase.ext.checks.config.FileAccessorDTO;
import com.datical.liquibase.ext.checks.config.InMemoryChecksFileAccessor;
import com.datical.liquibase.ext.checks.config.cli.RuleParameter;
import com.datical.liquibase.ext.checks.config.model.AbstractConfigurableRule;
import com.datical.liquibase.ext.checks.config.model.CheckSettingsConfig;
import com.datical.liquibase.ext.checks.config.model.DynamicRule;
import com.datical.liquibase.ext.checks.config.model.DynamicRuleParameter;
import com.datical.liquibase.ext.rules.api.SeverityEnum;
import com.datical.liquibase.ext.rules.core.AbstractLiquibaseRule;
import com.datical.liquibase.ext.ui.NoEmptyValueInputHandler;
import com.datical.liquibase.ext.util.ResourceUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import liquibase.GlobalConfiguration;
import liquibase.Scope;
import liquibase.exception.CommandExecutionException;
import liquibase.integration.commandline.LiquibaseCommandLineConfiguration;
import liquibase.resource.Resource;
import liquibase.resource.ResourceAccessor;
import liquibase.resource.SearchPathResourceAccessor;
import liquibase.util.StringUtil;

public class CheckSettingsConfigHelper {
    public static final String LIQUIBASE_CHECKS_SETTINGS_CONF = "liquibase.checks-settings.conf";
    private String checkSettingsFilename;
    private String autoUpdate;
    private boolean headless;
    private boolean usedDefaultChecksSettingsFilename;
    private final FileAccessor fileAccessor;
    private final CheckSettingsConfigYaml yaml = new CheckSettingsConfigYaml();

    public CheckSettingsConfigHelper(String string, String string2) {
        this.headless = (Boolean)GlobalConfiguration.HEADLESS.getCurrentConfiguredValue().getValue();
        this.fileAccessor = (FileAccessor)Scope.getCurrentScope().get("fileAccessor", (Object)new ChecksFileAccessor());
        if (StringUtil.isEmpty((String)string)) {
            this.usedDefaultChecksSettingsFilename = true;
            this.checkSettingsFilename = LIQUIBASE_CHECKS_SETTINGS_CONF;
        } else {
            this.usedDefaultChecksSettingsFilename = false;
            this.checkSettingsFilename = string;
        }
        this.autoUpdate = string2;
    }

    public CheckSettingsConfig read(List<AbstractLiquibaseRule> list) {
        boolean bl2;
        CheckSettingsConfig checkSettingsConfig;
        Object object;
        try {
            object = this.fileAccessor.loadFileContents(this.checkSettingsFilename);
        }
        catch (FileNotFoundException fileNotFoundException) {
            if (this.headless || !this.usedDefaultChecksSettingsFilename) {
                throw fileNotFoundException;
            }
            if (GlobalConfiguration.SEARCH_PATH.getCurrentValue() != null && ResourceUtil.isAbsolute(this.checkSettingsFilename)) {
                String string2 = "Unable to locate, read, or update checks-settings file. Invalid paths occur when both search path is set and check-settings.conf file is set with an absolute path.Please re-configure these properties to generate a valid path.";
                Scope.getCurrentScope().getLog(CheckSettingsConfigHelper.class).severe(string2);
                throw new IllegalArgumentException(string2);
            }
            String string3 = (String)Scope.getCurrentScope().getUI().prompt("WARNING: No default checks-settings file detected. Would you like to create and automatically use 'liquibase.checks-settings.conf' ?" + System.lineSeparator() + "[1] Yes, create and use default check-settings file in the Current Working Directory" + System.lineSeparator() + "[2] Yes, create and use default check-settings file at a path I will specify" + System.lineSeparator() + "[3] Just create default check-settings file in the CWD, do not use, and exit command" + System.lineSeparator() + "[n] No, do not create default check-settings file, and exit command" + System.lineSeparator(), (Object)"1", (string, clazz) -> {
                if (string == null || !string.equalsIgnoreCase("1") && !string.equalsIgnoreCase("2") && !string.equalsIgnoreCase("3") && !string.equalsIgnoreCase("n")) {
                    throw new IllegalArgumentException();
                }
                return string;
            }, String.class);
            if (string3.equalsIgnoreCase("n")) {
                Scope.getCurrentScope().getUI().sendMessage("No changes have been made to default check configuration, because you chose to not create a liquibase.checks-settings.conf file.");
                return null;
            }
            if (string3.equals("3")) {
                this.checkSettingsFilename = LIQUIBASE_CHECKS_SETTINGS_CONF;
                this.createFile(list);
                return null;
            }
            if (string3.equals("2")) {
                this.checkSettingsFilename = (String)Scope.getCurrentScope().getUI().prompt("Please enter a relative or absolute, local or remote path. To use a remote path, such as \"s3://<mybucket>\", please install the correct extension. Learn more about remote path options at http://docs.liquibase.com/s3", null, new NoEmptyValueInputHandler(), String.class);
                this.checkSettingsFilename = this.checkSettingsFilename + "/liquibase.checks-settings.conf";
                return this.createFile(list);
            }
            return this.createFile(list);
        }
        try {
            checkSettingsConfig = CheckSettingsConfig.fromFileAccessorDTO((FileAccessorDTO)object);
        }
        catch (Exception exception) {
            Scope.getCurrentScope().getLog(this.getClass()).severe("Failed to read the quality checks config file", (Throwable)exception);
            throw new CommandExecutionException("Liquibase cannot read '" + this.checkSettingsFilename + "'. The file may be corrupted or an incompatible version. Delete or rename the existing liquibase.checks-settings.conf. Generate a new liquibase.checks-settings.conf by running 'liquibase checks show'.");
        }
        Object object2 = checkSettingsConfig.getRules();
        if (!((FileAccessorDTO)object).versioned) {
            object2.forEach(abstractConfigurableRule -> abstractConfigurableRule.setSeverity(SeverityEnum.INFO));
            this.write(checkSettingsConfig);
        }
        if (((FileAccessorDTO)object).encoded) {
            this.write(checkSettingsConfig);
        }
        boolean bl3 = bl2 = this.autoUpdate == null || !this.autoUpdate.equalsIgnoreCase("off");
        if (!this.upToDate(list, (List<AbstractConfigurableRule>)object2)) {
            if (this.autoUpdate == null) {
                object2 = ((String)Scope.getCurrentScope().getUI().prompt(System.lineSeparator() + "New or Upgraded Quality Checks are available." + System.lineSeparator() + "Do you want to auto-backup and update '" + this.checkSettingsFilename + "' with the new checks? (Y/n/s)", (Object)"Y", (string, clazz) -> {
                    if (!(string != null && (string.equalsIgnoreCase("y") || string.equalsIgnoreCase("yes") || string.equalsIgnoreCase("n") || string.equalsIgnoreCase("no") || string.equalsIgnoreCase("s") || string.equalsIgnoreCase("skip")))) {
                        throw new IllegalArgumentException();
                    }
                    return string;
                }, String.class)).toLowerCase();
                if (((String)object2).startsWith("n")) {
                    this.updatePropertiesFile("\nliquibase.command.autoUpdate=off\n");
                    bl2 = false;
                } else if (((String)object2).startsWith("s")) {
                    bl2 = false;
                }
            }
            if (bl2) {
                object2 = ResourceUtil.getResource(this.checkSettingsFilename);
                AbstractLiquibaseRule abstractLiquibaseRule = CheckSettingsConfigHelper.calcBackupResource((Resource)object2);
                object = ((FileAccessorDTO)object).originalContents;
                ChecksFileAccessor.makeBackup((Resource)object2, (Resource)abstractLiquibaseRule, (String)object, null, true);
            }
        }
        for (AbstractLiquibaseRule abstractLiquibaseRule : list) {
            object = checkSettingsConfig.getRuleById(abstractLiquibaseRule.getId());
            if (object == null || ((AbstractConfigurableRule)object).getSeverity() == abstractLiquibaseRule.getSeverity()) continue;
            abstractLiquibaseRule.setSeverity(((AbstractConfigurableRule)object).getSeverity());
        }
        if (!bl2) {
            return checkSettingsConfig;
        }
        boolean bl4 = this.addMissingRules(list, checkSettingsConfig);
        boolean bl5 = this.addMissingParameters(list, checkSettingsConfig);
        if (bl4 || bl5) {
            this.write(checkSettingsConfig);
        }
        CheckSettingsConfigHelper.sortRulesByPriority(list, checkSettingsConfig);
        return checkSettingsConfig;
    }

    private CheckSettingsConfig createFile(List<AbstractLiquibaseRule> object) {
        this.write(CheckSettingsConfig.generateDefaultConfigFromRules(object, null), true);
        if (!(this.fileAccessor instanceof InMemoryChecksFileAccessor)) {
            Scope.getCurrentScope().getUI().sendMessage(this.checkSettingsFilename + " successfully created!");
            Scope.getCurrentScope().getLog(CheckSettingsConfigHelper.class).info(this.checkSettingsFilename + " successfully created!");
        }
        try {
            object = this.reloadFileAccessorDTO();
        }
        catch (Exception exception) {
            throw new IOException("Unable to load created defaults file '" + this.checkSettingsFilename + "'", exception);
        }
        return CheckSettingsConfig.fromFileAccessorDTO((FileAccessorDTO)object);
    }

    private FileAccessorDTO reloadFileAccessorDTO() {
        AtomicReference atomicReference = new AtomicReference();
        HashMap<String, SearchPathResourceAccessor> hashMap = new HashMap<String, SearchPathResourceAccessor>();
        hashMap.put(Scope.Attr.resourceAccessor.name(), new SearchPathResourceAccessor(".", new ResourceAccessor[0]));
        Scope.child(hashMap, () -> {
            Scope.getCurrentScope().getLog(CheckSettingsConfigHelper.class).info("Reloading new file '" + this.checkSettingsFilename + "'");
            FileAccessorDTO fileAccessorDTO = this.fileAccessor.loadFileContents(this.checkSettingsFilename);
            atomicReference.set(fileAccessorDTO);
        });
        return (FileAccessorDTO)atomicReference.get();
    }

    private boolean addMissingParameters(List<AbstractLiquibaseRule> object, CheckSettingsConfig checkSettingsConfig) {
        boolean bl2 = false;
        object = object.iterator();
        while (object.hasNext()) {
            AbstractLiquibaseRule abstractLiquibaseRule = (AbstractLiquibaseRule)object.next();
            for (AbstractConfigurableRule abstractConfigurableRule : checkSettingsConfig.getExecutableRulesByRuleId(abstractLiquibaseRule.getId())) {
                if (!(abstractConfigurableRule instanceof DynamicRule)) continue;
                DynamicRule dynamicRule = (DynamicRule)abstractConfigurableRule;
                for (RuleParameter<?> ruleParameter : abstractLiquibaseRule.getParameters()) {
                    try {
                        if (dynamicRule.getParameter(ruleParameter.getParameter()) != null || !ruleParameter.shouldPrompt(dynamicRule.getParameters())) continue;
                        ((DynamicRule)abstractConfigurableRule).getParameters().add(new DynamicRuleParameter(ruleParameter.getParameter(), ruleParameter.getDefaultValue()));
                        bl2 = true;
                    }
                    catch (Exception exception) {
                        Scope.getCurrentScope().getLog(this.getClass()).fine(String.format("Failed to find matching parameter for system rule: %s parameter: %s", new Object[]{abstractLiquibaseRule.getShortName(), ruleParameter.getParameter()}));
                    }
                }
            }
        }
        return bl2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void updatePropertiesFile(String object) {
        RandomAccessFile randomAccessFile;
        block11: {
            String string = (String)LiquibaseCommandLineConfiguration.DEFAULTS_FILE.getCurrentConfiguredValue().getValue();
            File file = null;
            if (string != null) {
                file = new File(string);
            }
            if (file == null) {
                return;
            }
            string = (String)GlobalConfiguration.OUTPUT_FILE_ENCODING.getCurrentValue();
            randomAccessFile = new RandomAccessFile(file, "rw");
            Throwable throwable = null;
            try {
                randomAccessFile.seek(file.length());
                randomAccessFile.write(((String)object).getBytes(string));
                if (throwable == null) break block11;
            }
            catch (Throwable throwable2) {
                try {
                    object = throwable2;
                    throwable = throwable2;
                    throw object;
                }
                catch (Throwable throwable4) {
                    if (throwable == null) {
                        randomAccessFile.close();
                        throw throwable4;
                    }
                    try {
                        randomAccessFile.close();
                        throw throwable4;
                    }
                    catch (Throwable throwable5) {
                        throwable.addSuppressed(throwable5);
                        throw throwable4;
                    }
                }
            }
            try {
                randomAccessFile.close();
                return;
            }
            catch (Throwable throwable2) {
                throwable.addSuppressed(throwable2);
                return;
            }
        }
        randomAccessFile.close();
    }

    private boolean upToDate(List<AbstractLiquibaseRule> list, List<AbstractConfigurableRule> list2) {
        return list.stream().allMatch(abstractLiquibaseRule -> {
            if (((Optional)(list2 = CheckSettingsConfig.findRuleById(list2, abstractLiquibaseRule.getId()))).isPresent()) {
                if ((list2 = (AbstractConfigurableRule)((Optional)((Object)list2)).get()) instanceof DynamicRule) {
                    return abstractLiquibaseRule.getParameters().stream().allMatch(arg_0 -> CheckSettingsConfigHelper.lambda$null$4((AbstractConfigurableRule)((Object)list2), arg_0));
                }
                return true;
            }
            return false;
        });
    }

    private static Resource calcBackupResource(Resource resource) {
        String string;
        int n2 = 1;
        Object object = Pattern.compile("(.*).backup.([0-9])+$").matcher(resource.getPath());
        if (((Matcher)object).matches()) {
            string = ((Matcher)object).group(2);
            n2 = Integer.parseInt(string) + 1;
            object = CheckSettingsConfigHelper.determineSimpleName(resource).replaceAll("backup\\." + CheckSettingsConfigHelper.newVersion(Integer.parseInt(string)), "backup." + CheckSettingsConfigHelper.newVersion(n2));
        } else {
            string = CheckSettingsConfigHelper.determineSimpleName(resource);
            object = string + ".backup." + CheckSettingsConfigHelper.newVersion(1);
        }
        object = resource.resolveSibling((String)object);
        boolean bl2 = true;
        while (bl2) {
            bl2 = object.exists();
            if (!bl2) continue;
            object = CheckSettingsConfigHelper.determineSimpleName(resource);
            object = (String)object + ".backup." + CheckSettingsConfigHelper.newVersion(++n2);
            object = resource.resolveSibling((String)object);
        }
        return object;
    }

    private static String determineSimpleName(Resource object) {
        object = ((String[])(object = object.getPath().replace("\\", "/").split("/"))).length == 1 ? object[0] : object[((String[])object).length - 1];
        return object;
    }

    private static File calcBackupFile(File file) {
        int n2 = 1;
        Object object = Pattern.compile("(.*).backup.([0-9])+$").matcher(file.getName());
        if (((Matcher)object).matches()) {
            String string = ((Matcher)object).group(2);
            n2 = Integer.parseInt(string) + 1;
            object = new File(file.getParentFile(), file.getName().replaceAll("backup\\." + CheckSettingsConfigHelper.newVersion(Integer.parseInt(string)), "backup." + CheckSettingsConfigHelper.newVersion(n2)));
        } else {
            object = new File(file.getParentFile(), file.getName() + ".backup." + CheckSettingsConfigHelper.newVersion(1));
        }
        boolean bl2 = true;
        while (bl2) {
            bl2 = ((File)object).exists();
            if (!bl2) continue;
            object = new File(file.getParentFile(), file.getName() + ".backup." + CheckSettingsConfigHelper.newVersion(++n2));
        }
        return object;
    }

    private static String newVersion(int n2) {
        if (n2 < 10) {
            return "0".concat(String.valueOf(n2));
        }
        return Integer.toString(n2);
    }

    public CheckSettingsConfigHelper(FileAccessor fileAccessor) {
        this.fileAccessor = fileAccessor;
        this.checkSettingsFilename = LIQUIBASE_CHECKS_SETTINGS_CONF;
    }

    public static void sortRulesByPriority(List<AbstractLiquibaseRule> object, CheckSettingsConfig checkSettingsConfig) {
        ArrayList<AbstractConfigurableRule> arrayList = new ArrayList<AbstractConfigurableRule>(checkSettingsConfig.getRules().size());
        if (object != null) {
            object = object.iterator();
            while (object.hasNext()) {
                AbstractLiquibaseRule abstractLiquibaseRule = (AbstractLiquibaseRule)object.next();
                arrayList.addAll(checkSettingsConfig.getExecutableRulesByRuleId(abstractLiquibaseRule.getId()));
            }
        }
        CheckSettingsConfig checkSettingsConfig2 = checkSettingsConfig;
        checkSettingsConfig2.setUnrecognizedRules(checkSettingsConfig2.getRules().stream().filter(abstractConfigurableRule -> !arrayList.contains(abstractConfigurableRule)).collect(Collectors.toList()));
        checkSettingsConfig.setRules(arrayList);
    }

    private boolean addMissingRules(List<AbstractLiquibaseRule> object, CheckSettingsConfig checkSettingsConfig) {
        boolean bl2 = false;
        if (object != null) {
            object = object.iterator();
            while (object.hasNext()) {
                AbstractLiquibaseRule abstractLiquibaseRule = (AbstractLiquibaseRule)object.next();
                if (checkSettingsConfig.getRuleById(abstractLiquibaseRule.getId()) != null) continue;
                bl2 = checkSettingsConfig.getRules().add(AbstractConfigurableRule.fromRuleImplementation(abstractLiquibaseRule));
            }
        }
        return bl2;
    }

    public void write(CheckSettingsConfig checkSettingsConfig, boolean bl2) {
        String string = this.yaml.dump(checkSettingsConfig);
        this.fileAccessor.writeFileContents(checkSettingsConfig.getResource(), this.checkSettingsFilename, string, bl2);
    }

    public void write(CheckSettingsConfig checkSettingsConfig) {
        this.write(checkSettingsConfig, false);
    }

    private static /* synthetic */ boolean lambda$null$4(AbstractConfigurableRule abstractConfigurableRule, RuleParameter ruleParameter) {
        return ((DynamicRule)abstractConfigurableRule).getParameter(ruleParameter.getParameter()) != null;
    }
}

