/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.command;

import com.datical.liquibase.ext.command.AbstractFlowCommand;
import com.datical.liquibase.ext.flow.action.Action;
import com.datical.liquibase.ext.flow.file.FlowFile;
import com.datical.liquibase.ext.flow.file.Stage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import liquibase.Scope;
import liquibase.command.CommandArgumentDefinition;
import liquibase.command.CommandBuilder;
import liquibase.command.CommandDefinition;
import liquibase.command.CommandResultsBuilder;
import liquibase.exception.CommandExecutionException;
import liquibase.exception.CommandValidationException;

public class FlowValidateCommandStep
extends AbstractFlowCommand {
    public static final String[] COMMAND_NAME = new String[]{"flow", "validate"};
    public static final CommandArgumentDefinition<String> FLOW_FILE;
    public static final CommandArgumentDefinition<String> FLOW_INTEGRATION;
    public static final CommandArgumentDefinition<Boolean> FLOW_FILE_STRICT_PARSING;
    public static final String VALIDATED = "validated";

    private void validateActions(List<Action> object, Map<String, List<Exception>> map, String string) {
        object = object.iterator();
        while (object.hasNext()) {
            Action action = (Action)object.next();
            try {
                action.validate(string);
            }
            catch (CommandExecutionException commandExecutionException) {
                if (map.containsKey(action.toString())) {
                    map.get(action.toString()).add((Exception)((Object)commandExecutionException));
                    continue;
                }
                ArrayList<CommandExecutionException> arrayList = new ArrayList<CommandExecutionException>();
                arrayList.add(commandExecutionException);
                map.put(action.toString(), arrayList);
            }
        }
    }

    private void validateStage(Stage stage, String string, LinkedHashMap<String, Map<String, List<Exception>>> linkedHashMap, String string2, boolean bl2) {
        if (stage != null) {
            LinkedHashMap<String, List<Exception>> linkedHashMap2 = new LinkedHashMap<String, List<Exception>>();
            if (bl2 && string.equalsIgnoreCase("endstage")) {
                Scope.getCurrentScope().getUI().sendMessage("WARNING: The stage named " + string + " will not be guaranteed to execute by Liquibase Flow because it falls under the 'stages:' object in the flow file. To guarantee execution of this stage, it should be not be indented.");
            }
            this.validateActions(stage.getActions(), linkedHashMap2, string2);
            if (!linkedHashMap2.isEmpty()) {
                linkedHashMap.put(string, linkedHashMap2);
            }
        }
    }

    private void outputValidationErrors(LinkedHashMap<String, Map<String, List<Exception>>> object) {
        if (!((HashMap)((Object)object)).isEmpty()) {
            StringBuilder stringBuilder = new StringBuilder("ERROR: Flow file failed validation checks." + System.lineSeparator());
            for (Map.Entry entry : ((LinkedHashMap)((Object)object)).entrySet()) {
                Map map = (Map)entry.getValue();
                String object2 = (String)entry.getKey();
                for (Map.Entry entry2 : map.entrySet()) {
                    for (Exception exception : (List)entry2.getValue()) {
                        String string = (String)entry2.getKey();
                        stringBuilder.append("Invalid command in stage: ");
                        stringBuilder.append(object2);
                        stringBuilder.append(": ");
                        stringBuilder.append(string);
                        stringBuilder.append(": ");
                        stringBuilder.append(exception);
                        stringBuilder.append(System.lineSeparator());
                    }
                }
            }
            stringBuilder.append(System.lineSeparator());
            stringBuilder.append("Please review for errors. Learn more at https://docs.liquibase.com");
            Scope.getCurrentScope().getUI().sendMessage(stringBuilder.toString());
            throw new CommandValidationException("ERROR: Flow file failed validation checks. Please review for errors. Learn more at http://docs.liquibase.com");
        }
    }

    public String[][] defineCommandNames() {
        return new String[][]{COMMAND_NAME};
    }

    public void run(CommandResultsBuilder commandResultsBuilder) {
        Object object = commandResultsBuilder.getCommandScope();
        Object object2 = object.getConfiguredValue(FLOW_FILE);
        String string = null;
        try {
            string = (String)object2.getValue();
            object = this.loadFlowFileContents(string, object2.wasDefaultValueUsed(), (Boolean)object.getArgumentValue(FLOW_FILE_STRICT_PARSING) == false);
            if (object == null) {
                commandResultsBuilder.addResult(VALIDATED, (Object)Boolean.FALSE);
                return;
            }
            object2 = ((FlowFile)object).getStages();
            LinkedHashMap<String, Map<String, List<Exception>>> linkedHashMap = new LinkedHashMap<String, Map<String, List<Exception>>>();
            for (Map.Entry entry : ((LinkedHashMap)object2).entrySet()) {
                Stage stage = (Stage)entry.getValue();
                String object3 = (String)entry.getKey();
                this.validateStage(stage, object3, linkedHashMap, string, true);
            }
            this.validateStage(((FlowFile)object).getEndStage(), "endStage", linkedHashMap, string, false);
            this.outputValidationErrors(linkedHashMap);
        }
        catch (IOException iOException) {
            throw new CommandValidationException("Error opening file '" + string + "' " + iOException.getMessage());
        }
        Scope.getCurrentScope().getUI().sendMessage("Flow file " + string + " is valid.");
        commandResultsBuilder.addResult(VALIDATED, (Object)Boolean.TRUE);
        commandResultsBuilder.addResult("flowFile", object);
    }

    public void adjustCommandDefinition(CommandDefinition commandDefinition) {
        super.adjustCommandDefinition(commandDefinition);
        commandDefinition.setShortDescription("Validate a series of commands contained in one or more stages, as configured in a liquibase flow-file.");
    }

    static {
        CommandBuilder commandBuilder = new CommandBuilder((String[][])new String[][]{COMMAND_NAME});
        FLOW_FILE = commandBuilder.argument("flowFile", String.class).defaultValue((Object)"liquibase.flowfile.yaml").description("The path to the configuration yaml file which contains one or more 'stages' of commands to be executed in a liquibase flow operation. Defaults to yaml file named \"liquibase.flowfile.yaml\" in the current working directory.").build();
        FLOW_INTEGRATION = commandBuilder.argument("flowIntegration", String.class).hidden().defaultValue((Object)"cli").description("Name of the integration that is executing flow").build();
        FLOW_FILE_STRICT_PARSING = commandBuilder.argument("flowFileStrictParsing", Boolean.class).defaultValue((Object)Boolean.TRUE).description("Parse flow-file YAML to allow only Liquibase flow-file specific properties, indentations, and structure.").build();
    }
}

