/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.command;

import com.datical.liquibase.ext.command.UpdateOneChangeSetCommandStep;
import java.io.OutputStreamWriter;
import java.io.Writer;
import liquibase.GlobalConfiguration;
import liquibase.command.CommandArgumentDefinition;
import liquibase.command.CommandBuilder;
import liquibase.command.CommandDefinition;
import liquibase.command.CommandResultsBuilder;
import liquibase.command.CommonArgumentNames;
import liquibase.configuration.ConfigurationValueObfuscator;
import liquibase.license.LicenseServiceUtils;

public class UpdateOneChangeSetSqlCommandStep
extends UpdateOneChangeSetCommandStep {
    public static final String[] COMMAND_NAME = new String[]{"updateOneChangesetSql"};
    public static final CommandArgumentDefinition<String> CHANGESET_ID;
    public static final CommandArgumentDefinition<String> CHANGESET_AUTHOR;
    public static final CommandArgumentDefinition<String> CHANGESET_PATH;
    public static final CommandArgumentDefinition<String> URL_ARG;
    public static final CommandArgumentDefinition<String> DEFAULT_SCHEMA_NAME_ARG;
    public static final CommandArgumentDefinition<String> DEFAULT_CATALOG_NAME_ARG;
    public static final CommandArgumentDefinition<String> USERNAME_ARG;
    public static final CommandArgumentDefinition<String> PASSWORD_ARG;
    public static final CommandArgumentDefinition<String> DRIVER_ARG;
    public static final CommandArgumentDefinition<String> DRIVER_PROPERTIES_FILE_ARG;

    @Override
    public String[][] defineCommandNames() {
        return new String[][]{COMMAND_NAME};
    }

    @Override
    public void adjustCommandDefinition(CommandDefinition commandDefinition) {
        commandDefinition.setShortDescription("Generates sql to run single changeset");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run(CommandResultsBuilder object) {
        Writer writer;
        block9: {
            LicenseServiceUtils.checkProLicenseAndThrowException((String[])COMMAND_NAME);
            writer = this.getOutputWriter((CommandResultsBuilder)object);
            Throwable throwable = null;
            try {
                this.setWriter(writer);
                super.run((CommandResultsBuilder)object);
                writer.flush();
                if (writer == null) return;
                if (throwable == null) break block9;
            }
            catch (Throwable throwable2) {
                try {
                    object = throwable2;
                    throwable = throwable2;
                    throw object;
                }
                catch (Throwable throwable4) {
                    if (writer == null) throw throwable4;
                    if (throwable == null) {
                        writer.close();
                        throw throwable4;
                    }
                    try {
                        writer.close();
                        throw throwable4;
                    }
                    catch (Throwable throwable5) {
                        throwable.addSuppressed(throwable5);
                        throw throwable4;
                    }
                }
            }
            try {
                writer.close();
                return;
            }
            catch (Throwable throwable2) {
                throwable.addSuppressed(throwable2);
                return;
            }
        }
        writer.close();
    }

    private Writer getOutputWriter(CommandResultsBuilder commandResultsBuilder) {
        String string = (String)GlobalConfiguration.OUTPUT_FILE_ENCODING.getCurrentValue();
        return new OutputStreamWriter(commandResultsBuilder.getOutputStream(), string);
    }

    static {
        CommandBuilder commandBuilder = new CommandBuilder((String[][])new String[][]{COMMAND_NAME});
        CHANGESET_ID = commandBuilder.argument("changesetId", String.class).description("Id of the changeset to execute").required().build();
        CHANGESET_AUTHOR = commandBuilder.argument("changesetAuthor", String.class).description("Author of the changeset to execute").required().build();
        CHANGESET_PATH = commandBuilder.argument("changesetPath", String.class).description("Path to the changeset to execute").required().build();
        URL_ARG = commandBuilder.argument(CommonArgumentNames.URL, String.class).required().description("The JDBC target database connection URL").build();
        DEFAULT_SCHEMA_NAME_ARG = commandBuilder.argument("defaultSchemaName", String.class).description("The default schema name to use for the database connection").build();
        DEFAULT_CATALOG_NAME_ARG = commandBuilder.argument("defaultCatalogName", String.class).description("The default catalog name to use for the database connection").build();
        DRIVER_ARG = commandBuilder.argument("driver", String.class).description("The JDBC driver class").build();
        DRIVER_PROPERTIES_FILE_ARG = commandBuilder.argument("driverPropertiesFile", String.class).description("The JDBC driver properties file").build();
        USERNAME_ARG = commandBuilder.argument(CommonArgumentNames.USERNAME, String.class).description("The target database username").build();
        PASSWORD_ARG = commandBuilder.argument(CommonArgumentNames.PASSWORD, String.class).description("The target database password").setValueObfuscator(ConfigurationValueObfuscator.STANDARD).build();
    }
}

