/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.command.checks;

import com.datical.liquibase.ext.checks.config.CheckSettingsConfigHelper;
import com.datical.liquibase.ext.checks.config.InMemoryChecksFileAccessor;
import com.datical.liquibase.ext.checks.config.model.AbstractConfigurableRule;
import com.datical.liquibase.ext.checks.config.model.CheckSettingsConfig;
import com.datical.liquibase.ext.checks.config.model.DynamicRule;
import com.datical.liquibase.ext.command.checks.AbstractChecksCommandStep;
import com.datical.liquibase.ext.command.checks.ChecksRunCommandStep;
import com.datical.liquibase.ext.command.checks.ChecksTableColumns;
import com.datical.liquibase.ext.rules.api.ScopeEnum;
import com.datical.liquibase.ext.rules.core.AbstractLiquibaseRule;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import liquibase.GlobalConfiguration;
import liquibase.Scope;
import liquibase.command.CommandArgumentDefinition;
import liquibase.command.CommandBuilder;
import liquibase.command.CommandDefinition;
import liquibase.command.CommandResultsBuilder;
import liquibase.exception.CommandExecutionException;
import liquibase.util.StringUtil;
import liquibase.util.TableOutput;

public class ChecksShowCommandStep
extends AbstractChecksCommandStep {
    public static final String[] COMMAND_NAME = new String[]{"checks", "show"};
    public static final CommandArgumentDefinition<String> CHECKS_SETTINGS_FILE_ARG;
    public static final CommandArgumentDefinition<String> CHECKS_AUTO_UPDATE_ARG;
    public static final CommandArgumentDefinition<String> CHECKS_INTEGRATION_ARG;
    public static final CommandArgumentDefinition<String> SHOW_COLUMNS_ARG;
    public static final CommandArgumentDefinition<String> CHECK_NAME_ARG;

    public final void run(CommandResultsBuilder commandResultsBuilder) {
        if (this.isMavenIntegration(commandResultsBuilder)) {
            InMemoryChecksFileAccessor inMemoryChecksFileAccessor = new InMemoryChecksFileAccessor();
            Scope.child(Collections.singletonMap("fileAccessor", inMemoryChecksFileAccessor), () -> this.doRun(commandResultsBuilder));
            return;
        }
        this.doRun(commandResultsBuilder);
    }

    private void doRun(CommandResultsBuilder commandResultsBuilder) {
        String string = (String)commandResultsBuilder.getCommandScope().getConfiguredValue(CHECKS_SETTINGS_FILE_ARG).getValue();
        ChecksShowCommandStep.checkFileArgExistence(string, "checks settings");
        String string2 = System.lineSeparator() + "Generating report on current configuration of checks using settings in: " + (StringUtil.isEmpty((String)string) ? "liquibase.checks-settings.conf" : string) + System.lineSeparator();
        Scope.getCurrentScope().getUI().sendMessage(string2);
        if (ChecksShowCommandStep.writeTableToOutput(commandResultsBuilder, string, true)) {
            string = "INFO: Customize 'checks show' table with --show-cols flag. Learn more with 'liquibase checks show --help'" + System.lineSeparator();
            Scope.getCurrentScope().getUI().sendMessage(string);
        }
        commandResultsBuilder.addResult("statusCode", (Object)0);
    }

    public String[][] defineCommandNames() {
        return new String[][]{COMMAND_NAME};
    }

    @Override
    public void adjustCommandDefinition(CommandDefinition commandDefinition) {
        super.adjustCommandDefinition(commandDefinition);
        commandDefinition.setShortDescription("List available checks, their configuration options, and current settings");
        commandDefinition.setGroupShortDescription(new String[]{"checks"}, "Quality Checks commands");
    }

    @Override
    public boolean commandRequiresProLicense() {
        return false;
    }

    public static boolean writeTableToOutput(CommandResultsBuilder object, CheckSettingsConfig checkSettingsConfig, boolean bl2) {
        List<ChecksTableColumns> list = ChecksShowCommandStep.getRequiredColumns(object);
        List<AbstractLiquibaseRule> list2 = ChecksShowCommandStep.listAllRules();
        if (checkSettingsConfig != null) {
            CheckSettingsConfigHelper.sortRulesByPriority(list2, checkSettingsConfig);
        }
        String string = (String)object.getCommandScope().getConfiguredValue(CHECK_NAME_ARG).getValue();
        List<AbstractLiquibaseRule> list3 = list2;
        if (!string.equals("all") && bl2) {
            if (checkSettingsConfig != null) {
                List<AbstractConfigurableRule> list4 = ChecksShowCommandStep.filterRulesByShortName(checkSettingsConfig, string);
                checkSettingsConfig.setRules(list4);
            } else {
                list3 = ChecksShowCommandStep.filterRulesByShortName(list2, string);
            }
        }
        List<List<String>> list5 = ChecksShowCommandStep.createTableWithData(list3, checkSettingsConfig, list);
        boolean bl3 = false;
        if (!list5.isEmpty()) {
            object = ChecksShowCommandStep.createOutputWriter(object);
            TableOutput.formatOutput(list5, ChecksTableColumns.getColumnWidthsList(list), (boolean)true, (Writer)object);
            bl3 = true;
        }
        if (checkSettingsConfig != null) {
            checkSettingsConfig.outputWarningMessage();
        }
        return bl3;
    }

    public static boolean writeTableToOutput(CommandResultsBuilder commandResultsBuilder, String object, boolean bl2) {
        List<AbstractLiquibaseRule> list = ChecksShowCommandStep.listAllRules();
        String string = (String)commandResultsBuilder.getCommandScope().getConfiguredValue(CHECKS_AUTO_UPDATE_ARG).getValue();
        object = new CheckSettingsConfigHelper((String)object, string).read(list);
        return ChecksShowCommandStep.writeTableToOutput(commandResultsBuilder, (CheckSettingsConfig)object, bl2);
    }

    private static List<AbstractLiquibaseRule> filterRulesByShortName(List<AbstractLiquibaseRule> list, String object) {
        if (StringUtil.isEmpty((String)object)) {
            return list;
        }
        object = StringUtil.splitAndTrim((String)object, (String)",");
        ArrayList<AbstractLiquibaseRule> arrayList = new ArrayList<AbstractLiquibaseRule>(object.size());
        ArrayList<String> arrayList2 = new ArrayList<String>();
        Iterator iterator = object.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            Optional<AbstractLiquibaseRule> optional = list.stream().filter(arg_0 -> ChecksShowCommandStep.lambda$filterRulesByShortName$4((List)object, arg_0)).findFirst();
            if (!optional.isPresent()) {
                arrayList2.add(string);
                continue;
            }
            arrayList.add(optional.get());
        }
        if (!arrayList2.isEmpty()) {
            throw new CommandExecutionException("One or more specified checks not found: '" + StringUtil.join(arrayList2, (String)"', '") + "'. Please check your arguments and try again.");
        }
        return arrayList;
    }

    private static List<AbstractConfigurableRule> filterRulesByShortName(CheckSettingsConfig checkSettingsConfig, String string) {
        return ChecksRunCommandStep.determineRulesToRun(checkSettingsConfig, string);
    }

    private static List<List<String>> createTableWithData(List<AbstractLiquibaseRule> list, CheckSettingsConfig object, List<ChecksTableColumns> list2) {
        list2 = ChecksTableColumns.getColumnNamesList(list2);
        ArrayList<List<String>> arrayList = new ArrayList<List<String>>();
        if (object != null) {
            arrayList.add(list2);
            for (AbstractConfigurableRule abstractConfigurableRule : ((CheckSettingsConfig)((Object)object)).getRules()) {
                Optional<AbstractLiquibaseRule> optional = ChecksShowCommandStep.findParentRule(list, abstractConfigurableRule);
                if (optional.isPresent()) {
                    optional = optional.get();
                    String string = "<None>";
                    String string2 = ((AbstractLiquibaseRule)((Object)optional)).getShortName();
                    if (abstractConfigurableRule.isConfigurable()) {
                        string = ((DynamicRule)abstractConfigurableRule).prettyPrintParameters();
                        string2 = ((DynamicRule)abstractConfigurableRule).getShortName();
                    }
                    Map<String, String> map = ChecksShowCommandStep.prepareAllRulePropertiesMap(((AbstractLiquibaseRule)((Object)optional)).getId().toString(), ((AbstractLiquibaseRule)((Object)optional)).getName(), string2, ChecksShowCommandStep.scopesToString(optional.getScope()), StringUtil.join(((AbstractLiquibaseRule)((Object)optional)).getSupportedChangesetFormats(), (String)", "), Boolean.toString(abstractConfigurableRule.isEnabled()), Integer.toString(abstractConfigurableRule.getSeverity().getExitValue()), String.valueOf(((AbstractLiquibaseRule)((Object)optional)).getPriority()), string, ((AbstractLiquibaseRule)((Object)optional)).getDescription());
                    arrayList.add(ChecksShowCommandStep.getRulePropertiesForRequiredColumns(list2, map));
                    continue;
                }
                Scope.getCurrentScope().getLog(ChecksShowCommandStep.class).fine("Customized rule with ID " + abstractConfigurableRule.getId() + " does not match any rules loaded in the system, and will not be shown.");
            }
        }
        return arrayList;
    }

    private static List<ChecksTableColumns> getRequiredColumns(CommandResultsBuilder object) {
        object = (String)object.getCommandScope().getConfiguredValue(SHOW_COLUMNS_ARG).getValue();
        return Arrays.stream(ChecksTableColumns.values()).filter(arg_0 -> ChecksShowCommandStep.lambda$getRequiredColumns$5((String)object, arg_0)).collect(Collectors.toList());
    }

    private static Optional<AbstractLiquibaseRule> findParentRule(List<AbstractLiquibaseRule> list, AbstractConfigurableRule object) {
        object = ((AbstractConfigurableRule)object).isConfigurable() ? (((DynamicRule)(object = (DynamicRule)object)).isCopy() ? ((DynamicRule)object).getParentRuleId() : ((AbstractConfigurableRule)object).getId()) : ((AbstractConfigurableRule)object).getId();
        return list.stream().filter(arg_0 -> ChecksShowCommandStep.lambda$findParentRule$6((UUID)object, arg_0)).findFirst();
    }

    private static Map<String, String> prepareAllRulePropertiesMap(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, String string10) {
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        linkedHashMap.put(ChecksTableColumns.ID.getName(), string);
        linkedHashMap.put(ChecksTableColumns.CHECKNAME.getName(), string2);
        linkedHashMap.put(ChecksTableColumns.SHORTNAME.getName(), string3);
        linkedHashMap.put(ChecksTableColumns.SCOPE.getName(), string4);
        linkedHashMap.put(ChecksTableColumns.CHANGESET_TYPE.getName(), string5);
        linkedHashMap.put(ChecksTableColumns.ENABLED.getName(), string6);
        linkedHashMap.put(ChecksTableColumns.SEVERITY.getName(), string7);
        linkedHashMap.put(ChecksTableColumns.PRIORITY.getName(), string8);
        linkedHashMap.put(ChecksTableColumns.CUSTOMIZATION.getName(), string9);
        linkedHashMap.put(ChecksTableColumns.DESCRIPTION.getName(), string10);
        return linkedHashMap;
    }

    private static String toArgumentCase(String string) {
        return StringUtil.toLowerWithoutWhitespaces((String)string);
    }

    private static List<String> getRulePropertiesForRequiredColumns(List<String> list, Map<String, String> map) {
        return list.stream().map(map::get).collect(Collectors.toList());
    }

    private static String scopesToString(List<ScopeEnum> list) {
        return StringUtil.join((Collection)list.stream().map(scopeEnum -> scopeEnum.toString().toLowerCase()).sorted().collect(Collectors.toList()), (String)", ");
    }

    private static Writer createOutputWriter(CommandResultsBuilder object) {
        String string = (String)GlobalConfiguration.OUTPUT_FILE_ENCODING.getCurrentValue();
        object = object.getOutputStream();
        return new OutputStreamWriter((OutputStream)object, string);
    }

    private static /* synthetic */ boolean lambda$findParentRule$6(UUID uUID, AbstractLiquibaseRule abstractLiquibaseRule) {
        return abstractLiquibaseRule.getId().equals(uUID);
    }

    private static /* synthetic */ boolean lambda$getRequiredColumns$5(String string, ChecksTableColumns checksTableColumns) {
        return string.contains(checksTableColumns.getNameArgumentCase());
    }

    private static /* synthetic */ boolean lambda$filterRulesByShortName$4(List list, AbstractLiquibaseRule abstractLiquibaseRule) {
        return list.contains(ChecksShowCommandStep.toArgumentCase(abstractLiquibaseRule.getShortName()));
    }

    static {
        CommandBuilder commandBuilder = new CommandBuilder((String[][])new String[][]{COMMAND_NAME});
        CHECKS_SETTINGS_FILE_ARG = commandBuilder.argument("checksSettingsFile", String.class).description("Relative or fully qualified path to a configuration file for checks execution").build();
        CHECKS_AUTO_UPDATE_ARG = commandBuilder.argument("autoUpdate", String.class).description("Allows automatic backup and updating of liquibase.checks.conf file when new quality checks are available. Options: [on|off]").setValueHandler(object -> {
            if (object == null) {
                return null;
            }
            if (((String)(object = (String)object)).equalsIgnoreCase("on") || ((String)object).equalsIgnoreCase("off")) {
                return object;
            }
            object = "\nWARNING:  The autoUpdate value '" + (String)object + "' is not valid.  Valid values include: 'on' or 'off'";
            throw new IllegalArgumentException((String)object);
        }).build();
        CHECKS_INTEGRATION_ARG = commandBuilder.argument("checksIntegration", String.class).hidden().defaultValue((Object)"cli").description("Name of the integration that is executing checks show").build();
        SHOW_COLUMNS_ARG = commandBuilder.argument("showCols", String.class).defaultValue((Object)ChecksTableColumns.DEFAULT_COLUMNS_ARG).setValueHandler(object -> {
            if (object == null) {
                return null;
            }
            if (((String)(object = ((String)object).toLowerCase())).equals("all")) {
                return ChecksTableColumns.EVERY_COLUMN_ARG;
            }
            HashSet<String> hashSet = new HashSet<String>(Arrays.asList(((String)object).split(",")));
            if (!Arrays.stream(ChecksTableColumns.values()).map(ChecksTableColumns::getNameArgumentCase).collect(Collectors.toSet()).containsAll(hashSet)) {
                object = "WARNING:  The showCols arguments '" + (String)object + "' are not valid." + System.lineSeparator() + "Valid value is a comma separated list of column names: " + ChecksTableColumns.EVERY_COLUMN_ARG + ".";
                throw new IllegalArgumentException((String)object);
            }
            return object;
        }).description(String.format("Only show the listed columns. Column options: %s. Use commas to separate column names. Use 'all' to select all the columns.", ChecksTableColumns.EVERY_COLUMN_ARG)).build();
        CHECK_NAME_ARG = commandBuilder.argument("checkName", String.class).defaultValue((Object)"all").setValueHandler(object -> {
            if (object == null) {
                return null;
            }
            return ((String)object).toLowerCase();
        }).description("Only show the listed rules. Use rule shortnames separated with commas to list all required rules. Use 'all', to select all the rules (used by default, if the parameter isn't set).").build();
    }
}

