/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.command.init;

import com.datical.liquibase.ext.checks.config.ChecksFileAccessor;
import com.datical.liquibase.ext.checks.config.DynamicRuleParameterEnum;
import com.datical.liquibase.ext.command.init.InitHubCommandStep$CustomResourceAccessor;
import com.datical.liquibase.ext.command.init.InitProjectCommandStep;
import com.datical.liquibase.ext.init.InitProjectUtil;
import java.io.File;
import java.io.Serializable;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.regex.Pattern;
import liquibase.Scope;
import liquibase.command.AbstractCommandStep;
import liquibase.command.CommandArgumentDefinition;
import liquibase.command.CommandBuilder;
import liquibase.command.CommandDefinition;
import liquibase.command.CommandResults;
import liquibase.command.CommandResultsBuilder;
import liquibase.command.CommandScope;
import liquibase.command.CommonArgumentNames;
import liquibase.command.core.RegisterChangelogCommandStep;
import liquibase.configuration.ConfigurationValueObfuscator;
import liquibase.configuration.ConfiguredValue;
import liquibase.configuration.core.DefaultsFileValueProvider;
import liquibase.exception.ChangeLogAlreadyRegisteredException;
import liquibase.exception.CommandExecutionException;
import liquibase.hub.HubConfiguration;
import liquibase.hub.HubService;
import liquibase.hub.HubServiceFactory;
import liquibase.hub.LiquibaseHubException;
import liquibase.hub.model.CoreInitOnboardingResponse;
import liquibase.hub.model.Operation;
import liquibase.hub.model.OperationEvent;
import liquibase.integration.commandline.LiquibaseCommandLineConfiguration;
import liquibase.resource.CompositeResourceAccessor;
import liquibase.resource.PathHandlerFactory;
import liquibase.resource.Resource;
import liquibase.resource.ResourceAccessor;
import liquibase.util.FileUtil;
import liquibase.util.StringUtil;
import org.yaml.snakeyaml.Yaml;

public class InitHubCommandStep
extends AbstractCommandStep {
    public static final String[] COMMAND_NAME = new String[]{"init", "hub"};
    public static final CommandArgumentDefinition<String> INIT_HUB_PROJECT_DIR_ARG;
    public static final CommandArgumentDefinition<String> INIT_HUB_TOKEN_ARG;
    public static final CommandArgumentDefinition<String> INIT_HUB_CHANGELOG_FILE_ARG;
    public static final CommandArgumentDefinition<String> INIT_HUB_URL_ARG;
    public static final CommandArgumentDefinition<String> INIT_HUB_USERNAME_ARG;
    public static final CommandArgumentDefinition<String> INIT_HUB_PASSWORD_ARG;
    private final Yaml yaml = new Yaml();

    public String[][] defineCommandNames() {
        return new String[][]{COMMAND_NAME};
    }

    public void run(CommandResultsBuilder commandResultsBuilder) {
        CommandScope commandScope = commandResultsBuilder.getCommandScope();
        String string = ((String)commandScope.getConfiguredValue(INIT_HUB_TOKEN_ARG).getValue()).trim().toUpperCase();
        if (string.length() != 7) {
            throw new CommandExecutionException("The token must be 7 characters in length.");
        }
        if (!Pattern.compile("[A-Z0-9]*").matcher(string).matches()) {
            throw new CommandExecutionException("The token must be alphanumeric.");
        }
        HubServiceFactory hubServiceFactory = (HubServiceFactory)Scope.getCurrentScope().getSingleton(HubServiceFactory.class);
        if ((HubConfiguration.HubMode)HubConfiguration.LIQUIBASE_HUB_MODE.getCurrentValue() == HubConfiguration.HubMode.OFF || !hubServiceFactory.isOnline()) {
            throw new LiquibaseHubException("The command 'init hub' requires liquibase.hub.mode to be 'all' or 'meta', but it is currently set to 'off'. Please update this property in the defaults file, Environment variable or other method. Learn more at https://docs.liquibase.com");
        }
        hubServiceFactory = ((HubServiceFactory)Scope.getCurrentScope().getSingleton(HubServiceFactory.class)).getService();
        string = hubServiceFactory.validateOnboardingToken(string);
        Map<String, String> map = Collections.singletonMap(HubConfiguration.LIQUIBASE_HUB_API_KEY.getKey(), string.getApiKey().getKey());
        Scope.child(map, () -> this.lambda$run$1((CoreInitOnboardingResponse)string, (HubService)hubServiceFactory, commandScope, map, commandResultsBuilder));
        commandResultsBuilder.addResult("statusCode", (Object)0);
    }

    private void sendOperationEvent(HubService hubService, String string, Operation operation, UUID uUID) {
        this.sendOperationEvent(hubService, string, operation, uUID, "PASS");
    }

    private void sendOperationEvent(HubService hubService, String string, Operation operation, UUID uUID, String string2) {
        OperationEvent operationEvent = new OperationEvent();
        operationEvent.setEventType(string);
        operationEvent.setStartDate(new Date());
        operationEvent.setEndDate(new Date());
        OperationEvent.OperationEventStatus operationEventStatus = new OperationEvent.OperationEventStatus();
        operationEventStatus.setOperationEventStatusType(string2);
        operationEventStatus.setStatusMessage("Hub Connection Established");
        operationEvent.setOperationEventStatus(operationEventStatus);
        hubService.sendOperationEvent(operation, operationEvent, uUID);
        Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass()).fine(string + " operation event successfully sent to hub");
    }

    public void adjustCommandDefinition(CommandDefinition commandDefinition) {
        super.adjustCommandDefinition(commandDefinition);
        commandDefinition.setShortDescription("Command used to complete Hub and Liquibase setup. Requires a \"token\" available from hub.liquibase.com with a valid user account. Updates the specified liquibase.properties with a valid Hub API Key, and registers the specified changelog file wih Hub, enabling secure monitoring and sharing of local Liquibase activity within an organization.");
        commandDefinition.setGroupShortDescription(new String[]{"init"}, "Init commands");
    }

    private static void updateDefaultsFile(File file, String string, boolean bl2, String string2) {
        String string3;
        String string4 = FileUtil.getContents((File)file);
        String string5 = string3 = StringUtil.isEmpty((String)string2) ? string4 : string2;
        if (string4 == null) {
            throw new CommandExecutionException("Cannot load contents of defaults file.");
        }
        if (StringUtil.isNotEmpty((String)string2) || bl2) {
            File file2 = InitProjectUtil.calcBackupFile(file);
            string2 = ((PathHandlerFactory)Scope.getCurrentScope().getSingleton(PathHandlerFactory.class)).getResource(file2.getAbsolutePath());
            file2 = ((PathHandlerFactory)Scope.getCurrentScope().getSingleton(PathHandlerFactory.class)).getResource(file2.getAbsolutePath());
            ChecksFileAccessor.makeBackup((Resource)string2, (Resource)file2, string4, null, false);
            InitProjectUtil.outputBackedUpDefaultsFileMessage(file.getAbsolutePath());
        }
        FileUtil.write((String)InitProjectUtil.replaceProperty("liquibase.hub.apiKey", string, string3, false, false, true, false, false), (File)file, (boolean)false);
    }

    private /* synthetic */ void lambda$run$1(CoreInitOnboardingResponse object, HubService hubService, CommandScope commandScope, Map serializable, CommandResultsBuilder commandResultsBuilder) {
        UUID uUID = object.getOrganization().getId();
        Operation operation = hubService.createOperationInOrganization("INIT", "init-hub", uUID);
        Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass()).fine("init operation successfully sent to hub");
        Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass()).fine(this.yaml.dump((Object)operation));
        Scope.getCurrentScope().getUI().sendMessage("Hub connection established.");
        this.sendOperationEvent(hubService, "START", operation, uUID);
        ConfiguredValue configuredValue = commandScope.getConfiguredValue(INIT_HUB_PROJECT_DIR_ARG);
        String string = (String)configuredValue.getValue();
        Serializable serializable2 = new File(string);
        ConfiguredValue configuredValue2 = LiquibaseCommandLineConfiguration.DEFAULTS_FILE.getCurrentConfiguredValue();
        Object object2 = (String)configuredValue2.getValue();
        object2 = new File((File)serializable2, (String)object2);
        Object object3 = InitProjectUtil.findChangeLogsInProjectDir(serializable2);
        CommandResults commandResults = null;
        boolean bl2 = ((File)object2).exists();
        if (!bl2 || ((File[])object3).length == 0) {
            CommandScope commandScope2 = new CommandScope(new String[]{InitProjectCommandStep.COMMAND_NAME[0], InitProjectCommandStep.COMMAND_NAME[1]});
            commandScope2.addArgumentValue(InitProjectCommandStep.INIT_PROJECT_DIR_ARG, (Object)serializable2.getAbsolutePath());
            serializable2 = new HashMap<String, Boolean>((Map<String, Boolean>)((Object)serializable));
            serializable2.put("shouldBackupDefaultsFile", Boolean.FALSE);
            commandResults = (CommandResults)Scope.child((Map)((Object)serializable2), () -> ((CommandScope)commandScope2).execute());
            if (commandResults.getResult(InitProjectCommandStep.INIT_DEFAULTS_FILE_ARG.getName()) != null) {
                object2 = (File)commandResults.getResult(InitProjectCommandStep.INIT_DEFAULTS_FILE_ARG.getName());
            }
        }
        boolean bl3 = true;
        if (!((File)object2).exists()) {
            Scope.getCurrentScope().getUI().sendMessage("Cannot add Hub API Key to defaults file, because no defaults file can be found.");
            this.sendOperationEvent(hubService, "ENVIRONMENT_SETUP", operation, uUID, "FAIL");
            bl3 = false;
        } else {
            serializable2 = commandResults == null ? null : (String)commandResults.getResult("modifiedDefaultsFileContents");
            InitHubCommandStep.updateDefaultsFile((File)object2, object.getApiKey().getKey(), bl2, (String)((Object)serializable2));
            this.sendOperationEvent(hubService, "ENVIRONMENT_SETUP", operation, uUID);
        }
        serializable2 = new RegisterChangelogCommandStep();
        object = null;
        if (commandResults != null && commandResults.getResult(InitProjectCommandStep.INIT_CHANGELOG_FILE_ARG.getName()) != null) {
            object = (String)commandResults.getResult(InitProjectCommandStep.INIT_CHANGELOG_FILE_ARG.getName());
        } else {
            object2 = commandScope.getConfiguredValue(INIT_HUB_CHANGELOG_FILE_ARG);
            if (object2.getProvidedValue().getProvider() instanceof DefaultsFileValueProvider) {
                object = (String)object2.getValue();
            } else if (object3 != null && ((File[])object3).length > 0) {
                object = object3[0].getPath();
            }
        }
        boolean bl4 = true;
        if (object == null) {
            Scope.getCurrentScope().getUI().sendMessage("Changelog file does not exist, and thus cannot be registered with Hub.");
            this.sendOperationEvent(hubService, "REGISTER_CHANGELOG", operation, uUID, "FAIL");
            bl4 = false;
        } else {
            serializable = new HashMap<String, ResourceAccessor>((Map<String, ResourceAccessor>)((Object)serializable));
            object = InitProjectUtil.removeDotsFromPath((String)object);
            object3 = new InitHubCommandStep$CustomResourceAccessor((String)object);
            ResourceAccessor resourceAccessor = Scope.getCurrentScope().getResourceAccessor();
            resourceAccessor = new CompositeResourceAccessor(new ResourceAccessor[]{resourceAccessor});
            resourceAccessor.addResourceAccessor((ResourceAccessor)object3);
            serializable.put(Scope.Attr.resourceAccessor.toString(), resourceAccessor);
            try {
                Scope.child(serializable, () -> InitHubCommandStep.lambda$null$0((RegisterChangelogCommandStep)serializable2, (String)object, commandResultsBuilder));
                ((CompositeResourceAccessor)resourceAccessor).removeResourceAccessor((ResourceAccessor)object3);
                this.sendOperationEvent(hubService, "REGISTER_CHANGELOG", operation, uUID);
            }
            catch (CommandExecutionException commandExecutionException) {
                object = commandExecutionException;
                serializable = commandExecutionException.getCause();
                this.sendOperationEvent(hubService, "REGISTER_CHANGELOG", operation, uUID, "FAIL");
                bl4 = false;
                if (!(serializable instanceof ChangeLogAlreadyRegisteredException) || ((ChangeLogAlreadyRegisteredException)serializable).getHubChangeLog() == null) {
                    throw object;
                }
                Scope.getCurrentScope().getUI().sendMessage(object.getMessage());
                Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass()).info(object.getMessage());
            }
        }
        this.sendOperationEvent(hubService, "COMPLETE", operation, uUID);
        boolean bl5 = InitProjectUtil.wasH2Used((ConfiguredValue<String>)commandScope.getConfiguredValue(INIT_HUB_URL_ARG), (ConfiguredValue<String>)commandScope.getConfiguredValue(INIT_HUB_USERNAME_ARG), (ConfiguredValue<String>)commandScope.getConfiguredValue(INIT_HUB_PASSWORD_ARG));
        if ((bl3 || bl4) && (bl5 || commandResults != null && commandResults.getResult("usedH2") != null)) {
            InitProjectCommandStep.outputEndInstructions(configuredValue.wasDefaultValueUsed(), (ConfiguredValue<String>)configuredValue2, string, bl5 || (Boolean)commandResults.getResult("usedH2") != false);
        }
    }

    private static /* synthetic */ void lambda$null$0(RegisterChangelogCommandStep registerChangelogCommandStep, String string, CommandResultsBuilder commandResultsBuilder) {
        registerChangelogCommandStep.doRegisterChangelog(string, null, null, commandResultsBuilder, true);
    }

    static {
        CommandBuilder commandBuilder = new CommandBuilder((String[][])new String[][]{COMMAND_NAME});
        INIT_HUB_PROJECT_DIR_ARG = commandBuilder.argument("projectDir", String.class).description("An optional parameter used to specify the directory containing files (existing or to be auto-created) to be used with Liquibase").defaultValue((Object)"./").build();
        INIT_HUB_TOKEN_ARG = commandBuilder.argument("token", String.class).description("A required one-time-use code to connect your local Liquibase usage to your existing Liquibase Hub user account. Token is available to registered Hub users at https://hub.liquibase.com.").required().build();
        INIT_HUB_CHANGELOG_FILE_ARG = commandBuilder.argument(CommonArgumentNames.CHANGELOG_FILE, String.class).description("Relative or fully qualified path to the changelog file").defaultValue((Object)((String)DynamicRuleParameterEnum.SAMPLE_CHANGELOG_NAME.defaultValue)).hidden().build();
        INIT_HUB_URL_ARG = commandBuilder.argument(CommonArgumentNames.URL, String.class).description("The JDBC database connection URL").defaultValue((Object)((String)DynamicRuleParameterEnum.JDBC_URL.defaultValue)).hidden().build();
        INIT_HUB_USERNAME_ARG = commandBuilder.argument(CommonArgumentNames.USERNAME, String.class).description("Username to use to connect to the database").defaultValue((Object)((String)DynamicRuleParameterEnum.USERNAME.defaultValue)).hidden().build();
        INIT_HUB_PASSWORD_ARG = commandBuilder.argument(CommonArgumentNames.PASSWORD, String.class).description("Password to use to connect to the database").defaultValue((Object)((String)DynamicRuleParameterEnum.PASSWORD.defaultValue)).setValueObfuscator(ConfigurationValueObfuscator.STANDARD).hidden().build();
    }
}

