/*
 * Decompiled with CFR 0.152.
 */
package liquibase.repackaged.net.sf.jsqlparser.statement.update;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import liquibase.repackaged.net.sf.jsqlparser.Model;
import liquibase.repackaged.net.sf.jsqlparser.expression.Expression;
import liquibase.repackaged.net.sf.jsqlparser.expression.OracleHint;
import liquibase.repackaged.net.sf.jsqlparser.schema.Column;
import liquibase.repackaged.net.sf.jsqlparser.schema.Table;
import liquibase.repackaged.net.sf.jsqlparser.statement.OutputClause;
import liquibase.repackaged.net.sf.jsqlparser.statement.Statement;
import liquibase.repackaged.net.sf.jsqlparser.statement.StatementVisitor;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.FromItem;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.Join;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.Limit;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.OrderByElement;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.PlainSelect;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.Select;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.SelectItem;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.SubSelect;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.WithItem;
import liquibase.repackaged.net.sf.jsqlparser.statement.update.UpdateModifierPriority;
import liquibase.repackaged.net.sf.jsqlparser.statement.update.UpdateSet;

public class Update
implements Statement {
    private List<WithItem> withItemsList;
    private Table table;
    private Expression where;
    private final ArrayList<UpdateSet> updateSets = new ArrayList();
    private FromItem fromItem;
    private List<Join> joins;
    private List<Join> startJoins;
    private OracleHint oracleHint = null;
    private List<OrderByElement> orderByElements;
    private Limit limit;
    private List<SelectItem> returningExpressionList = null;
    private UpdateModifierPriority modifierPriority;
    private boolean modifierIgnore;
    private OutputClause outputClause;

    public OutputClause getOutputClause() {
        return this.outputClause;
    }

    public void setOutputClause(OutputClause outputClause) {
        this.outputClause = outputClause;
    }

    public ArrayList<UpdateSet> getUpdateSets() {
        return this.updateSets;
    }

    @Override
    public void accept(StatementVisitor statementVisitor) {
        statementVisitor.visit(this);
    }

    public List<WithItem> getWithItemsList() {
        return this.withItemsList;
    }

    public void setWithItemsList(List<WithItem> list) {
        this.withItemsList = list;
    }

    public Update withWithItemsList(List<WithItem> list) {
        this.setWithItemsList(list);
        return this;
    }

    public Update addWithItemsList(WithItem ... withItemArray) {
        List list = Optional.ofNullable(this.getWithItemsList()).orElseGet(ArrayList::new);
        Collections.addAll(list, withItemArray);
        return this.withWithItemsList(list);
    }

    public Update addWithItemsList(Collection<? extends WithItem> collection) {
        List list = Optional.ofNullable(this.getWithItemsList()).orElseGet(ArrayList::new);
        list.addAll(collection);
        return this.withWithItemsList(list);
    }

    public Table getTable() {
        return this.table;
    }

    public Expression getWhere() {
        return this.where;
    }

    public void setTable(Table table) {
        this.table = table;
    }

    public void setWhere(Expression expression) {
        this.where = expression;
    }

    public OracleHint getOracleHint() {
        return this.oracleHint;
    }

    public void setOracleHint(OracleHint oracleHint) {
        this.oracleHint = oracleHint;
    }

    public void addUpdateSet(Column column, Expression expression) {
        this.updateSets.add(new UpdateSet(column, expression));
    }

    public void addUpdateSet(UpdateSet updateSet) {
        this.updateSets.add(updateSet);
    }

    @Deprecated
    public List<Column> getColumns() {
        return this.updateSets.get((int)0).columns;
    }

    @Deprecated
    public List<Expression> getExpressions() {
        return this.updateSets.get((int)0).expressions;
    }

    @Deprecated
    public void setColumns(List<Column> list) {
        if (this.updateSets.isEmpty()) {
            this.updateSets.add(new UpdateSet());
        }
        this.updateSets.get((int)0).columns.clear();
        this.updateSets.get((int)0).columns.addAll(list);
    }

    @Deprecated
    public void setExpressions(List<Expression> list) {
        this.updateSets.get((int)0).expressions.clear();
        this.updateSets.get((int)0).expressions.addAll(list);
    }

    public FromItem getFromItem() {
        return this.fromItem;
    }

    public void setFromItem(FromItem fromItem) {
        this.fromItem = fromItem;
    }

    public List<Join> getJoins() {
        return this.joins;
    }

    public void setJoins(List<Join> list) {
        this.joins = list;
    }

    public List<Join> getStartJoins() {
        return this.startJoins;
    }

    public void setStartJoins(List<Join> list) {
        this.startJoins = list;
    }

    @Deprecated
    public Select getSelect() {
        Model model = null;
        if (this.updateSets.get((int)0).expressions.get(0) instanceof SubSelect) {
            model = (SubSelect)this.updateSets.get((int)0).expressions.get(0);
            model = new Select().withWithItemsList(model.getWithItemsList()).withSelectBody(model.getSelectBody());
        }
        return model;
    }

    @Deprecated
    public void setSelect(Select select) {
        if (select != null) {
            SubSelect subSelect = new SubSelect().withSelectBody(select.getSelectBody());
            if (select.getWithItemsList() != null && select.getWithItemsList().size() > 0) {
                subSelect.setWithItemsList(select.getWithItemsList());
            }
            if (this.updateSets.get((int)0).expressions.isEmpty()) {
                this.updateSets.get((int)0).expressions.add(subSelect);
                return;
            }
            this.updateSets.get((int)0).expressions.set(0, subSelect);
        }
    }

    @Deprecated
    public boolean isUseColumnsBrackets() {
        return this.updateSets.get((int)0).usingBracketsForColumns;
    }

    @Deprecated
    public void setUseColumnsBrackets(boolean bl2) {
        this.updateSets.get((int)0).usingBracketsForColumns = bl2;
    }

    @Deprecated
    public boolean isUseSelect() {
        return this.updateSets.get((int)0).expressions.get(0) instanceof SubSelect;
    }

    @Deprecated
    public void setUseSelect(boolean bl2) {
    }

    public void setOrderByElements(List<OrderByElement> list) {
        this.orderByElements = list;
    }

    public void setLimit(Limit limit) {
        this.limit = limit;
    }

    public List<OrderByElement> getOrderByElements() {
        return this.orderByElements;
    }

    public Limit getLimit() {
        return this.limit;
    }

    public List<SelectItem> getReturningExpressionList() {
        return this.returningExpressionList;
    }

    public void setReturningExpressionList(List<SelectItem> list) {
        this.returningExpressionList = list;
    }

    public UpdateModifierPriority getModifierPriority() {
        return this.modifierPriority;
    }

    public void setModifierPriority(UpdateModifierPriority updateModifierPriority) {
        this.modifierPriority = updateModifierPriority;
    }

    public boolean isModifierIgnore() {
        return this.modifierIgnore;
    }

    public void setModifierIgnore(boolean bl2) {
        this.modifierIgnore = bl2;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.withItemsList != null && !this.withItemsList.isEmpty()) {
            stringBuilder.append("WITH ");
            Iterator<Object> iterator = this.withItemsList.iterator();
            while (iterator.hasNext()) {
                WithItem object = iterator.next();
                stringBuilder.append(object);
                if (iterator.hasNext()) {
                    stringBuilder.append(",");
                }
                stringBuilder.append(" ");
            }
        }
        stringBuilder.append("UPDATE ");
        if (this.modifierPriority != null) {
            stringBuilder.append(this.modifierPriority.name()).append(" ");
        }
        if (this.modifierIgnore) {
            stringBuilder.append("IGNORE ");
        }
        stringBuilder.append(this.table);
        if (this.startJoins != null) {
            for (Join join : this.startJoins) {
                if (join.isSimple()) {
                    stringBuilder.append(", ").append(join);
                    continue;
                }
                stringBuilder.append(" ").append(join);
            }
        }
        UpdateSet.appendUpdateSetsTo(stringBuilder, this.updateSets);
        if (this.outputClause != null) {
            this.outputClause.appendTo(stringBuilder);
        }
        if (this.fromItem != null) {
            stringBuilder.append(" FROM ").append(this.fromItem);
            if (this.joins != null) {
                for (Join join : this.joins) {
                    if (join.isSimple()) {
                        stringBuilder.append(", ").append(join);
                        continue;
                    }
                    stringBuilder.append(" ").append(join);
                }
            }
        }
        if (this.where != null) {
            stringBuilder.append(" WHERE ");
            stringBuilder.append(this.where);
        }
        if (this.orderByElements != null) {
            stringBuilder.append(PlainSelect.orderByToString(this.orderByElements));
        }
        if (this.limit != null) {
            stringBuilder.append(this.limit);
        }
        if (this.getReturningExpressionList() != null) {
            stringBuilder.append(" RETURNING ").append(PlainSelect.getStringList(this.getReturningExpressionList(), true, false));
        }
        return stringBuilder.toString();
    }

    public Update withTable(Table table) {
        this.setTable(table);
        return this;
    }

    public Update withFromItem(FromItem fromItem) {
        this.setFromItem(fromItem);
        return this;
    }

    public Update withJoins(List<Join> list) {
        this.setJoins(list);
        return this;
    }

    public Update withStartJoins(List<Join> list) {
        this.setStartJoins(list);
        return this;
    }

    public Update withSelect(Select select) {
        this.setSelect(select);
        return this;
    }

    public Update withUseColumnsBrackets(boolean bl2) {
        this.setUseColumnsBrackets(bl2);
        return this;
    }

    public Update withUseSelect(boolean bl2) {
        this.setUseSelect(bl2);
        return this;
    }

    public Update withOrderByElements(List<OrderByElement> list) {
        this.setOrderByElements(list);
        return this;
    }

    public Update withLimit(Limit limit) {
        this.setLimit(limit);
        return this;
    }

    public Update withReturningExpressionList(List<SelectItem> list) {
        this.setReturningExpressionList(list);
        return this;
    }

    public Update withWhere(Expression expression) {
        this.setWhere(expression);
        return this;
    }

    public Update withColumns(List<Column> list) {
        this.setColumns(list);
        return this;
    }

    public Update withExpressions(List<Expression> list) {
        this.setExpressions(list);
        return this;
    }

    public Update withModifierPriority(UpdateModifierPriority updateModifierPriority) {
        this.setModifierPriority(updateModifierPriority);
        return this;
    }

    public Update withModifierIgnore(boolean bl2) {
        this.setModifierIgnore(bl2);
        return this;
    }

    public Update addColumns(Column ... columnArray) {
        ArrayList<Column> arrayList = new ArrayList<Column>(Optional.ofNullable(this.getColumns()).orElseGet(ArrayList::new));
        Collections.addAll(arrayList, columnArray);
        return this.withColumns(arrayList);
    }

    public Update addColumns(Collection<? extends Column> collection) {
        ArrayList<Column> arrayList = new ArrayList<Column>(Optional.ofNullable(this.getColumns()).orElseGet(ArrayList::new));
        arrayList.addAll(collection);
        return this.withColumns(arrayList);
    }

    public Update addExpressions(Expression ... expressionArray) {
        ArrayList<Expression> arrayList = new ArrayList<Expression>(Optional.ofNullable(this.getExpressions()).orElseGet(ArrayList::new));
        Collections.addAll(arrayList, expressionArray);
        return this.withExpressions(arrayList);
    }

    public Update addExpressions(Collection<? extends Expression> collection) {
        ArrayList<Expression> arrayList = new ArrayList<Expression>(Optional.ofNullable(this.getExpressions()).orElseGet(ArrayList::new));
        arrayList.addAll(collection);
        return this.withExpressions(arrayList);
    }

    public Update addJoins(Join ... joinArray) {
        List list = Optional.ofNullable(this.getJoins()).orElseGet(ArrayList::new);
        Collections.addAll(list, joinArray);
        return this.withJoins(list);
    }

    public Update addJoins(Collection<? extends Join> collection) {
        List list = Optional.ofNullable(this.getJoins()).orElseGet(ArrayList::new);
        list.addAll(collection);
        return this.withJoins(list);
    }

    public Update addStartJoins(Join ... joinArray) {
        List list = Optional.ofNullable(this.getStartJoins()).orElseGet(ArrayList::new);
        Collections.addAll(list, joinArray);
        return this.withStartJoins(list);
    }

    public Update addStartJoins(Collection<? extends Join> collection) {
        List list = Optional.ofNullable(this.getStartJoins()).orElseGet(ArrayList::new);
        list.addAll(collection);
        return this.withStartJoins(list);
    }

    public Update addOrderByElements(OrderByElement ... orderByElementArray) {
        List list = Optional.ofNullable(this.getOrderByElements()).orElseGet(ArrayList::new);
        Collections.addAll(list, orderByElementArray);
        return this.withOrderByElements(list);
    }

    public Update addOrderByElements(Collection<? extends OrderByElement> collection) {
        List list = Optional.ofNullable(this.getOrderByElements()).orElseGet(ArrayList::new);
        list.addAll(collection);
        return this.withOrderByElements(list);
    }

    public Update addReturningExpressionList(SelectItem ... selectItemArray) {
        List list = Optional.ofNullable(this.getReturningExpressionList()).orElseGet(ArrayList::new);
        Collections.addAll(list, selectItemArray);
        return this.withReturningExpressionList(list);
    }

    public Update addReturningExpressionList(Collection<? extends SelectItem> collection) {
        List list = Optional.ofNullable(this.getReturningExpressionList()).orElseGet(ArrayList::new);
        list.addAll(collection);
        return this.withReturningExpressionList(list);
    }

    public <E extends Expression> E getWhere(Class<E> clazz) {
        return (E)((Expression)clazz.cast(this.getWhere()));
    }

    public <E extends FromItem> E getFromItem(Class<E> clazz) {
        return (E)((FromItem)clazz.cast(this.getFromItem()));
    }
}

