/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.storedlogic.function;

import com.datical.liquibase.ext.storedlogic.AbstractUnexpectedStoredLogicChangeGenerator;
import com.datical.liquibase.ext.storedlogic.function.Function;
import com.datical.liquibase.ext.storedlogic.function.change.DropFunctionChange;
import liquibase.change.Change;
import liquibase.database.Database;
import liquibase.diff.output.DiffOutputControl;
import liquibase.diff.output.changelog.ChangeGeneratorChain;
import liquibase.structure.DatabaseObject;
import liquibase.structure.core.Column;
import liquibase.structure.core.Table;
import liquibase.structure.core.View;

public class UnexpectedFunctionChangeGenerator
extends AbstractUnexpectedStoredLogicChangeGenerator {
    @Override
    public Class<? extends DatabaseObject>[] runAfterTypes() {
        return null;
    }

    @Override
    public Class<? extends DatabaseObject>[] runBeforeTypes() {
        return new Class[]{Table.class, View.class, Column.class};
    }

    @Override
    public int getPriority(Class<? extends DatabaseObject> clazz, Database database) {
        if (Function.class.isAssignableFrom(clazz)) {
            return 101;
        }
        return -1;
    }

    public Change[] fixUnexpected(DatabaseObject databaseObject, DiffOutputControl diffOutputControl, Database object, Database database, ChangeGeneratorChain changeGeneratorChain) {
        object = new DropFunctionChange();
        if (diffOutputControl.getIncludeCatalog()) {
            ((DropFunctionChange)((Object)object)).setCatalogName(databaseObject.getSchema().getCatalogName());
        }
        if (diffOutputControl.getIncludeSchema()) {
            ((DropFunctionChange)((Object)object)).setSchemaName(databaseObject.getSchema().getName());
        }
        ((DropFunctionChange)((Object)object)).setFunctionName(Function.getFunctionName(databaseObject));
        return new Change[]{object};
    }
}

