/*
 * Decompiled with CFR 0.152.
 */
package liquibase.pro.packaged;

import java.io.Writer;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import liquibase.pro.packaged.bB;
import liquibase.pro.packaged.cy;

public final class cP {
    static final char[] NO_CHARS = new char[0];
    static final int MIN_SEGMENT_LEN = 500;
    static final int MAX_SEGMENT_LEN = 65536;
    private final cy _allocator;
    private char[] _inputBuffer;
    private int _inputStart;
    private int _inputLen;
    private ArrayList<char[]> _segments;
    private boolean _hasSegments;
    private int _segmentSize;
    private char[] _currentSegment;
    private int _currentSize;
    private String _resultString;
    private char[] _resultArray;

    public cP(cy cy2) {
        this._allocator = cy2;
    }

    protected cP(cy cy2, char[] cArray) {
        this._allocator = cy2;
        this._currentSegment = cArray;
        this._currentSize = cArray.length;
        this._inputStart = -1;
    }

    public static cP fromInitial(char[] cArray) {
        return new cP(null, cArray);
    }

    public final void releaseBuffers() {
        this._inputStart = -1;
        this._currentSize = 0;
        this._inputLen = 0;
        this._inputBuffer = null;
        this._resultArray = null;
        if (this._hasSegments) {
            this.clearSegments();
        }
        if (this._allocator != null && this._currentSegment != null) {
            char[] cArray = this._currentSegment;
            this._currentSegment = null;
            this._allocator.releaseCharBuffer(2, cArray);
        }
    }

    public final void resetWithEmpty() {
        this._inputStart = -1;
        this._currentSize = 0;
        this._inputLen = 0;
        this._inputBuffer = null;
        this._resultString = null;
        this._resultArray = null;
        if (this._hasSegments) {
            this.clearSegments();
        }
    }

    public final void resetWith(char c2) {
        this._inputStart = -1;
        this._inputLen = 0;
        this._resultString = null;
        this._resultArray = null;
        if (this._hasSegments) {
            this.clearSegments();
        } else if (this._currentSegment == null) {
            this._currentSegment = this.buf(1);
        }
        this._currentSegment[0] = c2;
        cP cP2 = this;
        cP2._segmentSize = 1;
        cP2._currentSize = 1;
    }

    public final void resetWithShared(char[] cArray, int n2, int n3) {
        this._resultString = null;
        this._resultArray = null;
        this._inputBuffer = cArray;
        this._inputStart = n2;
        this._inputLen = n3;
        if (this._hasSegments) {
            this.clearSegments();
        }
    }

    public final void resetWithCopy(char[] cArray, int n2, int n3) {
        this._inputBuffer = null;
        this._inputStart = -1;
        this._inputLen = 0;
        this._resultString = null;
        this._resultArray = null;
        if (this._hasSegments) {
            this.clearSegments();
        } else if (this._currentSegment == null) {
            this._currentSegment = this.buf(n3);
        }
        cP cP2 = this;
        cP2._segmentSize = 0;
        cP2._currentSize = 0;
        this.append(cArray, n2, n3);
    }

    public final void resetWithCopy(String string, int n2, int n3) {
        this._inputBuffer = null;
        this._inputStart = -1;
        this._inputLen = 0;
        this._resultString = null;
        this._resultArray = null;
        if (this._hasSegments) {
            this.clearSegments();
        } else if (this._currentSegment == null) {
            this._currentSegment = this.buf(n3);
        }
        cP cP2 = this;
        cP2._segmentSize = 0;
        cP2._currentSize = 0;
        this.append(string, n2, n3);
    }

    public final void resetWithString(String string) {
        this._inputBuffer = null;
        this._inputStart = -1;
        this._inputLen = 0;
        this._resultString = string;
        this._resultArray = null;
        if (this._hasSegments) {
            this.clearSegments();
        }
        this._currentSize = 0;
    }

    public final char[] getBufferWithoutReset() {
        return this._currentSegment;
    }

    private char[] buf(int n2) {
        if (this._allocator != null) {
            return this._allocator.allocCharBuffer(2, n2);
        }
        return new char[Math.max(n2, 500)];
    }

    private void clearSegments() {
        this._hasSegments = false;
        this._segments.clear();
        cP cP2 = this;
        cP2._segmentSize = 0;
        cP2._currentSize = 0;
    }

    public final int size() {
        if (this._inputStart >= 0) {
            return this._inputLen;
        }
        if (this._resultArray != null) {
            return this._resultArray.length;
        }
        if (this._resultString != null) {
            return this._resultString.length();
        }
        return this._segmentSize + this._currentSize;
    }

    public final int getTextOffset() {
        if (this._inputStart >= 0) {
            return this._inputStart;
        }
        return 0;
    }

    public final boolean hasTextAsCharacters() {
        if (this._inputStart >= 0 || this._resultArray != null) {
            return true;
        }
        return this._resultString == null;
    }

    public final char[] getTextBuffer() {
        if (this._inputStart >= 0) {
            return this._inputBuffer;
        }
        if (this._resultArray != null) {
            return this._resultArray;
        }
        if (this._resultString != null) {
            this._resultArray = this._resultString.toCharArray();
            return this._resultArray;
        }
        if (!this._hasSegments) {
            if (this._currentSegment == null) {
                return NO_CHARS;
            }
            return this._currentSegment;
        }
        return this.contentsAsArray();
    }

    public final String contentsAsString() {
        if (this._resultString == null) {
            if (this._resultArray != null) {
                this._resultString = new String(this._resultArray);
            } else if (this._inputStart >= 0) {
                if (this._inputLen <= 0) {
                    this._resultString = "";
                    return "";
                }
                this._resultString = new String(this._inputBuffer, this._inputStart, this._inputLen);
            } else {
                int n2 = this._segmentSize;
                int n3 = this._currentSize;
                if (n2 == 0) {
                    this._resultString = n3 == 0 ? "" : new String(this._currentSegment, 0, n3);
                } else {
                    StringBuilder stringBuilder = new StringBuilder(n2 + n3);
                    if (this._segments != null) {
                        int n4 = this._segments.size();
                        for (n3 = 0; n3 < n4; ++n3) {
                            char[] cArray = this._segments.get(n3);
                            stringBuilder.append(cArray, 0, cArray.length);
                        }
                    }
                    stringBuilder.append(this._currentSegment, 0, this._currentSize);
                    this._resultString = stringBuilder.toString();
                }
            }
        }
        return this._resultString;
    }

    public final char[] contentsAsArray() {
        char[] cArray = this._resultArray;
        if (this._resultArray == null) {
            this._resultArray = cArray = this.resultArray();
        }
        return cArray;
    }

    public final BigDecimal contentsAsDecimal() {
        if (this._resultArray != null) {
            return bB.parseBigDecimal(this._resultArray);
        }
        if (this._inputStart >= 0 && this._inputBuffer != null) {
            return bB.parseBigDecimal(this._inputBuffer, this._inputStart, this._inputLen);
        }
        if (this._segmentSize == 0 && this._currentSegment != null) {
            return bB.parseBigDecimal(this._currentSegment, 0, this._currentSize);
        }
        return bB.parseBigDecimal(this.contentsAsArray());
    }

    @Deprecated
    public final double contentsAsDouble() {
        return this.contentsAsDouble(false);
    }

    public final double contentsAsDouble(boolean bl2) {
        return bB.parseDouble(this.contentsAsString(), bl2);
    }

    @Deprecated
    public final float contentsAsFloat() {
        return this.contentsAsFloat(false);
    }

    public final float contentsAsFloat(boolean bl2) {
        return bB.parseFloat(this.contentsAsString(), bl2);
    }

    public final int contentsAsInt(boolean bl2) {
        if (this._inputStart >= 0 && this._inputBuffer != null) {
            if (bl2) {
                return -bB.parseInt(this._inputBuffer, this._inputStart + 1, this._inputLen - 1);
            }
            return bB.parseInt(this._inputBuffer, this._inputStart, this._inputLen);
        }
        if (bl2) {
            return -bB.parseInt(this._currentSegment, 1, this._currentSize - 1);
        }
        return bB.parseInt(this._currentSegment, 0, this._currentSize);
    }

    public final long contentsAsLong(boolean bl2) {
        if (this._inputStart >= 0 && this._inputBuffer != null) {
            if (bl2) {
                return -bB.parseLong(this._inputBuffer, this._inputStart + 1, this._inputLen - 1);
            }
            return bB.parseLong(this._inputBuffer, this._inputStart, this._inputLen);
        }
        if (bl2) {
            return -bB.parseLong(this._currentSegment, 1, this._currentSize - 1);
        }
        return bB.parseLong(this._currentSegment, 0, this._currentSize);
    }

    public final int contentsToWriter(Writer writer) {
        int n2;
        if (this._resultArray != null) {
            writer.write(this._resultArray);
            return this._resultArray.length;
        }
        if (this._resultString != null) {
            writer.write(this._resultString);
            return this._resultString.length();
        }
        if (this._inputStart >= 0) {
            int n3 = this._inputLen;
            if (n3 > 0) {
                writer.write(this._inputBuffer, this._inputStart, n3);
            }
            return n3;
        }
        int n4 = 0;
        if (this._segments != null) {
            int n5 = this._segments.size();
            for (n2 = 0; n2 < n5; ++n2) {
                char[] cArray = this._segments.get(n2);
                int n6 = cArray.length;
                writer.write(cArray, 0, n6);
                n4 += n6;
            }
        }
        if ((n2 = this._currentSize) > 0) {
            writer.write(this._currentSegment, 0, n2);
            n4 += n2;
        }
        return n4;
    }

    public final void ensureNotShared() {
        if (this._inputStart >= 0) {
            this.unshare(16);
        }
    }

    public final void append(char c2) {
        if (this._inputStart >= 0) {
            this.unshare(16);
        }
        this._resultString = null;
        this._resultArray = null;
        char[] cArray = this._currentSegment;
        if (this._currentSize >= cArray.length) {
            this.expand(1);
            cArray = this._currentSegment;
        }
        cArray[this._currentSize++] = c2;
    }

    public final void append(char[] cArray, int n2, int n3) {
        int n4;
        if (this._inputStart >= 0) {
            this.unshare(n3);
        }
        this._resultString = null;
        this._resultArray = null;
        char[] cArray2 = this._currentSegment;
        int n5 = this._currentSegment.length - this._currentSize;
        if (n5 >= n3) {
            System.arraycopy(cArray, n2, cArray2, this._currentSize, n3);
            this._currentSize += n3;
            return;
        }
        if (n5 > 0) {
            System.arraycopy(cArray, n2, cArray2, this._currentSize, n5);
            n2 += n5;
            n3 -= n5;
        }
        do {
            this.expand(n3);
            n4 = Math.min(this._currentSegment.length, n3);
            System.arraycopy(cArray, n2, this._currentSegment, 0, n4);
            this._currentSize += n4;
            n2 += n4;
        } while ((n3 -= n4) > 0);
    }

    public final void append(String string, int n2, int n3) {
        int n4;
        if (this._inputStart >= 0) {
            this.unshare(n3);
        }
        this._resultString = null;
        this._resultArray = null;
        char[] cArray = this._currentSegment;
        int n5 = this._currentSegment.length - this._currentSize;
        if (n5 >= n3) {
            int n6 = n2;
            string.getChars(n6, n6 + n3, cArray, this._currentSize);
            this._currentSize += n3;
            return;
        }
        if (n5 > 0) {
            int n7 = n2;
            string.getChars(n7, n7 + n5, cArray, this._currentSize);
            n3 -= n5;
            n2 += n5;
        }
        do {
            this.expand(n3);
            n4 = Math.min(this._currentSegment.length, n3);
            int n8 = n2;
            string.getChars(n8, n8 + n4, this._currentSegment, 0);
            this._currentSize += n4;
            n2 += n4;
        } while ((n3 -= n4) > 0);
    }

    public final char[] getCurrentSegment() {
        if (this._inputStart >= 0) {
            this.unshare(1);
        } else {
            char[] cArray = this._currentSegment;
            if (this._currentSegment == null) {
                this._currentSegment = this.buf(0);
            } else if (this._currentSize >= cArray.length) {
                this.expand(1);
            }
        }
        return this._currentSegment;
    }

    public final char[] emptyAndGetCurrentSegment() {
        this._inputStart = -1;
        this._currentSize = 0;
        this._inputLen = 0;
        this._inputBuffer = null;
        this._resultString = null;
        this._resultArray = null;
        if (this._hasSegments) {
            this.clearSegments();
        }
        char[] cArray = this._currentSegment;
        if (this._currentSegment == null) {
            this._currentSegment = cArray = this.buf(0);
        }
        return cArray;
    }

    public final int getCurrentSegmentSize() {
        return this._currentSize;
    }

    public final void setCurrentLength(int n2) {
        this._currentSize = n2;
    }

    public final String setCurrentAndReturn(int n2) {
        String string;
        this._currentSize = n2;
        if (this._segmentSize > 0) {
            return this.contentsAsString();
        }
        n2 = this._currentSize;
        this._resultString = string = n2 == 0 ? "" : new String(this._currentSegment, 0, n2);
        return string;
    }

    public final char[] finishCurrentSegment() {
        if (this._segments == null) {
            this._segments = new ArrayList();
        }
        this._hasSegments = true;
        this._segments.add(this._currentSegment);
        int n2 = this._currentSegment.length;
        this._segmentSize += n2;
        this._currentSize = 0;
        int n3 = n2;
        n2 = n3 + (n3 >> 1);
        if (n2 < 500) {
            n2 = 500;
        } else if (n2 > 65536) {
            n2 = 65536;
        }
        char[] cArray = this.carr(n2);
        this._currentSegment = cArray;
        return cArray;
    }

    public final char[] expandCurrentSegment() {
        char[] cArray = this._currentSegment;
        int n2 = this._currentSegment.length;
        int n3 = n2 + (n2 >> 1);
        if (n3 > 65536) {
            int n4 = n2;
            n3 = n4 + (n4 >> 2);
        }
        this._currentSegment = Arrays.copyOf(cArray, n3);
        return this._currentSegment;
    }

    public final char[] expandCurrentSegment(int n2) {
        char[] cArray = this._currentSegment;
        if (this._currentSegment.length >= n2) {
            return cArray;
        }
        this._currentSegment = cArray = Arrays.copyOf(cArray, n2);
        return cArray;
    }

    public final String toString() {
        return this.contentsAsString();
    }

    private void unshare(int n2) {
        int n3 = this._inputLen;
        this._inputLen = 0;
        char[] cArray = this._inputBuffer;
        this._inputBuffer = null;
        int n4 = this._inputStart;
        this._inputStart = -1;
        n2 = n3 + n2;
        if (this._currentSegment == null || n2 > this._currentSegment.length) {
            this._currentSegment = this.buf(n2);
        }
        if (n3 > 0) {
            System.arraycopy(cArray, n4, this._currentSegment, 0, n3);
        }
        this._segmentSize = 0;
        this._currentSize = n3;
    }

    private void expand(int n2) {
        if (this._segments == null) {
            this._segments = new ArrayList();
        }
        char[] cArray = this._currentSegment;
        this._hasSegments = true;
        this._segments.add(cArray);
        this._segmentSize += cArray.length;
        this._currentSize = 0;
        int n3 = cArray.length;
        int n4 = n3 + (n3 >> 1);
        if (n4 < 500) {
            n4 = 500;
        } else if (n4 > 65536) {
            n4 = 65536;
        }
        this._currentSegment = this.carr(n4);
    }

    private char[] resultArray() {
        if (this._resultString != null) {
            return this._resultString.toCharArray();
        }
        if (this._inputStart >= 0) {
            int n2 = this._inputLen;
            if (n2 <= 0) {
                return NO_CHARS;
            }
            int n3 = this._inputStart;
            if (n3 == 0) {
                return Arrays.copyOf(this._inputBuffer, n2);
            }
            int n4 = n3;
            return Arrays.copyOfRange(this._inputBuffer, n4, n4 + n2);
        }
        int n5 = this.size();
        if (n5 <= 0) {
            return NO_CHARS;
        }
        int n6 = 0;
        char[] cArray = this.carr(n5);
        if (this._segments != null) {
            int n7 = this._segments.size();
            for (int i2 = 0; i2 < n7; ++i2) {
                char[] cArray2 = this._segments.get(i2);
                int n8 = cArray2.length;
                System.arraycopy(cArray2, 0, cArray, n6, n8);
                n6 += n8;
            }
        }
        System.arraycopy(this._currentSegment, 0, cArray, n6, this._currentSize);
        return cArray;
    }

    private char[] carr(int n2) {
        return new char[n2];
    }
}

