/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.command;

import com.datical.liquibase.ext.command.RollbackOneChangesetCommandStep;
import com.datical.liquibase.ext.command.helpers.RollbackOnErrorArgument;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import liquibase.Liquibase;
import liquibase.Scope;
import liquibase.change.AbstractChange;
import liquibase.change.Change;
import liquibase.change.DbmsTargetedChange;
import liquibase.changelog.ChangeLogParameters;
import liquibase.changelog.ChangeSet;
import liquibase.changelog.visitor.DefaultChangeExecListener;
import liquibase.command.AbstractCommandStep;
import liquibase.command.CommandArgumentDefinition;
import liquibase.command.CommandBuilder;
import liquibase.command.CommandDefinition;
import liquibase.command.CommandResultsBuilder;
import liquibase.command.CommandScope;
import liquibase.database.Database;
import liquibase.database.DatabaseList;
import liquibase.exception.CommandValidationException;
import liquibase.exception.DatabaseException;
import liquibase.exception.LiquibaseException;
import liquibase.exception.LockException;
import liquibase.exception.MigrationFailedException;
import liquibase.exception.RollbackFailedException;
import liquibase.exception.ValidationErrors;
import liquibase.executor.Executor;
import liquibase.executor.ExecutorService;
import liquibase.executor.LoggingExecutor;
import liquibase.license.LicenseServiceUtils;
import liquibase.lockservice.LockService;
import liquibase.lockservice.LockServiceFactory;
import liquibase.logging.Logger;
import liquibase.logging.mdc.CustomMdcObject;
import liquibase.logging.mdc.customobjects.ChangesetsRolledback;
import liquibase.resource.ResourceAccessor;
import liquibase.statement.SqlStatement;

public class InternalRollbackOnErrorCommandStep
extends AbstractCommandStep {
    private static final ResourceBundle coreBundle = ResourceBundle.getBundle("liquibase/i18n/liquibase-core");
    protected static final String MSG_COULD_NOT_RELEASE_LOCK = coreBundle.getString("could.not.release.lock");
    private static final String CHANGE_SET_DOES_NOT_SUPPORT_ROLLBACK_ERROR_MESSAGE = "ERROR: There was an error with changeset '%s' by author '%s' in file '%s'. The --rollback-on-error flag was set, but at least one changeset in this deployment does not contain a rollback so no changeset in this deployment will be auto-rolled back.";
    private static final String ROLLBACK_ON_ERROR_WILL_BE_EXECUTED = "ERROR: There was an error with changeset '%s' by author '%s' in file '%s'. The --rollback-on-error flag was set, so all changes from this deployment will be rolled back.";
    private static final String NO_CHANGE_SETS_TO_ROLLBACK = "ERROR: There was an error with changeset '%s' by author '%s' in file '%s'. The --rollback-on-error flag was set, but no deployed changesets to rollback were found.";
    private static final String PARTIAL_CHANGE_SETS_TO_ROLLBACK = "INFO: Incomplete deployment detected from changeset '%s' by author '%s' in file '%s'. Rolling back deployed changes from this changeset.";
    private static final String PARTIAL_CHANGE_SETS_TO_ROLLBACK_COMPLETE = "INFO: Successfully rolled back changes from the incomplete deployment.";
    private static final String ROLLBACK_ON_ERROR_COMPLETE = "ERROR: Liquibase operation encountered an error during deployment from changelog %s, and rollback-on-error is set to true. Changes have been rolled back successfully!";
    public static final String[] COMMAND_NAME = new String[]{"internalRollbackOnError"};
    public static final CommandArgumentDefinition<Boolean> ROLLBACK_ON_ERROR_ARG;
    public static final CommandArgumentDefinition<Database> DATABASE_ARG;
    public static final CommandArgumentDefinition<LiquibaseException> EXCEPTION_ARG;
    public static final CommandArgumentDefinition<DefaultChangeExecListener> LISTENER;

    public String[][] defineCommandNames() {
        return new String[][]{COMMAND_NAME};
    }

    public void adjustCommandDefinition(CommandDefinition commandDefinition) {
        super.adjustCommandDefinition(commandDefinition);
        commandDefinition.setInternal(true);
    }

    public void run(CommandResultsBuilder commandResultsBuilder) {
        Logger logger = Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass());
        Object object = commandResultsBuilder.getCommandScope();
        LiquibaseException liquibaseException = (LiquibaseException)((Object)object.getConfiguredValue(EXCEPTION_ARG).getValue());
        boolean bl2 = this.findRollbackOnErrorArg((CommandScope)object);
        if (!(liquibaseException.getCause() instanceof MigrationFailedException) || !bl2) {
            throw liquibaseException;
        }
        if (!LicenseServiceUtils.isProLicenseValid()) {
            throw new CommandValidationException(String.format("Using 'rollback-on-error' requires a valid Liquibase Pro or Labs license. Get a free license key at %s.", "https://liquibase.com/trial"), (Throwable)liquibaseException);
        }
        liquibaseException = (Database)object.getConfiguredValue(DATABASE_ARG).getValue();
        object = (DefaultChangeExecListener)object.getConfiguredValue(LISTENER).getValue();
        ChangeSet changeSet = (ChangeSet)object.getFailedChangeSets().stream().findFirst().orElseThrow(() -> new LiquibaseException("Failed changeset not found."));
        Object object2 = object.getDeployedChanges(changeSet);
        object = object.getDeployedChangeSets();
        ChangeLogParameters changeLogParameters = new ChangeLogParameters((Database)liquibaseException);
        String string = changeSet.getChangeLog().getFilePath();
        Liquibase liquibase = new Liquibase(string, Scope.getCurrentScope().getResourceAccessor(), (Database)liquibaseException);
        LockService lockService = LockServiceFactory.getInstance().getLockService((Database)liquibaseException);
        ChangeSet changeSet2 = new ChangeSet(changeSet.getId(), changeSet.getAuthor(), false, false, changeSet.getFilePath(), changeSet.getContextFilter().toString(), null, liquibase.getDatabaseChangeLog());
        boolean bl3 = !object2.isEmpty();
        boolean bl4 = object2.stream().allMatch(arg_0 -> InternalRollbackOnErrorCommandStep.lambda$run$1((Database)liquibaseException, arg_0));
        boolean bl5 = !object.isEmpty();
        boolean bl6 = object.stream().allMatch(arg_0 -> InternalRollbackOnErrorCommandStep.lambda$run$2((Database)liquibaseException, arg_0));
        if (!bl5 && !bl3) {
            throw commandResultsBuilder.commandFailed(String.format(NO_CHANGE_SETS_TO_ROLLBACK, changeSet.getId(), changeSet.getAuthor(), changeSet.getFilePath()), 1);
        }
        if (bl5 && !bl6 || bl3 && !bl4) {
            throw commandResultsBuilder.commandFailed(String.format(CHANGE_SET_DOES_NOT_SUPPORT_ROLLBACK_ERROR_MESSAGE, changeSet.getId(), changeSet.getAuthor(), changeSet.getFilePath()), 1);
        }
        Scope.getCurrentScope().getUI().sendMessage(String.format(ROLLBACK_ON_ERROR_WILL_BE_EXECUTED, changeSet.getId(), changeSet.getAuthor(), changeSet.getFilePath()));
        Collections.reverse(object);
        lockService.waitForLock();
        ArrayList arrayList = new ArrayList();
        try {
            if (bl3) {
                Collections.reverse(object2);
                object2.forEach(arg_0 -> ((ChangeSet)changeSet2).addChange(arg_0));
                Scope.getCurrentScope().getUI().sendMessage(String.format(PARTIAL_CHANGE_SETS_TO_ROLLBACK, changeSet.getId(), changeSet.getAuthor(), changeSet.getFilePath()));
                this.rollback(changeSet2, (Database)liquibaseException);
                Scope.getCurrentScope().getUI().sendMessage(PARTIAL_CHANGE_SETS_TO_ROLLBACK_COMPLETE);
            }
            object = object.iterator();
            while (object.hasNext()) {
                changeSet = (ChangeSet)object.next();
                object2 = changeSet.getChangeLog().getFilePath();
                changeSet = this.createRollbackOneChangeSetCommand((String)object2, changeSet, (Database)liquibaseException, liquibase, changeLogParameters).execute();
                arrayList.addAll((List)changeSet.getResult("processedChangesets"));
            }
            Scope.getCurrentScope().addMdcValue("changesetsRolledback", (CustomMdcObject)new ChangesetsRolledback(arrayList));
            Scope.getCurrentScope().addMdcValue("liquibaseInternalCommand", COMMAND_NAME[0]);
            throw commandResultsBuilder.commandFailed(String.format(ROLLBACK_ON_ERROR_COMPLETE, string), 1, true);
        }
        catch (Throwable throwable) {
            Scope.getCurrentScope().addMdcValue("changesetsRolledback", (CustomMdcObject)new ChangesetsRolledback(arrayList));
            try {
                lockService.releaseLock();
            }
            catch (LockException lockException) {
                logger.severe(MSG_COULD_NOT_RELEASE_LOCK, (Throwable)lockException);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private CommandScope createRollbackOneChangeSetCommand(String string, ChangeSet object, Database object22, Liquibase liquibase, ChangeLogParameters changeLogParameters) {
        void var5_7;
        void var4_6;
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("changeLogFile", string);
        hashMap.put("database", object22);
        hashMap.put("liquibase", var4_6);
        hashMap.put("changeLogParameters", var5_7);
        hashMap.put("changeSetId", object.getId());
        hashMap.put("changeSetAuthor", object.getAuthor());
        hashMap.put("changeSetPath", object.getFilePath());
        hashMap.put("force", Boolean.TRUE);
        hashMap.put(RollbackOneChangesetCommandStep.SHOULD_LOG_MDC_CHANGESETS_ROLLED_BACK.getName(), Boolean.FALSE);
        string = new CommandScope(new String[]{RollbackOneChangesetCommandStep.COMMAND_NAME[0]});
        for (Map.Entry entry : hashMap.entrySet()) {
            string.addArgumentValue((String)entry.getKey(), entry.getValue());
        }
        return string;
    }

    private void rollback(ChangeSet changeSet, Database database) {
        Executor executor = this.setupCustomExecutorIfNecessary(changeSet, database);
        try {
            List<SqlStatement> list;
            if (database.supportsDDLInTransaction()) {
                database.setAutoCommit(!changeSet.isRunInTransaction());
            }
            if (changeSet.hasCustomRollbackChanges()) {
                list = new LinkedList();
                for (SqlStatement[] sqlStatementArray : changeSet.getRollback().getChanges()) {
                    if (sqlStatementArray instanceof DbmsTargetedChange && !DatabaseList.definitionMatches((String)((DbmsTargetedChange)sqlStatementArray).getDbms(), (Database)database, (boolean)true)) continue;
                    ValidationErrors validationErrors = sqlStatementArray.validate(database);
                    if (validationErrors.hasErrors()) {
                        throw new RollbackFailedException("Rollback statement failed validation: ".concat(String.valueOf(validationErrors)));
                    }
                    if ((sqlStatementArray = sqlStatementArray.generateStatements(database)) == null) continue;
                    list.addAll(Arrays.asList(sqlStatementArray));
                }
                if (!list.isEmpty()) {
                    database.executeRollbackStatements(list.toArray(new SqlStatement[0]), changeSet.getSqlVisitors());
                }
            } else {
                list = changeSet.getChanges();
                for (int i2 = list.size() - 1; i2 >= 0; --i2) {
                    Change change = (Change)list.get(i2);
                    database.executeRollbackStatements(change, changeSet.getSqlVisitors());
                }
            }
            if (changeSet.isRunInTransaction()) {
                database.commit();
            }
            Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass()).fine("ChangeSet " + changeSet + " has been successfully rolled back.");
        }
        catch (Exception exception) {
            try {
                try {
                    database.rollback();
                }
                catch (DatabaseException databaseException) {}
                throw new RollbackFailedException((Throwable)exception);
            }
            catch (Throwable throwable) {
                ((ExecutorService)Scope.getCurrentScope().getSingleton(ExecutorService.class)).setExecutor("jdbc", database, executor);
                if (!changeSet.isRunInTransaction() && database.supportsDDLInTransaction()) {
                    try {
                        database.setAutoCommit(false);
                    }
                    catch (DatabaseException databaseException) {
                        Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass()).warning("Could not resetInternalState autocommit", (Throwable)databaseException);
                    }
                }
                throw throwable;
            }
        }
        ((ExecutorService)Scope.getCurrentScope().getSingleton(ExecutorService.class)).setExecutor("jdbc", database, executor);
        if (!changeSet.isRunInTransaction() && database.supportsDDLInTransaction()) {
            try {
                database.setAutoCommit(false);
                return;
            }
            catch (DatabaseException databaseException) {
                Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass()).warning("Could not resetInternalState autocommit", (Throwable)databaseException);
                return;
            }
        }
    }

    private Executor setupCustomExecutorIfNecessary(ChangeSet object, Database database2) {
        Executor executor = ((ExecutorService)Scope.getCurrentScope().getSingleton(ExecutorService.class)).getExecutor("jdbc", database2);
        if (object.getRunWith() == null || executor instanceof LoggingExecutor) {
            return executor;
        }
        String string = ChangeSet.lookupExecutor((String)object.getRunWith());
        string = ((ExecutorService)Scope.getCurrentScope().getSingleton(ExecutorService.class)).getExecutor(string, database2);
        ((ExecutorService)Scope.getCurrentScope().getSingleton(ExecutorService.class)).setExecutor("jdbc", database2, (Executor)string);
        for (Database database2 : object.getChanges()) {
            if (!(database2 instanceof AbstractChange) || (database2 = ((AbstractChange)database2).getResourceAccessor()) == null) continue;
            string.setResourceAccessor((ResourceAccessor)database2);
            break;
        }
        return executor;
    }

    private boolean findRollbackOnErrorArg(CommandScope object) {
        Boolean bl2 = (Boolean)Scope.getCurrentScope().get("rollbackOnError", Boolean.class);
        Boolean bl3 = (Boolean)object.getConfiguredValue(ROLLBACK_ON_ERROR_ARG).getValue();
        object = (Boolean)object.getDependency(RollbackOnErrorArgument.class);
        return Boolean.TRUE.equals(bl2) || Boolean.TRUE.equals(bl3) || Boolean.TRUE.equals(object);
    }

    private static /* synthetic */ boolean lambda$run$2(Database database, ChangeSet changeSet) {
        return changeSet.supportsRollback(database);
    }

    private static /* synthetic */ boolean lambda$run$1(Database database, Change change) {
        return change.supportsRollback(database);
    }

    static {
        CommandBuilder commandBuilder = new CommandBuilder((String[][])new String[][]{COMMAND_NAME});
        ROLLBACK_ON_ERROR_ARG = commandBuilder.argument("rollbackOnError", Boolean.class).defaultValue((Object)Boolean.FALSE).build();
        DATABASE_ARG = commandBuilder.argument("database", Database.class).required().build();
        EXCEPTION_ARG = commandBuilder.argument("exception", LiquibaseException.class).required().build();
        LISTENER = commandBuilder.argument("listener", DefaultChangeExecListener.class).required().build();
    }
}

