/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.command;

import com.datical.liquibase.ext.changelog.filter.SingleRanChangeSetFilter;
import com.datical.liquibase.ext.command.AbstractRollbackOneCommand;
import com.datical.liquibase.ext.command.RollbackOneChangesetCommandStep$1;
import com.datical.liquibase.ext.util.ProStringUtil;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Level;
import liquibase.Contexts;
import liquibase.LabelExpression;
import liquibase.RuntimeEnvironment;
import liquibase.Scope;
import liquibase.change.Change;
import liquibase.change.core.RawSQLChange;
import liquibase.changelog.ChangeLogIterator;
import liquibase.changelog.ChangeLogParameters;
import liquibase.changelog.ChangeSet;
import liquibase.changelog.DatabaseChangeLog;
import liquibase.changelog.filter.ChangeSetFilter;
import liquibase.changelog.visitor.ChangeExecListener;
import liquibase.changelog.visitor.ChangeSetVisitor;
import liquibase.command.CommandArgumentDefinition;
import liquibase.command.CommandBuilder;
import liquibase.command.CommandDefinition;
import liquibase.command.CommandResultsBuilder;
import liquibase.database.Database;
import liquibase.exception.CommandValidationException;
import liquibase.exception.DatabaseException;
import liquibase.exception.LiquibaseException;
import liquibase.exception.RollbackImpossibleException;
import liquibase.executor.Executor;
import liquibase.executor.ExecutorService;
import liquibase.license.LicenseServiceUtils;
import liquibase.lockservice.LockService;
import liquibase.lockservice.LockServiceFactory;
import liquibase.logging.Logger;
import liquibase.logging.mdc.CustomMdcObject;
import liquibase.logging.mdc.customobjects.ChangesetsRolledback;
import liquibase.resource.Resource;
import liquibase.util.StreamUtil;

public class RollbackOneChangesetCommandStep
extends AbstractRollbackOneCommand {
    public static final String[] COMMAND_NAME = new String[]{"rollbackOneChangeset"};
    public static final CommandArgumentDefinition<String> CHANGESET_ID_ARG;
    public static final CommandArgumentDefinition<String> CHANGESET_AUTHOR_ARG;
    public static final CommandArgumentDefinition<String> CHANGESET_PATH_ARG;
    public static CommandArgumentDefinition<Boolean> FORCE_ARG;
    public static final CommandArgumentDefinition<String> ROLLBACK_SCRIPT_ARG;
    private static final ResourceBundle coreBundle;
    public static final CommandArgumentDefinition<Boolean> SHOULD_LOG_MDC_CHANGESETS_ROLLED_BACK;

    public String[][] defineCommandNames() {
        return new String[][]{COMMAND_NAME};
    }

    public List<Class<?>> requiredDependencies() {
        return Arrays.asList(Database.class, LockService.class, DatabaseChangeLog.class, ChangeExecListener.class, ChangeLogParameters.class);
    }

    public void adjustCommandDefinition(CommandDefinition commandDefinition) {
        commandDefinition.setShortDescription(ProStringUtil.markWithPro("Rollback one changeset from the database"));
    }

    protected void removeRunStatus(ChangeLogIterator changeLogIterator, Contexts contexts, LabelExpression labelExpression, Database database) {
        changeLogIterator.run((ChangeSetVisitor)new RollbackOneChangesetCommandStep$1(this), new RuntimeEnvironment(database, contexts, labelExpression));
    }

    public void run(CommandResultsBuilder object) {
        LicenseServiceUtils.checkProLicenseAndThrowException((String[])COMMAND_NAME);
        Logger logger = Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass());
        Object object2 = object.getCommandScope();
        String string = (String)object2.getArgumentValue(CHANGESET_ID_ARG);
        String string2 = (String)object2.getArgumentValue(CHANGESET_AUTHOR_ARG);
        String string3 = (String)object2.getArgumentValue(CHANGESET_PATH_ARG);
        String string4 = (String)object2.getArgumentValue(ROLLBACK_SCRIPT_ARG);
        ChangeLogParameters changeLogParameters = (ChangeLogParameters)object2.getDependency(ChangeLogParameters.class);
        Contexts contexts = changeLogParameters.getContexts();
        LabelExpression labelExpression = changeLogParameters.getLabels();
        DatabaseChangeLog databaseChangeLog = (DatabaseChangeLog)object2.getDependency(DatabaseChangeLog.class);
        Database database = (Database)object2.getDependency(Database.class);
        Object object3 = (Boolean)object2.getArgumentValue(FORCE_ARG);
        boolean bl2 = (Boolean)object2.getArgumentValue(SHOULD_LOG_MDC_CHANGESETS_ROLLED_BACK);
        object2 = (ChangeExecListener)object2.getDependency(ChangeExecListener.class);
        LockServiceFactory.getInstance().getLockService(database);
        if (string == null || string2 == null || string3 == null) {
            throw new CommandValidationException(coreBundle.getString("id.author.path.required"));
        }
        if (object3 == null || !((Boolean)object3).booleanValue()) {
            object3 = "\nWARNING: Targeted rollback of this changeset may result in unexpected outcomes.  To review the rollback\nSQL before executing it, please run 'rollback-one-changeset-sql'. This message can be suppressed by adding the --force flag.";
            throw new LiquibaseException((String)object3, Level.WARNING);
        }
        Scope.getCurrentScope().addMdcValue("rollbackScript", string4);
        Scope.getCurrentScope().addMdcValue("liquibaseTargetUrl", database.getConnection().getURL());
        Scope.getCurrentScope().addMdcValue("rollbackOneChangesetForce", String.valueOf(object3));
        object3 = null;
        try {
            Object object4;
            databaseChangeLog.validate(database, contexts, labelExpression);
            List list = database.getRanChangeSetList();
            object3 = new SingleRanChangeSetFilter(string, string2, string3, list, databaseChangeLog);
            if (((SingleRanChangeSetFilter)object3).isEmpty()) {
                throw new LiquibaseException(this.buildNoChangesetFoundException((SingleRanChangeSetFilter)object3, string3, string, string2));
            }
            list = this.createChangeLogIterator(list, (ChangeSetFilter)object3, databaseChangeLog, contexts, labelExpression, database);
            if (string4 == null) {
                object4 = new ArrayList();
                list.run((ChangeSetVisitor)this.createRollbackVisitor((List<ChangesetsRolledback.ChangeSet>)object4, database, (ChangeExecListener)object2), new RuntimeEnvironment(database, contexts, labelExpression));
                if (bl2) {
                    Scope.getCurrentScope().addMdcValue("changesetsRolledback", (CustomMdcObject)new ChangesetsRolledback((List)object4), false);
                }
                object.addResult("processedChangesets", object4);
            } else {
                object4 = ((SingleRanChangeSetFilter)object3).getMatchingChangeSet();
                this.executeRollbackScript(string4, (ChangeSet)object4, databaseChangeLog, changeLogParameters, database, (ChangeExecListener)object2);
                this.removeRunStatus((ChangeLogIterator)list, contexts, labelExpression, database);
                object2 = Collections.singletonList(ChangesetsRolledback.ChangeSet.fromChangeSet((ChangeSet)object4));
                if (bl2) {
                    Scope.getCurrentScope().addMdcValue("changesetsRolledback", (CustomMdcObject)new ChangesetsRolledback((List)object2));
                }
                object.addResult("processedChangesets", object2);
                logger.info("Executed rollback script ".concat(String.valueOf(string4)));
            }
            object4 = Scope.getCurrentScope().getMdcManager().put("deploymentOutcome", "success");
            object2 = null;
            try {
                Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass()).info("Rollback command completed successfully.");
            }
            catch (Throwable throwable) {
                object = throwable;
                object2 = throwable;
                throw object;
            }
            finally {
                if (object4 != null) {
                    if (object2 != null) {
                        try {
                            object4.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object2).addSuppressed(throwable);
                        }
                    } else {
                        object4.close();
                    }
                }
            }
        }
        catch (LiquibaseException liquibaseException) {
            this.handleRollbackError((Exception)((Object)liquibaseException), (SingleRanChangeSetFilter)object3, string3, string, string2);
        }
        Scope.getCurrentScope().getUI().sendMessage("rollback-one-changeset executed for " + database.getConnection().getConnectionUserName() + "@" + database.getConnection().getURL());
    }

    private String getChangeSetString(ChangeSet changeSet) {
        if (changeSet == null) {
            return null;
        }
        return changeSet.toString(false);
    }

    private void executeRollbackScript(String string, ChangeSet changeSet, DatabaseChangeLog databaseChangeLog, ChangeLogParameters object, Database database, ChangeExecListener changeExecListener) {
        Resource resource;
        Executor executor = ((ExecutorService)Scope.getCurrentScope().getSingleton(ExecutorService.class)).getExecutor("jdbc", database);
        try {
            resource = Scope.getCurrentScope().getResourceAccessor().get(string);
            if (resource == null) {
                throw new LiquibaseException("WARNING: The rollback script '" + string + "' was not located. Please check your parameters. No rollback was performed.");
            }
            string = StreamUtil.readStreamAsString((InputStream)resource.openInputStream());
        }
        catch (IOException iOException) {
            throw new LiquibaseException("Error reading rollbackScript " + executor + ": " + iOException.getMessage());
        }
        string = object.expandExpressions(string, databaseChangeLog);
        resource = this.buildRawSQLChange(string);
        object = this.getChangeSetString(changeSet);
        try {
            if (changeExecListener != null) {
                changeExecListener.willRollback(changeSet, databaseChangeLog, database);
            }
            Scope.getCurrentScope().getUI().sendMessage("Rolling Back Changeset:".concat(String.valueOf(object)));
            executor.execute((Change)resource);
            if (changeExecListener != null) {
                changeExecListener.rolledBack(changeSet, databaseChangeLog, database);
            }
        }
        catch (DatabaseException databaseException) {
            Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass()).severe("Error executing rollback script: " + databaseException.getMessage());
            if (changeExecListener != null) {
                changeExecListener.rollbackFailed(changeSet, databaseChangeLog, database, (Exception)((Object)databaseException));
            }
            throw new LiquibaseException("\nError executing rollback for the targeted changeset '" + (String)object + "':\n" + databaseException.getMessage(), (Throwable)databaseException);
        }
        database.commit();
        if (string.length() == 0) {
            Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass()).info("No rollback logic defined in empty rollback script. Changesets have been removed from\nthe DATABASECHANGELOG table but no other logic was performed.");
        }
    }

    protected RawSQLChange buildRawSQLChange(String string) {
        string = new RawSQLChange(string);
        string.setSplitStatements(Boolean.TRUE);
        string.setStripComments(Boolean.TRUE);
        return string;
    }

    private String buildNoChangesetFoundException(SingleRanChangeSetFilter singleRanChangeSetFilter, String string, String string2, String string3) {
        String string4 = "rollback-one-changeset";
        string = string + "::" + string2 + "::" + string3;
        string = "\n\nWARNING:  The command '" + string4 + "' failed because the targeted changeset\n'" + string + "' cannot be located.\nAt least one supplied parameter cannot be found in combination with the other parameters.\nPlease check your details and try again.\n";
        if (singleRanChangeSetFilter.getMatchingIdChangeSet() != null) {
            string = string + "\nNOTE:  A changeset with this ID was located.\n";
        }
        return string + "No rollback was performed.";
    }

    private void handleRollbackError(Exception exception, SingleRanChangeSetFilter object, String object2, String string, String object3) {
        Logger logger = Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass());
        object = object != null && !((SingleRanChangeSetFilter)object).isEmpty() ? this.getChangeSetString(((SingleRanChangeSetFilter)object).getMatchingChangeSet()) : (String)object2 + "::" + string + "::" + (String)object3;
        object2 = exception.getCause();
        string = Scope.getCurrentScope().addMdcValue("deploymentOutcome", "fail");
        object3 = null;
        try {
            Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass()).info("Rollback command encountered an exception.");
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            object3 = throwable;
            throw throwable2;
        }
        finally {
            if (string != null) {
                if (object3 != null) {
                    try {
                        string.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object3).addSuppressed(throwable);
                    }
                } else {
                    string.close();
                }
            }
        }
        if (object2 instanceof RollbackImpossibleException) {
            logger.severe("\nError executing rollback:\nThe targeted changeset '" + (String)object + "' does not have a rollback defined\nPlease add a rollback change or script in the appropriate changeset.  You can also specify a rollback script as an argument to this command.\n", (Throwable)exception);
            throw new LiquibaseException("\nError executing rollback:\nThe targeted changeset '" + (String)object + "' does not have a rollback defined.\nPlease add a rollback change or script in the appropriate changeset.  You can also specify a rollback script as an argument to this command.\n", (Throwable)exception);
        }
        logger.severe("\nError executing rollback for the targeted changeset '" + (String)object + "'.");
        throw new LiquibaseException("\nError executing rollback for the targeted changeset '" + (String)object + "':\n" + exception.getMessage(), (Throwable)exception);
    }

    static {
        coreBundle = ResourceBundle.getBundle("liquibase/i18n/liquibase-core");
        CommandBuilder commandBuilder = new CommandBuilder((String[][])new String[][]{COMMAND_NAME});
        CHANGESET_ID_ARG = commandBuilder.argument("changesetId", String.class).description("The id of the changeset to rollback").required().build();
        CHANGESET_AUTHOR_ARG = commandBuilder.argument("changesetAuthor", String.class).description("The author of the changeset to rollback").required().build();
        CHANGESET_PATH_ARG = commandBuilder.argument("changesetPath", String.class).description("The target database password").required().build();
        FORCE_ARG = commandBuilder.argument("force", Boolean.class).description("A required safety flag to indicate you intend to use this feature").defaultValue((Object)Boolean.FALSE).build();
        ROLLBACK_SCRIPT_ARG = commandBuilder.argument("rollbackScript", String.class).description("The path to the script to use to perform the rollback").build();
        SHOULD_LOG_MDC_CHANGESETS_ROLLED_BACK = commandBuilder.argument("shouldLogMdcChangesetsRolledBack", Boolean.class).hidden().defaultValue((Object)Boolean.TRUE).build();
    }
}

