/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.command;

import com.datical.liquibase.ext.changelog.filter.DeploymentIdFilter;
import com.datical.liquibase.ext.command.AbstractRollbackOneCommand;
import com.datical.liquibase.ext.util.ProStringUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.logging.Level;
import liquibase.Contexts;
import liquibase.LabelExpression;
import liquibase.RuntimeEnvironment;
import liquibase.Scope;
import liquibase.changelog.AbstractChangeLogHistoryService;
import liquibase.changelog.ChangeLogHistoryServiceFactory;
import liquibase.changelog.ChangeLogParameters;
import liquibase.changelog.ChangeSet;
import liquibase.changelog.DatabaseChangeLog;
import liquibase.changelog.RanChangeSet;
import liquibase.changelog.filter.ChangeSetFilter;
import liquibase.changelog.visitor.ChangeExecListener;
import liquibase.changelog.visitor.ChangeSetVisitor;
import liquibase.command.CommandArgumentDefinition;
import liquibase.command.CommandBuilder;
import liquibase.command.CommandDefinition;
import liquibase.command.CommandResultsBuilder;
import liquibase.database.Database;
import liquibase.exception.LiquibaseException;
import liquibase.exception.RollbackImpossibleException;
import liquibase.license.LicenseServiceUtils;
import liquibase.lockservice.LockService;
import liquibase.lockservice.LockServiceFactory;
import liquibase.logging.Logger;
import liquibase.logging.mdc.CustomMdcObject;
import liquibase.logging.mdc.customobjects.ChangesetsRolledback;

public class RollbackOneUpdateCommandStep
extends AbstractRollbackOneCommand {
    public static final String[] COMMAND_NAME = new String[]{"rollbackOneUpdate"};
    private static final ResourceBundle coreBundle = ResourceBundle.getBundle("liquibase/i18n/liquibase-core");
    public static final CommandArgumentDefinition<String> DEPLOYMENT_ID_ARG;
    public static CommandArgumentDefinition<Boolean> FORCE_ARG;
    public static final CommandArgumentDefinition<String> ROLLBACK_SCRIPT_ARG;

    public String[][] defineCommandNames() {
        return new String[][]{COMMAND_NAME};
    }

    public void adjustCommandDefinition(CommandDefinition commandDefinition) {
        commandDefinition.setShortDescription(ProStringUtil.markWithPro("Rollback one update from the database"));
    }

    public List<Class<?>> requiredDependencies() {
        return Arrays.asList(Database.class, LockService.class, DatabaseChangeLog.class, ChangeExecListener.class, ChangeLogParameters.class);
    }

    public void run(CommandResultsBuilder commandResultsBuilder) {
        LicenseServiceUtils.checkProLicenseAndThrowException((String[])COMMAND_NAME);
        Object object = commandResultsBuilder.getCommandScope();
        Object object2 = (Boolean)object.getArgumentValue(FORCE_ARG);
        Serializable serializable = (String)object.getArgumentValue(ROLLBACK_SCRIPT_ARG);
        Object object3 = (ChangeLogParameters)object.getDependency(ChangeLogParameters.class);
        DatabaseChangeLog databaseChangeLog = (DatabaseChangeLog)object.getDependency(DatabaseChangeLog.class);
        Database database = (Database)object.getDependency(Database.class);
        Contexts contexts = object3.getContexts();
        object3 = object3.getLabels();
        ChangeExecListener changeExecListener = (ChangeExecListener)object.getDependency(ChangeExecListener.class);
        LockServiceFactory.getInstance().getLockService(database);
        object = (String)object.getArgumentValue(DEPLOYMENT_ID_ARG);
        if (object2 == null || !((Boolean)object2).booleanValue()) {
            object2 = "\nWARNING: Targeted rollback of this update may result in unexpected outcomes.  To review the rollback\nSQL before executing it, please run 'rollback-one-update-sql'. This message can be suppressed by adding the --force flag.";
            throw new LiquibaseException(String.format((String)object2, new Object[0]), Level.WARNING);
        }
        Scope.getCurrentScope().addMdcValue("rollbackScript", (String)((Object)serializable));
        Scope.getCurrentScope().addMdcValue("liquibaseTargetUrl", database.getConnection().getURL());
        Scope.getCurrentScope().addMdcValue("rollbackOneUpdateForce", String.valueOf(object2));
        object2 = database.getRanChangeSetList();
        if (object == null) {
            object = this.findLatestDeploymentId(database);
            Scope.getCurrentScope().getUI().sendMessage("Defaulting to last deployment ID '" + (String)object + "'");
        } else {
            this.validateDeploymentId((String)object, (List<RanChangeSet>)object2);
        }
        Scope.getCurrentScope().addMdcValue("deploymentId", (String)object);
        try {
            databaseChangeLog.validate(database, contexts, (LabelExpression)object3);
            serializable = new DeploymentIdFilter((String)object, database, (List<RanChangeSet>)object2, databaseChangeLog, COMMAND_NAME[0]);
            this.validateDeploymentIdFilter((String)object, (DeploymentIdFilter)((Object)serializable));
            object2 = this.createChangeLogIterator((List<RanChangeSet>)object2, (ChangeSetFilter)serializable, databaseChangeLog, contexts, (LabelExpression)object3, database);
            serializable = new ArrayList<ChangesetsRolledback.ChangeSet>();
            object2.run((ChangeSetVisitor)this.createRollbackVisitor((List<ChangesetsRolledback.ChangeSet>)((Object)serializable), database, changeExecListener), new RuntimeEnvironment(database, contexts, (LabelExpression)object3));
            Scope.getCurrentScope().addMdcValue("changesetsRolledback", (CustomMdcObject)new ChangesetsRolledback(serializable), false);
            object2 = Scope.getCurrentScope().getMdcManager().put("deploymentOutcome", "success");
            serializable = null;
            try {
                Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass()).info("Rollback command completed successfully.");
            }
            catch (Throwable throwable) {
                object3 = throwable;
                serializable = throwable;
                throw object3;
            }
            finally {
                if (object2 != null) {
                    if (serializable != null) {
                        try {
                            object2.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)serializable).addSuppressed(throwable);
                        }
                    } else {
                        object2.close();
                    }
                }
            }
            commandResultsBuilder.addResult("statusCode", (Object)0);
        }
        catch (LiquibaseException liquibaseException) {
            commandResultsBuilder.addResult("statusCode", (Object)1);
            this.handleRollbackError((Exception)((Object)liquibaseException), (String)object, changeExecListener, databaseChangeLog, database);
        }
        Scope.getCurrentScope().getUI().sendMessage("rollback-one-update executed for " + database.getConnection().getConnectionUserName() + "@" + database.getConnection().getURL());
    }

    public String findLatestDeploymentId(Database object) {
        object = ((AbstractChangeLogHistoryService)ChangeLogHistoryServiceFactory.getInstance().getChangeLogService(object)).getLastDeploymentId();
        if (object == null) {
            throw new LiquibaseException(String.format(coreBundle.getString("no.deployment.ids.found"), new Object[0]));
        }
        return object;
    }

    private void validateDeploymentId(String string, List<RanChangeSet> object) {
        boolean bl2 = false;
        object = object.iterator();
        while (object.hasNext()) {
            RanChangeSet ranChangeSet = (RanChangeSet)object.next();
            if (!string.equals(ranChangeSet.getDeploymentId())) continue;
            bl2 = true;
            break;
        }
        if (!bl2) {
            object = String.format(coreBundle.getString("no.change.sets.found.for.deployment.id"), string);
            throw new LiquibaseException("\n".concat(String.valueOf(object)));
        }
    }

    private void validateDeploymentIdFilter(String string, DeploymentIdFilter object) {
        if (!((DeploymentIdFilter)((Object)object)).getNoInverseChangeSets().isEmpty()) {
            string = "\n\nThere are changesets associated with the deployment ID '" + string + "' which cannot be rolled back.\nNo rollback was performed.\n";
            string = string + "\nChangesets which cannot be rolled back:\n";
            for (Map.Entry<String, ChangeSet> entry : ((DeploymentIdFilter)((Object)object)).getNoInverseChangeSets().entrySet()) {
                string = string + entry.getKey();
                string = string + "\n";
            }
            throw new LiquibaseException("\n".concat(String.valueOf(string)));
        }
        if (((DeploymentIdFilter)((Object)object)).isEmpty()) {
            string = "\n\nThere are no changesets associated with the deployment ID '" + string + "'.\nPlease check your parameters.  No rollback was performed.\n";
            throw new LiquibaseException("\n".concat(String.valueOf(string)));
        }
    }

    private void handleRollbackError(Exception exception, String string, ChangeExecListener changeExecListener, DatabaseChangeLog databaseChangeLog, Database database) {
        Logger logger = Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass());
        Throwable throwable = exception.getCause();
        Throwable throwable2 = null;
        try (Object object = Scope.getCurrentScope().addMdcValue("deploymentOutcome", "fail");){
            Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass()).info("Rollback command encountered an exception.");
        }
        catch (Throwable throwable3) {
            Throwable throwable4 = throwable3;
            throwable2 = throwable3;
            throw throwable4;
        }
        if (throwable instanceof RollbackImpossibleException) {
            object = "\nError executing rollback:\nThe rollback for deployment ID '" + string + "' has at least one changeset without a rollback defined\nPlease add a rollback change in the appropriate changeset.\n";
            logger.severe((String)object, (Throwable)exception);
            if (changeExecListener != null) {
                changeExecListener.runFailed(null, databaseChangeLog, database, exception);
            }
            throw new LiquibaseException((String)object, (Throwable)exception);
        }
        logger.severe("\nError executing rollback for the deployment ID '" + string + "'.");
        throw new LiquibaseException("\nError executing rollback for the deployment ID '" + string + "':\n" + exception.getMessage(), (Throwable)exception);
    }

    static {
        CommandBuilder commandBuilder = new CommandBuilder((String[][])new String[][]{COMMAND_NAME});
        DEPLOYMENT_ID_ARG = commandBuilder.argument("deploymentId", String.class).description("The deployment ID of the update to rollback").build();
        FORCE_ARG = commandBuilder.argument("force", Boolean.class).description("A required safety flag to indicate you intend to use this feature").defaultValue((Object)Boolean.FALSE).build();
        ROLLBACK_SCRIPT_ARG = commandBuilder.argument("rollbackScript", String.class).description("The path to the script to use to perform the rollback").build();
    }
}

