/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.command;

import com.datical.liquibase.ext.config.ExtendedLiquibaseCommandLineConfiguration;
import com.datical.liquibase.ext.flow.action.LiquibaseCommandAction;
import com.datical.liquibase.ext.logging.custommdc.CustomLogDataFile;
import com.datical.liquibase.ext.logging.structured.StructuredLogFormatter;
import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import liquibase.Scope;
import liquibase.command.CommandArgumentDefinition;
import liquibase.command.CommandBuilder;
import liquibase.command.CommandDefinition;
import liquibase.command.CommandResultsBuilder;
import liquibase.command.CommandScope;
import liquibase.command.CommandStep;
import liquibase.configuration.ConfiguredValue;
import liquibase.exception.CommandExecutionException;
import liquibase.exception.CommandValidationException;
import liquibase.integration.commandline.LiquibaseCommandLineConfiguration;
import liquibase.license.LicenseServiceUtils;
import liquibase.resource.Resource;
import liquibase.util.StringUtil;

public class UserMetadataMdcCommandStep
implements CommandStep {
    public static String[] COMMAND_NAME = new String[]{"userMetadataMdc"};
    private Resource customLogDataResource;
    public static final CommandArgumentDefinition<Boolean> RUN_ONCE;
    private static final AtomicInteger EXECUTION_COUNT;

    public String[][] defineCommandNames() {
        return new String[][]{COMMAND_NAME};
    }

    public int getOrder(CommandDefinition commandDefinition) {
        if (this.shouldRun(null)) {
            return 1;
        }
        return -1;
    }

    private boolean shouldRun(CommandScope commandScope) {
        ConfiguredValue configuredValue = ExtendedLiquibaseCommandLineConfiguration.CUSTOM_LOG_DATA_FILE.getCurrentConfiguredValue();
        boolean bl2 = false;
        if (commandScope != null && ((Boolean)commandScope.getArgumentValue(RUN_ONCE)).booleanValue()) {
            boolean bl3 = bl2 = EXECUTION_COUNT.get() > 0;
        }
        return !bl2 && configuredValue.found() && LicenseServiceUtils.isProLicenseValid();
    }

    public void adjustCommandDefinition(CommandDefinition commandDefinition) {
        commandDefinition.setHidden(true);
    }

    public void validate(CommandScope commandScope) {
        if (this.shouldRun(commandScope)) {
            try {
                this.customLogDataResource = CustomLogDataFile.getResource();
                return;
            }
            catch (CommandValidationException commandValidationException) {
                throw commandValidationException;
            }
            catch (Exception exception) {
                throw new CommandValidationException((Throwable)exception);
            }
        }
    }

    private boolean commandNameMatches(String string, CommandDefinition object) {
        String string2 = this.getCommandName((CommandDefinition)object, " ");
        String string3 = this.getCommandName((CommandDefinition)object, "-");
        object = this.getCommandName((CommandDefinition)object, "");
        string = string.toLowerCase().replace("liquibase.command.", "");
        try {
            string = LiquibaseCommandAction.getActualCommandName(string)[0];
        }
        catch (Exception exception) {}
        return string.equalsIgnoreCase(string2) || string.equalsIgnoreCase(string3) || string.equalsIgnoreCase((String)object);
    }

    private String getCommandName(CommandDefinition commandDefinition, String string) {
        return StringUtil.join((String[])commandDefinition.getName(), (String)string);
    }

    public void run(CommandResultsBuilder commandResultsBuilder) {
        if (this.shouldRun(commandResultsBuilder.getCommandScope())) {
            EXECUTION_COUNT.getAndIncrement();
            if (!this.customLogDataResource.exists()) {
                return;
            }
            Map<String, Object> map = CustomLogDataFile.getFileContents();
            if (map == null) {
                return;
            }
            try {
                this.logMdcData(commandResultsBuilder, map);
                return;
            }
            catch (Exception exception) {
                map = String.format("ERROR: Invalid or malformed YAML file detected in%n '%s' specified in custom-log-data-file property.%nLearn more about customizing structured logging output at https://docs.liquibase.com/structured-logging", CustomLogDataFile.getResource().getUri().toString().replace("file://", ""));
                Scope.getCurrentScope().getLog(UserMetadataMdcCommandStep.class).severe((String)((Object)map));
                throw new CommandExecutionException((String)((Object)map), (Throwable)exception);
            }
        }
    }

    private void logMdcData(CommandResultsBuilder commandResultsBuilder, Map<String, Object> object) {
        for (Map.Entry entry : object.entrySet()) {
            String string = (String)entry.getKey();
            List list = (List)entry.getValue();
            if (!(string.equalsIgnoreCase("liquibase.usermetadata") || this.commandNameMatches(string, commandResultsBuilder.getCommandScope().getCommand()))) continue;
            for (LinkedHashMap linkedHashMap : list) {
                Serializable serializable = this.getOutputToLogLevel(linkedHashMap);
                if (serializable == null) {
                    return;
                }
                Object object2 = StructuredLogFormatter.findKeyInMapIgnoreCase("data", linkedHashMap);
                if ((linkedHashMap = linkedHashMap.get(object2)) instanceof Map) {
                    linkedHashMap = Scope.getCurrentScope().addMdcValue("userMetadata", (Map)linkedHashMap);
                    object2 = null;
                    try {
                        Scope.getCurrentScope().getLog(this.getClass()).log(serializable, string + " MDC: " + this.customLogDataResource.getPath(), null);
                        continue;
                    }
                    catch (Throwable throwable) {
                        serializable = throwable;
                        object2 = throwable;
                        throw serializable;
                    }
                    finally {
                        if (linkedHashMap == null) continue;
                        if (object2 != null) {
                            try {
                                linkedHashMap.close();
                            }
                            catch (Throwable throwable) {
                                ((Throwable)object2).addSuppressed(throwable);
                            }
                            continue;
                        }
                        linkedHashMap.close();
                        continue;
                    }
                }
                Scope.getCurrentScope().getLog(this.getClass()).warning("The supplied 'data' for '" + string + "' is not valid.");
            }
        }
    }

    private Level getOutputToLogLevel(LinkedHashMap<String, Object> object) {
        String string = StructuredLogFormatter.findKeyInMapIgnoreCase("outputToLogLevel", object);
        object = ((LinkedHashMap)object).get(string);
        string = String.valueOf(object);
        if (object == null || StringUtil.isEmpty((String)string)) {
            return (Level)LiquibaseCommandLineConfiguration.LOG_LEVEL.getCurrentValue();
        }
        try {
            return Level.parse(string.toUpperCase());
        }
        catch (Exception exception) {
            object = "WARN: The specified outputTologlevel \"" + string + "\" was not found. No userMetadata injected into logs.";
            Scope.getCurrentScope().getUI().sendErrorMessage((String)object);
            return null;
        }
    }

    public List<Class<?>> requiredDependencies() {
        return null;
    }

    public List<Class<?>> providedDependencies() {
        return null;
    }

    static {
        EXECUTION_COUNT = new AtomicInteger(0);
        RUN_ONCE = new CommandBuilder((String[][])new String[][]{COMMAND_NAME}).argument("runOnce", Boolean.class).defaultValue((Object)Boolean.TRUE).hidden().description("If true, the user metadata will only be inserted one time. This is the default behavior. There are some commands, like rollback-one-update which trigger multiple executions of this command step. To output user metadata (potentially) multiple times, set this to false.").build();
    }
}

