/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.command.checks;

import com.datical.liquibase.ext.checks.config.DynamicRuleParameterEnum;
import com.datical.liquibase.ext.checks.config.model.DynamicRuleParameter;
import com.datical.liquibase.ext.command.checks.ChecksRunConsoleOutputHelper$CompiledResult;
import com.datical.liquibase.ext.command.checks.ChecksRunConsoleOutputHelper$DatabaseObjectSortComparator;
import com.datical.liquibase.ext.command.checks.ChecksRunConsoleOutputHelper$DatabaseObjectTypeSortComparator;
import com.datical.liquibase.ext.command.checks.EngineResults;
import com.datical.liquibase.ext.command.checks.LazyDatabaseSnapshot;
import com.datical.liquibase.ext.rules.api.SeverityEnum;
import com.datical.liquibase.ext.rules.core.AbstractLiquibaseRule;
import com.datical.liquibase.ext.rules.core.LiquibaseQualityCheckResult;
import com.datical.liquibase.ext.rules.core.LiquibaseRuleResult;
import com.datical.liquibase.ext.rules.core.RuleCombination;
import com.datical.liquibase.ext.rules.core.RuleIteration;
import com.datical.liquibase.ext.util.DatabaseObjectUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import liquibase.Scope;
import liquibase.changelog.ChangeSet;
import liquibase.command.CommandResultsBuilder;
import liquibase.exception.CommandExecutionException;
import liquibase.exception.UnexpectedLiquibaseException;
import liquibase.license.LicenseService;
import liquibase.license.LicenseServiceFactory;
import liquibase.license.LicenseServiceUtils;
import liquibase.plugin.Plugin;
import liquibase.structure.DatabaseObject;
import liquibase.util.StringUtil;

public class ChecksRunConsoleOutputHelper {
    private ChecksRunConsoleOutputHelper() {
    }

    public static SeverityEnum outputChecksResults(CommandResultsBuilder commandResultsBuilder, EngineResults<ChangeSet> engineResults, EngineResults<DatabaseObject> engineResults2, LazyDatabaseSnapshot lazyDatabaseSnapshot, String string, boolean bl2, List<AbstractLiquibaseRule> list, boolean bl3) {
        AtomicReference<SeverityEnum> atomicReference = new AtomicReference<SeverityEnum>(SeverityEnum.INFO);
        if (ChecksRunConsoleOutputHelper.noRulesToReport(engineResults, engineResults2)) {
            return atomicReference.get();
        }
        LicenseService licenseService = ((LicenseServiceFactory)Scope.getCurrentScope().getSingleton(LicenseServiceFactory.class)).getLicenseService();
        int n2 = licenseService.daysTilExpiration();
        if (engineResults != null) {
            ChecksRunConsoleOutputHelper.outputChangelogChecksResultsSummary(engineResults.getResults(), commandResultsBuilder, atomicReference);
        }
        if (engineResults2 != null) {
            ChecksRunConsoleOutputHelper.outputDatabaseChecksResultsSummary(engineResults2.getResults(), commandResultsBuilder, atomicReference);
        }
        if (LicenseServiceUtils.isProLicenseValid() && engineResults != null) {
            ChecksRunConsoleOutputHelper.outputChangesetsValidatedList(engineResults.getResults(), commandResultsBuilder);
        }
        if (bl3) {
            ChecksRunConsoleOutputHelper.outputDatabaseObjectsValidatedList(lazyDatabaseSnapshot, bl2, commandResultsBuilder);
        }
        if (engineResults != null) {
            ChecksRunConsoleOutputHelper.printListOfChecksWithInlineShortNames(new ArrayList<RuleCombination>(engineResults.getExecutedRules()), commandResultsBuilder, "Checks run against each changeset:", list);
        }
        if (engineResults2 != null) {
            ChecksRunConsoleOutputHelper.printListOfChecksWithInlineShortNames(new ArrayList<RuleCombination>(engineResults2.getExecutedRules()), commandResultsBuilder, String.format("Checks run against database %s:", string), list);
        }
        if (engineResults != null && !engineResults.getResults().isEmpty()) {
            ChecksRunConsoleOutputHelper.printChangeSetsWithSkippedChecks(commandResultsBuilder, engineResults.getResults());
        }
        if (engineResults != null) {
            ChecksRunConsoleOutputHelper.printListOfChecksWithInlineShortNames(engineResults.getSkippedBecauseOfLicenceRules(), commandResultsBuilder, "Changelog Checks Skipped, No Pro License Found:", list);
        }
        if (engineResults2 != null) {
            ChecksRunConsoleOutputHelper.printListOfChecksWithInlineShortNames(engineResults2.getSkippedBecauseOfLicenceRules(), commandResultsBuilder, "Database Checks Skipped Due to Missing License:", list);
        }
        if (engineResults != null) {
            ChecksRunConsoleOutputHelper.printChangeSetsWithInvalidChangesetTypeFailures(commandResultsBuilder, engineResults.getResults(), bl2);
        }
        if (n2 < 0) {
            ChecksRunConsoleOutputHelper.sendMessageToUi(licenseService.getLicenseInfo());
        }
        return atomicReference.get();
    }

    private static boolean noRulesToReport(EngineResults<ChangeSet> engineResults, EngineResults<DatabaseObject> engineResults2) {
        if (engineResults != null && !engineResults.getResults().isEmpty()) {
            return false;
        }
        if (engineResults2 != null && !engineResults2.getResults().isEmpty()) {
            return false;
        }
        if (engineResults != null && !engineResults.getSkippedBecauseOfLicenceRules().isEmpty()) {
            return false;
        }
        return engineResults2 == null || engineResults2.getSkippedBecauseOfLicenceRules().isEmpty();
    }

    private static void printListOfChecksWithInlineShortNames(List<RuleCombination> iterator, CommandResultsBuilder commandResultsBuilder, String charSequence, List<AbstractLiquibaseRule> object2) {
        if (!iterator.isEmpty()) {
            iterator = iterator.stream().collect(Collectors.groupingBy(ruleCombination -> ruleCombination.rule.getName(), TreeMap::new, Collectors.mapping(arg_0 -> ChecksRunConsoleOutputHelper.lambda$printListOfChecksWithInlineShortNames$1((List)object2, arg_0), Collectors.toList())));
            charSequence = new StringBuilder((String)charSequence);
            ((StringBuilder)charSequence).append(System.lineSeparator());
            for (Map.Entry entry : iterator.entrySet()) {
                ((StringBuilder)charSequence).append("  ");
                ((StringBuilder)charSequence).append((String)entry.getKey());
                ((StringBuilder)charSequence).append(" (Short names: ");
                ((StringBuilder)charSequence).append(StringUtil.join((Collection)((Collection)entry.getValue()), (String)", "));
                ((StringBuilder)charSequence).append(")");
                ((StringBuilder)charSequence).append(System.lineSeparator());
            }
            ChecksRunConsoleOutputHelper.sendMessage(commandResultsBuilder, charSequence + System.lineSeparator());
        }
    }

    private static void outputChangesetsValidatedList(LinkedHashMap<ChangeSet, LiquibaseQualityCheckResult> object, CommandResultsBuilder commandResultsBuilder) {
        if (object != null && !((HashMap)((Object)object)).isEmpty()) {
            for (Map.Entry entry2 : ((LinkedHashMap)((Object)object)).entrySet().stream().collect(Collectors.groupingBy(entry -> ((ChangeSet)entry.getKey()).getFilePath(), Collectors.mapping(Map.Entry::getKey, Collectors.toList()))).entrySet()) {
                CharSequence charSequence = entry2.getKey();
                charSequence = new StringBuilder("Changesets Validated: in " + (String)charSequence + System.lineSeparator());
                for (ChangeSet changeSet : entry2.getValue()) {
                    ((StringBuilder)charSequence).append("  ID: ");
                    ((StringBuilder)charSequence).append(changeSet.getId());
                    ((StringBuilder)charSequence).append("; Author: ");
                    ((StringBuilder)charSequence).append(changeSet.getAuthor());
                    ((StringBuilder)charSequence).append(System.lineSeparator());
                }
                ChecksRunConsoleOutputHelper.sendMessage(commandResultsBuilder, charSequence + System.lineSeparator());
            }
        }
    }

    private static void printChangeSetsWithSkippedChecks(CommandResultsBuilder commandResultsBuilder, LinkedHashMap<ChangeSet, LiquibaseQualityCheckResult> object) {
        if (object != null && !((HashMap)((Object)object)).isEmpty()) {
            for (Map.Entry<String, List<Map.Entry>> entry2 : ((LinkedHashMap)((Object)object)).entrySet().stream().filter(entry -> !((LiquibaseQualityCheckResult)entry.getValue()).getSkippedBecauseOfExceptionRuleNames().isEmpty()).collect(Collectors.groupingBy(entry -> ((ChangeSet)entry.getKey()).getFilePath())).entrySet()) {
                CharSequence charSequence = entry2.getKey();
                charSequence = new StringBuilder("Changeset SQL not parsed in " + (String)charSequence + " (please review them directly):" + System.lineSeparator());
                for (Object object2 : entry2.getValue()) {
                    String string = ((ChangeSet)object2.getKey()).getId();
                    String string2 = ((ChangeSet)object2.getKey()).getAuthor();
                    object2 = ((LiquibaseQualityCheckResult)object2.getValue()).getSkippedBecauseOfExceptionRuleNames();
                    ((StringBuilder)charSequence).append("  ID: ");
                    ((StringBuilder)charSequence).append(string);
                    ((StringBuilder)charSequence).append("; Author: ");
                    ((StringBuilder)charSequence).append(string2);
                    ((StringBuilder)charSequence).append(" - Skipped by: ");
                    ((StringBuilder)charSequence).append(StringUtil.join((Collection)object2, (String)", "));
                    ((StringBuilder)charSequence).append(System.lineSeparator());
                }
                ChecksRunConsoleOutputHelper.sendMessage(commandResultsBuilder, charSequence + System.lineSeparator());
            }
        }
    }

    private static void printChangeSetsWithInvalidChangesetTypeFailures(CommandResultsBuilder commandResultsBuilder, LinkedHashMap<ChangeSet, LiquibaseQualityCheckResult> object2, boolean bl2) {
        if (object2 != null && !((HashMap)((Object)object2)).isEmpty()) {
            TreeMap<String, ChecksRunConsoleOutputHelper$CompiledResult> treeMap = new TreeMap<String, ChecksRunConsoleOutputHelper$CompiledResult>();
            for (Map.Entry entry : ((LinkedHashMap)((Object)object2)).entrySet()) {
                ChangeSet changeSet = (ChangeSet)entry.getKey();
                for (LiquibaseRuleResult liquibaseRuleResult : ((LiquibaseQualityCheckResult)entry.getValue()).getInvalidChangesetFileTypeFailures()) {
                    Object object3;
                    if (!liquibaseRuleResult.hasInvalidChangelogFileTypeFailures()) continue;
                    String string = liquibaseRuleResult.getRule().getName();
                    String string2 = liquibaseRuleResult.getRuleShortName(false);
                    if (treeMap.containsKey(string)) {
                        object3 = (ChecksRunConsoleOutputHelper$CompiledResult)treeMap.get(string);
                        ((ChecksRunConsoleOutputHelper$CompiledResult)object3).changeSets.add(changeSet);
                        ((ChecksRunConsoleOutputHelper$CompiledResult)object3).shortnames.add(string2);
                        continue;
                    }
                    object3 = new LinkedHashSet<String>();
                    ((HashSet)object3).add(string2);
                    LinkedHashSet<ChangeSet> linkedHashSet = new LinkedHashSet<ChangeSet>();
                    linkedHashSet.add(changeSet);
                    treeMap.put(string, new ChecksRunConsoleOutputHelper$CompiledResult((Set<String>)object3, linkedHashSet));
                }
            }
            if (treeMap.isEmpty()) {
                return;
            }
            int n2 = bl2 ? Integer.MAX_VALUE : 3;
            StringBuilder stringBuilder = new StringBuilder("Changelogs Checks Skipped Due to unsupported changeset type for this check:" + System.lineSeparator());
            for (Map.Entry entry : treeMap.entrySet()) {
                stringBuilder.append("  ");
                stringBuilder.append((String)entry.getKey());
                stringBuilder.append(" (Short names: ");
                ChecksRunConsoleOutputHelper$CompiledResult checksRunConsoleOutputHelper$CompiledResult = (ChecksRunConsoleOutputHelper$CompiledResult)entry.getValue();
                stringBuilder.append(StringUtil.join(checksRunConsoleOutputHelper$CompiledResult.shortnames, (String)", "));
                stringBuilder.append(") skipped for:");
                stringBuilder.append(System.lineSeparator());
                stringBuilder.append(StringUtil.join((Collection)checksRunConsoleOutputHelper$CompiledResult.changeSets.stream().limit(n2).collect(Collectors.toList()), (String)("," + System.lineSeparator()), object -> {
                    object = (ChangeSet)object;
                    return "    " + object.getId() + ":" + object.getAuthor();
                }));
                stringBuilder.append(System.lineSeparator());
                if (checksRunConsoleOutputHelper$CompiledResult.changeSets.size() <= n2) continue;
                int n3 = checksRunConsoleOutputHelper$CompiledResult.changeSets.size() - n2;
                boolean bl3 = n3 > 1;
                stringBuilder.append("    (See ").append(n3).append(" more changeset").append(bl3 ? "s" : "").append(" by setting command argument --verbose)");
                stringBuilder.append(System.lineSeparator());
            }
            ChecksRunConsoleOutputHelper.sendMessage(commandResultsBuilder, stringBuilder + System.lineSeparator());
        }
    }

    private static void outputDatabaseObjectsValidatedList(LazyDatabaseSnapshot lazyDatabaseSnapshot, boolean bl2, CommandResultsBuilder commandResultsBuilder) {
        if (lazyDatabaseSnapshot == null) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder("Database objects Validated:");
        stringBuilder.append(System.lineSeparator());
        try {
            Object object = lazyDatabaseSnapshot.getSnapshot().getSnapshotControl().getTypesToInclude();
            object = new ArrayList(object);
            Collections.sort(object, new ChecksRunConsoleOutputHelper$DatabaseObjectTypeSortComparator());
            object = object.iterator();
            while (object.hasNext()) {
                Object object2 = (Class)object.next();
                Object object3 = lazyDatabaseSnapshot.getSnapshot().get((Class)object2);
                if (object3.isEmpty()) continue;
                object2 = ((Class)object2).getSimpleName();
                object2 = String.format("     %-20s: %d%n", StringUtil.upperCaseFirst((String)object2), object3.size());
                stringBuilder.append((String)object2);
                if (!bl2) continue;
                object2 = lazyDatabaseSnapshot.getDatabase();
                object3 = new ArrayList(object3);
                Collections.sort(object3, new ChecksRunConsoleOutputHelper$DatabaseObjectSortComparator());
                object3 = object3.iterator();
                while (object3.hasNext()) {
                    DatabaseObject databaseObject = (DatabaseObject)object3.next();
                    if (object2.isLiquibaseObject(databaseObject)) continue;
                    stringBuilder.append(String.format("                    %s%n", DatabaseObjectUtils.buildFullyQualifiedName(databaseObject)));
                }
            }
            if (bl2) {
                stringBuilder.append("To reduce details unset the --verbose property").append(System.lineSeparator());
            } else {
                stringBuilder.append("To increase details set the --verbose property").append(System.lineSeparator());
            }
        }
        catch (CommandExecutionException commandExecutionException) {
            throw new UnexpectedLiquibaseException((Throwable)commandExecutionException);
        }
        ChecksRunConsoleOutputHelper.sendMessage(commandResultsBuilder, stringBuilder + System.lineSeparator());
    }

    private static void outputDatabaseChecksResultsSummary(LinkedHashMap<DatabaseObject, LiquibaseQualityCheckResult> object, CommandResultsBuilder commandResultsBuilder, AtomicReference<SeverityEnum> atomicReference) {
        if (object != null) {
            StringBuilder stringBuilder = new StringBuilder();
            boolean bl2 = false;
            for (Map.Entry entry : ((LinkedHashMap)((Object)object)).entrySet()) {
                DatabaseObject databaseObject = (DatabaseObject)entry.getKey();
                for (LiquibaseRuleResult liquibaseRuleResult : ((LiquibaseQualityCheckResult)entry.getValue()).getRuleResults()) {
                    if (liquibaseRuleResult.hasRuleSucceeded()) continue;
                    if (!bl2) {
                        stringBuilder.append(System.lineSeparator()).append("DATABASE CHECKS").append(System.lineSeparator()).append("---------------").append(System.lineSeparator()).append("Validation of the database snapshot found the following issues:").append(System.lineSeparator()).append(System.lineSeparator());
                        bl2 = true;
                    }
                    for (RuleIteration ruleIteration : liquibaseRuleResult.getExecutions()) {
                        if (ruleIteration.isSuccess()) continue;
                        SeverityEnum severityEnum = liquibaseRuleResult.getRuleSeverity();
                        if (severityEnum.getValue() > atomicReference.get().getValue()) {
                            atomicReference.set(severityEnum);
                        }
                        String string = ruleIteration.buildDisplayMessage();
                        String string2 = liquibaseRuleResult.getRule().getName() + liquibaseRuleResult.getRuleShortName() + System.lineSeparator();
                        String string3 = "Check Name:         " + string2 + "Object Type:        " + databaseObject.getObjectTypeName() + (ChecksRunConsoleOutputHelper.isDatabaseObjectPro(databaseObject) ? " (Pro)" : "") + System.lineSeparator() + "Object Name:        " + databaseObject.getName() + System.lineSeparator() + "Object Location:    " + DatabaseObjectUtils.buildFullyQualifiedName(databaseObject) + System.lineSeparator() + ChecksRunConsoleOutputHelper.addConstraintIfAvailable(liquibaseRuleResult) + "Check Severity:     " + (Object)((Object)severityEnum) + " (Return code: " + severityEnum.getExitValue() + ")" + System.lineSeparator() + "Message:            " + string;
                        stringBuilder.append(string3).append(System.lineSeparator()).append(System.lineSeparator());
                    }
                }
            }
            ChecksRunConsoleOutputHelper.sendMessage(commandResultsBuilder, stringBuilder.toString());
        }
    }

    private static String addConstraintIfAvailable(LiquibaseRuleResult object) {
        if (((LiquibaseRuleResult)object).getDynamicRule() == null) {
            return "";
        }
        if ((object = ((LiquibaseRuleResult)object).getDynamicRule().getParameter(DynamicRuleParameterEnum.CONSTRAINT)) == null) {
            return "";
        }
        object = (String)((DynamicRuleParameter)object).getValue();
        return "Constraints:        " + (String)object + System.lineSeparator();
    }

    private static void outputChangelogChecksResultsSummary(LinkedHashMap<ChangeSet, LiquibaseQualityCheckResult> object, CommandResultsBuilder commandResultsBuilder, AtomicReference<SeverityEnum> atomicReference) {
        if (object != null && !((HashMap)((Object)object)).isEmpty()) {
            boolean bl2 = false;
            for (Map.Entry entry : ((LinkedHashMap)((Object)object)).entrySet()) {
                ChangeSet changeSet = (ChangeSet)entry.getKey();
                for (LiquibaseRuleResult liquibaseRuleResult : ((LiquibaseQualityCheckResult)entry.getValue()).getRuleResults()) {
                    if (liquibaseRuleResult.hasRuleSucceeded()) continue;
                    for (RuleIteration ruleIteration : liquibaseRuleResult.getExecutions()) {
                        SeverityEnum severityEnum;
                        if (ruleIteration.isSuccess() || ruleIteration.getMessages().isEmpty()) continue;
                        if (!bl2) {
                            ChecksRunConsoleOutputHelper.sendMessage(commandResultsBuilder, "CHANGELOG CHECKS" + System.lineSeparator() + "----------------" + System.lineSeparator() + "Checks completed validation of the changelog and found the following issues:" + System.lineSeparator() + System.lineSeparator());
                            bl2 = true;
                        }
                        if ((severityEnum = liquibaseRuleResult.getRuleSeverity()).getValue() > atomicReference.get().getValue()) {
                            atomicReference.set(severityEnum);
                        }
                        String string = ruleIteration.buildDisplayMessage();
                        String string2 = liquibaseRuleResult.getRule().getName() + liquibaseRuleResult.getRuleShortName() + System.lineSeparator();
                        String string3 = "Check Name:         " + string2 + "Changeset ID:       " + changeSet.getId() + (ruleIteration.isRollback() ? " - ROLLBACK CODE" : "") + System.lineSeparator() + "Changeset Filepath: " + changeSet.getFilePath() + System.lineSeparator() + "Check Severity:     " + (Object)((Object)severityEnum) + " (Return code: " + severityEnum.getExitValue() + ")" + System.lineSeparator() + "Message:            " + string;
                        ChecksRunConsoleOutputHelper.sendMessage(commandResultsBuilder, string3 + System.lineSeparator() + System.lineSeparator());
                    }
                }
            }
        }
    }

    private static boolean isDatabaseObjectPro(DatabaseObject databaseObject) {
        LicenseServiceFactory licenseServiceFactory = (LicenseServiceFactory)Scope.getCurrentScope().getSingleton(LicenseServiceFactory.class);
        LicenseService licenseService = licenseServiceFactory.getLicenseService();
        licenseServiceFactory.unregister(licenseService);
        boolean bl2 = !databaseObject.snapshotByDefault();
        licenseServiceFactory.register((Plugin)licenseService);
        return bl2;
    }

    private static void sendMessage(CommandResultsBuilder commandResultsBuilder, String string) {
        commandResultsBuilder.getOutputStream().write(string.getBytes());
    }

    private static void sendMessageToUi(String string) {
        Scope.getCurrentScope().getUI().sendMessage(string);
    }
}

