/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.command.helpers;

import java.util.Collections;
import java.util.List;
import liquibase.Scope;
import liquibase.command.AbstractCommandStep;
import liquibase.command.CommandArgumentDefinition;
import liquibase.command.CommandBuilder;
import liquibase.command.CommandDefinition;
import liquibase.command.CommandResultsBuilder;

public class RollbackOnErrorArgument
extends AbstractCommandStep {
    protected static final String[] COMMAND_NAME = new String[]{"rollbackOnError"};
    public static final CommandArgumentDefinition<Boolean> ROLLBACK_ON_ERROR_ARG = new CommandBuilder((String[][])new String[][]{COMMAND_NAME}).argument("rollbackOnError", Boolean.class).description("If set to true and any changeset in a deployment fails, then the update operation stops, and liquibase attempts to rollback all changesets just deployed. A changeset marked \"fail-on-error=false\" does not trigger as an error, therefore rollback-on-error will not occur. Additionally, if a changeset is not auto-rollback compliant or does not have a rollback script, then no rollback-on-error will occur for any changeset.").defaultValue((Object)Boolean.FALSE).build();
    private static final String ROLLBACK_ON_ERROR_ARG_NAME = "rollbackOnError";
    private static final String ROLLBACK_ON_ERROR_ARG_DESCRIPTION = "If set to true and any changeset in a deployment fails, then the update operation stops, and liquibase attempts to rollback all changesets just deployed. A changeset marked \"fail-on-error=false\" does not trigger as an error, therefore rollback-on-error will not occur. Additionally, if a changeset is not auto-rollback compliant or does not have a rollback script, then no rollback-on-error will occur for any changeset.";

    public String[][] defineCommandNames() {
        return new String[][]{COMMAND_NAME};
    }

    public List<Class<?>> providedDependencies() {
        return Collections.singletonList(RollbackOnErrorArgument.class);
    }

    public void run(CommandResultsBuilder commandResultsBuilder) {
        commandResultsBuilder = commandResultsBuilder.getCommandScope();
        boolean bl2 = (Boolean)commandResultsBuilder.getArgumentValue(ROLLBACK_ON_ERROR_ARG);
        Scope.getCurrentScope().addMdcValue(ROLLBACK_ON_ERROR_ARG_NAME, String.valueOf(bl2));
        commandResultsBuilder.provideDependency(RollbackOnErrorArgument.class, (Object)bl2);
    }

    public void adjustCommandDefinition(CommandDefinition commandDefinition) {
        if (commandDefinition.getPipeline().size() == 1) {
            commandDefinition.setInternal(true);
        }
    }
}

