/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.logging.custommdc;

import com.datical.liquibase.ext.config.ExtendedLiquibaseCommandLineConfiguration;
import com.datical.liquibase.ext.logging.custommdc.Cache;
import com.datical.liquibase.ext.logging.custommdc.CustomLogDataYaml;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Map;
import liquibase.Scope;
import liquibase.configuration.ConfiguredValue;
import liquibase.exception.CommandValidationException;
import liquibase.logging.core.NoOpLogService;
import liquibase.resource.PathHandlerFactory;
import liquibase.resource.Resource;

public class CustomLogDataFile {
    private static final Cache<Resource> resource = new Cache<Resource>(() -> {
        ConfiguredValue configuredValue = ExtendedLiquibaseCommandLineConfiguration.CUSTOM_LOG_DATA_FILE.getCurrentConfiguredValue();
        PathHandlerFactory pathHandlerFactory = (PathHandlerFactory)Scope.getCurrentScope().getSingleton(PathHandlerFactory.class);
        try {
            String string = (String)configuredValue.getValue();
            pathHandlerFactory = (Resource)Scope.child(Collections.singletonMap(Scope.Attr.logService.toString(), new NoOpLogService()), () -> pathHandlerFactory.getResource(string));
            if (!configuredValue.wasDefaultValueUsed() && !pathHandlerFactory.exists()) {
                throw new FileNotFoundException(string + " not found.");
            }
            return pathHandlerFactory;
        }
        catch (Exception exception) {
            throw new CommandValidationException((Throwable)exception);
        }
    });
    private static final Cache<Map<String, Object>> fileContents = new Cache<Map>(() -> {
        Object object = new CustomLogDataYaml();
        Throwable throwable = null;
        try (InputStream inputStream = resource.get().openInputStream();){
            object = (Map)object.load(inputStream);
        }
        catch (Throwable throwable2) {
            Throwable throwable3 = throwable2;
            throwable = throwable2;
            throw throwable3;
        }
        return object;
    });

    private CustomLogDataFile() {
    }

    public static Resource getResource() {
        return resource.get();
    }

    public static Map<String, Object> getFileContents() {
        return fileContents.get();
    }

    public static void clearCache() {
        resource.clearCache();
        fileContents.clearCache();
    }
}

