/*
 * Decompiled with CFR 0.152.
 */
package liquibase.pro.packaged;

import java.math.BigInteger;
import liquibase.pro.packaged.bS;
import liquibase.pro.packaged.bX;
import liquibase.pro.packaged.bY;

class bW {
    public static final double COS_0_25 = Math.cos(0.7853981633974483);
    public static final double SIN_0_25 = Math.sin(0.7853981633974483);
    private static final int FFT_THRESHOLD = 33220;
    private static final int MAX_MAG_LENGTH = 0x4000000;
    private static final int ROOTS3_CACHE_SIZE = 20;
    private static final int ROOTS_CACHE2_SIZE = 20;
    private static final int TOOM_COOK_THRESHOLD = 1920;
    private static volatile bX[] ROOTS2_CACHE = new bX[20];
    private static volatile bX[] ROOTS3_CACHE = new bX[20];

    bW() {
    }

    static int bitsPerFftPoint(int n2) {
        if (n2 <= 9728) {
            return 19;
        }
        if (n2 <= 18432) {
            return 18;
        }
        if (n2 <= 69632) {
            return 17;
        }
        if (n2 <= 262144) {
            return 16;
        }
        if (n2 <= 983040) {
            return 15;
        }
        if (n2 <= 0x380000) {
            return 14;
        }
        if (n2 <= 0xD00000) {
            return 13;
        }
        if (n2 <= 0x1800000) {
            return 12;
        }
        if (n2 <= 0x5800000) {
            return 11;
        }
        if (n2 <= 0x14000000) {
            return 10;
        }
        if (n2 <= 0x48000000) {
            return 9;
        }
        return 8;
    }

    private static bX calculateRootsOfUnity(int n2) {
        if (n2 == 1) {
            bX bX2 = new bX(1);
            bX2.real(0, 1.0);
            bX2.imag(0, 0.0);
            return bX2;
        }
        bX bX3 = new bX(n2);
        bX3.set(0, 1.0, 0.0);
        double d2 = COS_0_25;
        double d3 = SIN_0_25;
        bX3.set(n2 / 2, d2, d3);
        double d4 = 1.5707963267948966 / (double)n2;
        for (int i2 = 1; i2 < n2 / 2; ++i2) {
            double d5 = d4 * (double)i2;
            d2 = Math.cos(d5);
            d3 = Math.sin(d5);
            bX3.set(i2, d2, d3);
            bX3.set(n2 - i2, d3, d2);
        }
        return bX3;
    }

    private static void fft(bX bX2, bX[] bXArray) {
        int n2;
        int n3 = bX.access$000(bX2);
        bY bY2 = new bY();
        bY bY3 = new bY();
        bY bY4 = new bY();
        bY bY5 = new bY();
        bY bY6 = new bY();
        bY bY7 = new bY();
        for (n2 = 31 - Integer.numberOfLeadingZeros(n3); n2 >= 2; n2 -= 2) {
            bX bX3 = bXArray[n2 - 2];
            int n4 = 1 << n2;
            for (int i2 = 0; i2 < n3; i2 += n4) {
                for (int i3 = 0; i3 < n4 / 4; ++i3) {
                    bY6.set(bX3, i3);
                    bY6.squareInto(bY7);
                    int n5 = i2 + i3;
                    int n6 = i2 + i3 + n4 / 4;
                    int n7 = i2 + i3 + n4 / 2;
                    int n8 = i2 + i3 + n4 * 3 / 4;
                    bX2.addInto(n5, bX2, n6, bY2);
                    bY2.add(bX2, n7);
                    bY2.add(bX2, n8);
                    bX2.subtractTimesIInto(n5, bX2, n6, bY3);
                    bY3.subtract(bX2, n7);
                    bY3.addTimesI(bX2, n8);
                    bY3.multiplyConjugate(bY6);
                    bX2.subtractInto(n5, bX2, n6, bY4);
                    bY4.add(bX2, n7);
                    bY4.subtract(bX2, n8);
                    bY4.multiplyConjugate(bY7);
                    bX2.addTimesIInto(n5, bX2, n6, bY5);
                    bY5.subtract(bX2, n7);
                    bY5.subtractTimesI(bX2, n8);
                    bY5.multiply(bY6);
                    bY2.copyInto(bX2, n5);
                    bY3.copyInto(bX2, n6);
                    bY4.copyInto(bX2, n7);
                    bY5.copyInto(bX2, n8);
                }
            }
        }
        if (n2 > 0) {
            for (int i4 = 0; i4 < n3; i4 += 2) {
                bX2.copyInto(i4, bY2);
                bX2.copyInto(i4 + 1, bY3);
                bX2.add(i4, bY3);
                bY2.subtractInto(bY3, bX2, i4 + 1);
            }
        }
    }

    private static void fft3(bX bX2, bX bX3, bX bX4, int n2, double d2) {
        double d3 = (double)n2 * -0.5 * Math.sqrt(3.0);
        for (n2 = 0; n2 < bX.access$000(bX2); ++n2) {
            double d4 = bX2.real(n2) + bX3.real(n2) + bX4.real(n2);
            double d5 = bX2.imag(n2) + bX3.imag(n2) + bX4.imag(n2);
            double d6 = d3 * (bX4.imag(n2) - bX3.imag(n2));
            double d7 = d3 * (bX3.real(n2) - bX4.real(n2));
            double d8 = 0.5 * (bX3.real(n2) + bX4.real(n2));
            double d9 = 0.5 * (bX3.imag(n2) + bX4.imag(n2));
            double d10 = bX2.real(n2) - d8 + d6;
            double d11 = bX2.imag(n2) + d7 - d9;
            double d12 = bX2.real(n2) - d8 - d6;
            double d13 = bX2.imag(n2) - d7 - d9;
            bX2.real(n2, d4 * d2);
            bX2.imag(n2, d5 * d2);
            bX3.real(n2, d10 * d2);
            bX3.imag(n2, d11 * d2);
            bX4.real(n2, d12 * d2);
            bX4.imag(n2, d13 * d2);
        }
    }

    private static void fftMixedRadix(bX bX2, bX[] bXArray, bX bX3) {
        int n2;
        int n3 = bX.access$000(bX2) / 3;
        bX bX4 = new bX(bX2, 0, n3);
        int n4 = n3;
        bX bX5 = new bX(bX2, n4, n4 << 1);
        bX bX6 = new bX(bX2, n3 << 1, bX.access$000(bX2));
        bW.fft3(bX4, bX5, bX6, 1, 1.0);
        bY bY2 = new bY();
        for (n2 = 0; n2 < bX.access$000(bX2) / 4; ++n2) {
            bY2.set(bX3, n2);
            bX5.multiplyConjugate(n2, bY2);
            bX6.multiplyConjugate(n2, bY2);
            bX6.multiplyConjugate(n2, bY2);
        }
        for (n2 = bX.access$000(bX2) / 4; n2 < n3; ++n2) {
            bY2.set(bX3, n2 - bX.access$000(bX2) / 4);
            bX5.multiplyConjugateTimesI(n2, bY2);
            bX6.multiplyConjugateTimesI(n2, bY2);
            bX6.multiplyConjugateTimesI(n2, bY2);
        }
        bW.fft(bX4, bXArray);
        bW.fft(bX5, bXArray);
        bW.fft(bX6, bXArray);
    }

    static BigInteger fromFftVector(bX bX2, int n2, int n3) {
        assert (n3 <= 25) : n3 + " does not fit into an int with slack";
        int n4 = (int)Math.min((long)bX.access$000(bX2), 0x80000000L / (long)n3 + 1L);
        int n5 = (int)(8L * ((long)n4 * (long)n3 + 31L) / 32L);
        byte[] byArray = new byte[n5];
        int n6 = (1 << n3) - 1;
        int n7 = 32 - n3;
        long l2 = 0L;
        int n8 = (n5 << 3) - n3;
        int n9 = 0;
        int n10 = Math.min(Math.max(0, n8 >> 3), n5 - 4);
        for (int i2 = 0; i2 <= 1; ++i2) {
            for (int i3 = 0; i3 < n4; ++i3) {
                long l3 = Math.round(bX2.part(i3, i2)) + l2;
                l2 = l3 >> n3;
                int n11 = Math.min(Math.max(0, n8 >> 3), n5 - 4);
                n9 >>>= n10 - n11 << 3;
                n10 = n7 - n8 + (n11 << 3);
                n9 = (int)((long)n9 | (l3 & (long)n6) << n10);
                bS.writeIntBE(byArray, n11, n9);
                n10 = n11;
                n8 -= n3;
            }
        }
        return new BigInteger(n2, byArray);
    }

    private static bX[] getRootsOfUnity2(int n2) {
        bX[] bXArray = new bX[n2 + 1];
        while (n2 >= 0) {
            if (n2 < 20) {
                if (ROOTS2_CACHE[n2] == null) {
                    bW.ROOTS2_CACHE[n2] = bW.calculateRootsOfUnity(1 << n2);
                }
                bXArray[n2] = ROOTS2_CACHE[n2];
            } else {
                bXArray[n2] = bW.calculateRootsOfUnity(1 << n2);
            }
            n2 -= 2;
        }
        return bXArray;
    }

    private static bX getRootsOfUnity3(int n2) {
        if (n2 < 20) {
            if (ROOTS3_CACHE[n2] == null) {
                bW.ROOTS3_CACHE[n2] = bW.calculateRootsOfUnity(3 << n2);
            }
            return ROOTS3_CACHE[n2];
        }
        return bW.calculateRootsOfUnity(3 << n2);
    }

    private static void ifft(bX bX2, bX[] bXArray) {
        int n2 = bX.access$000(bX2);
        int n3 = 31 - Integer.numberOfLeadingZeros(n2);
        bY bY2 = new bY();
        bY bY3 = new bY();
        bY bY4 = new bY();
        bY bY5 = new bY();
        bY bY6 = new bY();
        bY bY7 = new bY();
        bY bY8 = new bY();
        bY bY9 = new bY();
        int n4 = 1;
        if (n3 % 2 != 0) {
            for (int i2 = 0; i2 < n2; i2 += 2) {
                bX2.copyInto(i2 + 1, bY4);
                bX2.copyInto(i2, bY2);
                bX2.add(i2, bY4);
                bY2.subtractInto(bY4, bX2, i2 + 1);
            }
            ++n4;
        }
        bY bY10 = new bY();
        bY bY11 = new bY();
        while (n4 <= n3) {
            bX bX3 = bXArray[n4 - 1];
            int n5 = 1 << n4 + 1;
            for (int i3 = 0; i3 < n2; i3 += n5) {
                for (int i4 = 0; i4 < n5 / 4; ++i4) {
                    bY10.set(bX3, i4);
                    bY10.squareInto(bY11);
                    int n6 = i3 + i4;
                    int n7 = i3 + i4 + n5 / 4;
                    int n8 = i3 + i4 + n5 / 2;
                    int n9 = i3 + i4 + n5 * 3 / 4;
                    bX2.copyInto(n6, bY2);
                    bX2.multiplyInto(n7, bY10, bY3);
                    bX2.multiplyInto(n8, bY11, bY4);
                    bX2.multiplyConjugateInto(n9, bY10, bY5);
                    bY2.addInto(bY3, bY6);
                    bY6.add(bY4);
                    bY6.add(bY5);
                    bY2.addTimesIInto(bY3, bY7);
                    bY7.subtract(bY4);
                    bY7.subtractTimesI(bY5);
                    bY2.subtractInto(bY3, bY8);
                    bY8.add(bY4);
                    bY8.subtract(bY5);
                    bY2.subtractTimesIInto(bY3, bY9);
                    bY9.subtract(bY4);
                    bY9.addTimesI(bY5);
                    bY6.copyInto(bX2, n6);
                    bY7.copyInto(bX2, n7);
                    bY8.copyInto(bX2, n8);
                    bY9.copyInto(bX2, n9);
                }
            }
            n4 += 2;
        }
        for (int i5 = 0; i5 < n2; ++i5) {
            bX2.timesTwoToThe(i5, -n3);
        }
    }

    private static void ifftMixedRadix(bX bX2, bX[] object, bX bX3) {
        int n2;
        int n3 = bX.access$000(bX2) / 3;
        bX bX4 = new bX(bX2, 0, n3);
        int n4 = n3;
        bX bX5 = new bX(bX2, n4, n4 << 1);
        bX bX6 = new bX(bX2, n3 << 1, bX.access$000(bX2));
        bW.ifft(bX4, (bX[])object);
        bW.ifft(bX5, (bX[])object);
        bW.ifft(bX6, (bX[])object);
        object = new bY();
        for (n2 = 0; n2 < bX.access$000(bX2) / 4; ++n2) {
            ((bY)object).set(bX3, n2);
            bX5.multiply(n2, (bY)object);
            bX6.multiply(n2, (bY)object);
            bX6.multiply(n2, (bY)object);
        }
        for (n2 = bX.access$000(bX2) / 4; n2 < n3; ++n2) {
            ((bY)object).set(bX3, n2 - bX.access$000(bX2) / 4);
            bX5.multiplyByIAnd(n2, (bY)object);
            bX6.multiplyByIAnd(n2, (bY)object);
            bX6.multiplyByIAnd(n2, (bY)object);
        }
        bW.fft3(bX4, bX5, bX6, -1, 0.3333333333333333);
    }

    static BigInteger multiply(BigInteger bigInteger, BigInteger bigInteger2) {
        int n2;
        if (bigInteger2.signum() == 0 || bigInteger.signum() == 0) {
            return BigInteger.ZERO;
        }
        if (bigInteger2 == bigInteger) {
            return bW.square(bigInteger2);
        }
        int n3 = bigInteger.bitLength();
        if ((long)n3 + (long)(n2 = bigInteger2.bitLength()) > 0x80000000L) {
            throw new ArithmeticException("BigInteger would overflow supported range");
        }
        if (n3 > 1920 && n2 > 1920 && (n3 > 33220 || n2 > 33220)) {
            return bW.multiplyFft(bigInteger, bigInteger2);
        }
        return bigInteger.multiply(bigInteger2);
    }

    static BigInteger multiplyFft(BigInteger object, BigInteger object2) {
        int n2;
        int n3;
        int n4;
        int n5 = ((BigInteger)object).signum() * ((BigInteger)object2).signum();
        object = ((BigInteger)(((BigInteger)object).signum() < 0 ? ((BigInteger)object).negate() : object)).toByteArray();
        object2 = ((BigInteger)(((BigInteger)object2).signum() < 0 ? ((BigInteger)object2).negate() : object2)).toByteArray();
        int n6 = Math.max(((Object)object).length, ((Object)object2).length) << 3;
        int n7 = bW.bitsPerFftPoint(n6);
        if ((n6 = (n6 + n7 - 1) / n7 + 1) < (n4 = (n3 = 1 << (n2 = 32 - Integer.numberOfLeadingZeros(n6 - 1))) * 3 / 4) && n2 > 3) {
            bX[] bXArray = bW.getRootsOfUnity2(n2 - 2);
            bX bX2 = bW.getRootsOfUnity3(n2 - 2);
            bX bX3 = bW.getRootsOfUnity3(n2 - 4);
            object = bW.toFftVector((byte[])object, n4, n7);
            ((bX)object).applyWeights(bX2);
            bW.fftMixedRadix((bX)object, bXArray, bX3);
            object2 = bW.toFftVector((byte[])object2, n4, n7);
            ((bX)object2).applyWeights(bX2);
            bW.fftMixedRadix((bX)object2, bXArray, bX3);
            ((bX)object).multiplyPointwise((bX)object2);
            bW.ifftMixedRadix((bX)object, bXArray, bX3);
            ((bX)object).applyInverseWeights(bX2);
            return bW.fromFftVector((bX)object, n5, n7);
        }
        bX[] bXArray = bW.getRootsOfUnity2(n2);
        bX bX4 = bW.toFftVector((byte[])object, n3, n7);
        bX4.applyWeights(bXArray[n2]);
        bW.fft(bX4, bXArray);
        bX bX5 = bW.toFftVector((byte[])object2, n3, n7);
        bX5.applyWeights(bXArray[n2]);
        bW.fft(bX5, bXArray);
        bX4.multiplyPointwise(bX5);
        bW.ifft(bX4, bXArray);
        bX4.applyInverseWeights(bXArray[n2]);
        return bW.fromFftVector(bX4, n5, n7);
    }

    static BigInteger square(BigInteger bigInteger) {
        if (bigInteger.signum() == 0) {
            return BigInteger.ZERO;
        }
        if (bigInteger.bitLength() < 33220) {
            BigInteger bigInteger2 = bigInteger;
            return bigInteger2.multiply(bigInteger2);
        }
        return bW.squareFft(bigInteger);
    }

    static BigInteger squareFft(BigInteger object) {
        int n2;
        int n3;
        int n4;
        byte[] byArray = ((BigInteger)object).toByteArray();
        object = byArray;
        int n5 = byArray.length << 3;
        int n6 = bW.bitsPerFftPoint(n5);
        if ((n5 = (n5 + n6 - 1) / n6 + 1) < (n4 = (n3 = 1 << (n2 = 32 - Integer.numberOfLeadingZeros(n5 - 1))) * 3 / 4)) {
            n5 = n4;
            object = bW.toFftVector((byte[])object, n5, n6);
            bX[] bXArray = bW.getRootsOfUnity2(n2 - 2);
            bX bX2 = bW.getRootsOfUnity3(n2 - 2);
            bX bX3 = bW.getRootsOfUnity3(n2 - 4);
            ((bX)object).applyWeights(bX2);
            bW.fftMixedRadix((bX)object, bXArray, bX3);
            ((bX)object).squarePointwise();
            bW.ifftMixedRadix((bX)object, bXArray, bX3);
            ((bX)object).applyInverseWeights(bX2);
            return bW.fromFftVector((bX)object, 1, n6);
        }
        n5 = n3;
        object = bW.toFftVector((byte[])object, n5, n6);
        bX[] bXArray = bW.getRootsOfUnity2(n2);
        ((bX)object).applyWeights(bXArray[n2]);
        bW.fft((bX)object, bXArray);
        ((bX)object).squarePointwise();
        bW.ifft((bX)object, bXArray);
        ((bX)object).applyInverseWeights(bXArray[n2]);
        return bW.fromFftVector((bX)object, 1, n6);
    }

    static bX toFftVector(byte[] byArray, int n2, int n3) {
        assert (n3 <= 25) : n3 + " does not fit into an int with slack";
        bX bX2 = new bX(n2);
        if (byArray.length < 4) {
            byte[] byArray2 = new byte[4];
            System.arraycopy(byArray, 0, byArray2, 4 - byArray.length, byArray.length);
            byArray = byArray2;
        }
        int n4 = 1 << n3;
        int n5 = n4 / 2;
        int n6 = n4 - 1;
        int n7 = 32 - n3;
        int n8 = byArray.length << 3;
        int n9 = 0;
        int n10 = 0;
        n8 -= n3;
        while (n8 > -n3) {
            int n11 = Math.min(Math.max(0, n8 >> 3), byArray.length - 4);
            int n12 = n7 - n8 + (n11 << 3);
            n11 = (bS.readIntBE(byArray, n11) >>> n12 & n6) + n9;
            n9 = n5 - n11 >>> 31;
            bX2.real(n10, n11 -= n4 & -n9);
            ++n10;
            n8 -= n3;
        }
        if (n9 > 0) {
            bX2.real(n10, n9);
        }
        return bX2;
    }
}

