/*
 * Decompiled with CFR 0.152.
 */
package liquibase.repackaged.net.sf.jsqlparser.util.deparser;

import java.util.Iterator;
import java.util.List;
import liquibase.repackaged.net.sf.jsqlparser.expression.Expression;
import liquibase.repackaged.net.sf.jsqlparser.expression.ExpressionVisitor;
import liquibase.repackaged.net.sf.jsqlparser.expression.operators.relational.ExpressionList;
import liquibase.repackaged.net.sf.jsqlparser.expression.operators.relational.ItemsListVisitor;
import liquibase.repackaged.net.sf.jsqlparser.expression.operators.relational.MultiExpressionList;
import liquibase.repackaged.net.sf.jsqlparser.expression.operators.relational.NamedExpressionList;
import liquibase.repackaged.net.sf.jsqlparser.schema.Column;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.SelectVisitor;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.SubSelect;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.WithItem;
import liquibase.repackaged.net.sf.jsqlparser.statement.upsert.Upsert;
import liquibase.repackaged.net.sf.jsqlparser.statement.upsert.UpsertType;
import liquibase.repackaged.net.sf.jsqlparser.util.deparser.AbstractDeParser;

public class UpsertDeParser
extends AbstractDeParser<Upsert>
implements ItemsListVisitor {
    private ExpressionVisitor expressionVisitor;
    private SelectVisitor selectVisitor;

    public UpsertDeParser(ExpressionVisitor expressionVisitor, SelectVisitor selectVisitor, StringBuilder stringBuilder) {
        super(stringBuilder);
        this.expressionVisitor = expressionVisitor;
        this.selectVisitor = selectVisitor;
    }

    @Override
    public void deParse(Upsert upsert) {
        switch (upsert.getUpsertType()) {
            case REPLACE: 
            case REPLACE_SET: {
                this.buffer.append("REPLACE ");
                break;
            }
            case INSERT_OR_ABORT: {
                this.buffer.append("INSERT OR ABORT ");
                break;
            }
            case INSERT_OR_FAIL: {
                this.buffer.append("INSERT OR FAIL ");
                break;
            }
            case INSERT_OR_IGNORE: {
                this.buffer.append("INSERT OR IGNORE ");
                break;
            }
            case INSERT_OR_REPLACE: {
                this.buffer.append("INSERT OR REPLACE ");
                break;
            }
            case INSERT_OR_ROLLBACK: {
                this.buffer.append("INSERT OR ROLLBACK ");
                break;
            }
            default: {
                this.buffer.append("UPSERT ");
            }
        }
        if (upsert.isUsingInto()) {
            this.buffer.append("INTO ");
        }
        this.buffer.append(upsert.getTable().getFullyQualifiedName());
        if (upsert.getUpsertType() == UpsertType.REPLACE_SET) {
            this.appendReplaceSetClause(upsert);
            return;
        }
        if (upsert.getColumns() != null) {
            this.appendColumns(upsert);
        }
        if (upsert.getItemsList() != null) {
            upsert.getItemsList().accept(this);
        }
        if (upsert.getSelect() != null) {
            this.appendSelect(upsert);
        }
        if (upsert.isUseDuplicate()) {
            this.appendDuplicate(upsert);
        }
    }

    private void appendReplaceSetClause(Upsert upsert) {
        this.buffer.append(" SET ");
        List<Expression> list = upsert.getSetExpressions();
        int n2 = upsert.getColumns().size();
        for (int i2 = 0; i2 < n2; ++i2) {
            this.buffer.append(upsert.getColumns().get(i2)).append("=").append(list.get(i2));
            this.buffer.append(i2 < n2 - 1 ? ", " : "");
        }
    }

    private void appendColumns(Upsert object) {
        this.buffer.append(" (");
        object = ((Upsert)object).getColumns().iterator();
        while (object.hasNext()) {
            Column column = (Column)object.next();
            this.buffer.append(column.getColumnName());
            if (!object.hasNext()) continue;
            this.buffer.append(", ");
        }
        this.buffer.append(")");
    }

    private void appendSelect(Upsert upsert) {
        this.buffer.append(" ");
        if (upsert.isUseSelectBrackets()) {
            this.buffer.append("(");
        }
        if (upsert.getSelect().getWithItemsList() != null) {
            this.buffer.append("WITH ");
            Iterator<WithItem> iterator = upsert.getSelect().getWithItemsList().iterator();
            while (iterator.hasNext()) {
                iterator.next().accept(this.selectVisitor);
            }
            this.buffer.append(" ");
        }
        upsert.getSelect().getSelectBody().accept(this.selectVisitor);
        if (upsert.isUseSelectBrackets()) {
            this.buffer.append(")");
        }
    }

    private void appendDuplicate(Upsert upsert) {
        this.buffer.append(" ON DUPLICATE KEY UPDATE ");
        for (int i2 = 0; i2 < upsert.getDuplicateUpdateColumns().size(); ++i2) {
            Column column = upsert.getDuplicateUpdateColumns().get(i2);
            this.buffer.append(column.getFullyQualifiedName()).append(" = ");
            upsert.getDuplicateUpdateExpressionList().get(i2).accept(this.expressionVisitor);
            if (i2 >= upsert.getDuplicateUpdateColumns().size() - 1) continue;
            this.buffer.append(", ");
        }
    }

    @Override
    public void visit(ExpressionList object) {
        this.buffer.append(" VALUES (");
        object = ((ExpressionList)object).getExpressions().iterator();
        while (object.hasNext()) {
            ((Expression)object.next()).accept(this.expressionVisitor);
            if (!object.hasNext()) continue;
            this.buffer.append(", ");
        }
        this.buffer.append(")");
    }

    @Override
    public void visit(NamedExpressionList namedExpressionList) {
    }

    @Override
    public void visit(MultiExpressionList object) {
        this.buffer.append(" VALUES ");
        object = ((MultiExpressionList)object).getExprList().iterator();
        while (object.hasNext()) {
            this.buffer.append("(");
            Iterator<Expression> iterator = ((ExpressionList)object.next()).getExpressions().iterator();
            while (iterator.hasNext()) {
                iterator.next().accept(this.expressionVisitor);
                if (!iterator.hasNext()) continue;
                this.buffer.append(", ");
            }
            this.buffer.append(")");
            if (!object.hasNext()) continue;
            this.buffer.append(", ");
        }
    }

    @Override
    public void visit(SubSelect subSelect) {
        subSelect.getSelectBody().accept(this.selectVisitor);
    }

    public ExpressionVisitor getExpressionVisitor() {
        return this.expressionVisitor;
    }

    public SelectVisitor getSelectVisitor() {
        return this.selectVisitor;
    }

    public void setExpressionVisitor(ExpressionVisitor expressionVisitor) {
        this.expressionVisitor = expressionVisitor;
    }

    public void setSelectVisitor(SelectVisitor selectVisitor) {
        this.selectVisitor = selectVisitor;
    }
}

