/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.changelog.filter;

import liquibase.changelog.ChangeSet;
import liquibase.changelog.filter.ChangeSetFilter;
import liquibase.changelog.filter.ChangeSetFilterResult;

public class ChangeSetPathFilter
implements ChangeSetFilter {
    private final String path;

    public ChangeSetPathFilter(String string) {
        this.path = string;
    }

    public ChangeSetFilterResult accepts(ChangeSet changeSet) {
        String string = changeSet.toString();
        if (this.path.equalsIgnoreCase(changeSet.getFilePath())) {
            return new ChangeSetFilterResult(true, "Changeset to run is ".concat(String.valueOf(string)), this.getClass(), this.getMdcName(), this.getDisplayName());
        }
        return new ChangeSetFilterResult(false, String.format("Changeset '%s' will not execute because path '%s' does not match '%s'", string, changeSet.getFilePath(), this.path), this.getClass(), this.getMdcName(), this.getDisplayName());
    }

    public String getMdcName() {
        return super.getMdcName();
    }

    public String getDisplayName() {
        return super.getDisplayName();
    }
}

