/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.command;

import com.datical.liquibase.ext.flow.file.FlowFileHelper;
import com.datical.liquibase.ext.flow.file.FlowFileLoad;
import com.datical.liquibase.ext.ui.NoEmptyValueInputHandler;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import liquibase.GlobalConfiguration;
import liquibase.Scope;
import liquibase.command.AbstractCommandStep;
import liquibase.command.CommandScope;
import liquibase.license.LicenseServiceUtils;
import liquibase.resource.ResourceAccessor;
import liquibase.resource.SearchPathResourceAccessor;

public abstract class AbstractFlowCommand
extends AbstractCommandStep {
    public void validate(CommandScope commandScope) {
        super.validate(commandScope);
        LicenseServiceUtils.checkProLicenseAndThrowException((String[])commandScope.getCommand().getName());
    }

    FlowFileLoad loadFlowFileContents(String string, boolean bl2, boolean bl3, Map<String, Object> map) {
        if (((Boolean)GlobalConfiguration.HEADLESS.getCurrentConfiguredValue().getValue()).booleanValue() || !bl2) {
            return FlowFileHelper.load(string, bl3, map);
        }
        try {
            return FlowFileHelper.load(string, bl3, map);
        }
        catch (FileNotFoundException fileNotFoundException) {
            return this.createAndLoadFlowFile(string, bl3, map);
        }
    }

    private FlowFileLoad createAndLoadFlowFile(String string2, boolean bl2, Map<String, Object> map) {
        String string3 = null;
        String string4 = (String)Scope.getCurrentScope().getUI().prompt("WARNING: No flow file detected. Would you like to create and automatically use '" + string2 + "' ?" + System.lineSeparator() + "[1] Yes, create and use sample flow file in the Current Working Directory" + System.lineSeparator() + "[2] Yes, create and use sample flow file at a path I will specify" + System.lineSeparator() + "[3] Just create sample flow file in the CWD, do not use, and exit command" + System.lineSeparator() + "[n] No, do not create sample file, and exit command." + System.lineSeparator(), (Object)"1", (string, clazz) -> {
            if (string == null || !string.equalsIgnoreCase("1") && !string.equalsIgnoreCase("2") && !string.equalsIgnoreCase("3") && !string.equalsIgnoreCase("n")) {
                throw new IllegalArgumentException();
            }
            return string;
        }, String.class);
        if (string4.equalsIgnoreCase("n")) {
            string4 = "No flow-file available. Set the 'flow-file' property with a CLI argument, Environment variable, or other standard method. Learn more at https://docs.liquibase.com/commands/flow/flow.html";
            Scope.getCurrentScope().getLog(FlowFileHelper.class).warning(string4);
            Scope.getCurrentScope().getUI().sendMessage("WARNING: ".concat(String.valueOf(string4)));
            return null;
        }
        if (string4.equals("3")) {
            string4 = FlowFileHelper.createDefaultFlowFile("liquibase.flowfile.yaml", string2);
            string2 = "Sample '" + string4 + "' file created, and ready to use. Learn more at https://docs.liquibase.com/commands/flow/flow.html";
            Scope.getCurrentScope().getLog(FlowFileHelper.class).warning(string2);
            Scope.getCurrentScope().getUI().sendMessage("WARNING: ".concat(String.valueOf(string2)));
            return null;
        }
        if (string4.equals("2")) {
            string4 = (String)Scope.getCurrentScope().getUI().prompt("Please enter a relative or absolute, local or remote path. Do not provide a filename. To use a remote path, such as \"s3://<mybucket>\", please install the correct extension. Learn more about remote path options at http://docs.liquibase.com/s3", null, new NoEmptyValueInputHandler(), String.class);
            string2 = FlowFileHelper.createDefaultFlowFileAtPath("liquibase.flowfile.yaml", string4);
        } else {
            string3 = ".";
            string2 = FlowFileHelper.createDefaultFlowFile("liquibase.flowfile.yaml", string2);
        }
        if (string3 == null) {
            return FlowFileHelper.load(string2, bl2, map);
        }
        string4 = new SearchPathResourceAccessor(".", new ResourceAccessor[]{Scope.getCurrentScope().getResourceAccessor()});
        try {
            return (FlowFileLoad)Scope.child(Collections.singletonMap(Scope.Attr.resourceAccessor.name(), string4), () -> FlowFileHelper.load(string2, bl2, map));
        }
        catch (Exception exception) {
            throw new IOException(exception);
        }
    }
}

