/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.command;

import com.datical.liquibase.ext.command.RollbackOneChangesetCommandStep;
import com.datical.liquibase.ext.util.ProStringUtil;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import liquibase.changelog.DatabaseChangeLog;
import liquibase.command.CommandArgumentDefinition;
import liquibase.command.CommandBuilder;
import liquibase.command.CommandDefinition;
import liquibase.command.CommandResultsBuilder;
import liquibase.command.CommandScope;
import liquibase.database.Database;
import liquibase.util.LoggingExecutorTextUtil;

public class RollbackOneChangesetSqlCommandStep
extends RollbackOneChangesetCommandStep {
    public static final String[] COMMAND_NAME = new String[]{"rollbackOneChangesetSql"};
    public static final CommandArgumentDefinition<Boolean> OUTPUT_DEFAULT_SCHEMA_ARG;
    public static final CommandArgumentDefinition<Boolean> OUTPUT_DEFAULT_CATALOG_ARG;

    @Override
    public List<Class<?>> requiredDependencies() {
        ArrayList arrayList = new ArrayList();
        arrayList.add(Writer.class);
        arrayList.addAll(super.requiredDependencies());
        return arrayList;
    }

    @Override
    public void run(CommandResultsBuilder commandResultsBuilder) {
        CommandScope commandScope = commandResultsBuilder.getCommandScope();
        Database database = (Database)commandScope.getDependency(Database.class);
        Boolean bl2 = (Boolean)commandScope.getArgumentValue(OUTPUT_DEFAULT_CATALOG_ARG);
        Boolean bl3 = (Boolean)commandScope.getArgumentValue(OUTPUT_DEFAULT_SCHEMA_ARG);
        String string = (String)commandScope.getArgumentValue(CHANGESET_ID_ARG);
        Object object = (String)commandScope.getArgumentValue(CHANGESET_AUTHOR_ARG);
        String string2 = (String)commandScope.getArgumentValue(CHANGESET_PATH_ARG);
        DatabaseChangeLog databaseChangeLog = (DatabaseChangeLog)commandScope.getDependency(DatabaseChangeLog.class);
        string = string2 + "::" + string + "::" + (String)object;
        object = (Boolean)commandScope.getArgumentValue(FORCE_ARG);
        commandScope.addArgumentValue(FORCE_ARG, (Object)(object == null || ((Boolean)object).booleanValue() ? 1 : 0));
        database.setOutputDefaultCatalog(bl2.booleanValue());
        database.setOutputDefaultSchema(bl3.booleanValue());
        LoggingExecutorTextUtil.outputHeader((String)("Rollback changeset '" + string + "'"), (Database)database, (String)databaseChangeLog.getFilePath());
        super.run(commandResultsBuilder);
    }

    @Override
    public String[][] defineCommandNames() {
        return new String[][]{COMMAND_NAME};
    }

    @Override
    public void adjustCommandDefinition(CommandDefinition commandDefinition) {
        commandDefinition.setShortDescription(ProStringUtil.markWithPro("Rollback one changeset from the database"));
    }

    static {
        CommandBuilder commandBuilder = new CommandBuilder((String[][])new String[][]{COMMAND_NAME});
        OUTPUT_DEFAULT_SCHEMA_ARG = commandBuilder.argument("outputDefaultSchema", Boolean.class).description("Control whether names of objects in the default schema are fully qualified or not. If true they are. If false, only objects outside the default schema are fully qualified").defaultValue((Object)Boolean.TRUE).build();
        OUTPUT_DEFAULT_CATALOG_ARG = commandBuilder.argument("outputDefaultCatalog", Boolean.class).description("Control whether names of objects in the default catalog are fully qualified or not. If true they are. If false, only objects outside the default catalog are fully qualified").defaultValue((Object)Boolean.TRUE).build();
        FORCE_ARG = commandBuilder.argument("force", Boolean.class).hidden().build();
        commandBuilder.addArgument(CHANGESET_ID_ARG).build();
        commandBuilder.addArgument(CHANGESET_AUTHOR_ARG).build();
        commandBuilder.addArgument(CHANGESET_PATH_ARG).build();
        commandBuilder.addArgument(ROLLBACK_SCRIPT_ARG).build();
        commandBuilder.addArgument(SHOULD_LOG_MDC_CHANGESETS_ROLLED_BACK).hidden().build();
    }
}

