/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.flow.file;

import com.datical.liquibase.ext.command.FlowCommandStep;
import com.datical.liquibase.ext.flow.action.FlowShellCommandAction;
import com.datical.liquibase.ext.flow.action.FlowShellCommandChange;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import liquibase.Scope;
import liquibase.configuration.LiquibaseConfiguration;
import liquibase.util.ObjectUtil;
import liquibase.util.SystemUtil;

public class FlowVariableExpander {
    public static final Pattern KEY_PATTERN = Pattern.compile("(\\$\\{.+?})");
    private static Map<String, String> executedCommands = new HashMap<String, String>();

    private FlowVariableExpander() {
    }

    public static Map<String, Object> expandVariables(Map<String, Object> map, Map<String, Object> map2) {
        return FlowVariableExpander.expandVariables(map, map2, false);
    }

    public static Map<String, Object> expandVariables(Map<String, Object> map, Map<String, Object> map2, boolean bl2) {
        Map<String, Object> map3;
        if (map == null) {
            return null;
        }
        int n2 = 0;
        map = FlowVariableExpander.expand(map, map2, bl2);
        while (!(map3 = FlowVariableExpander.expand(map, map2, bl2)).equals(map)) {
            map = map3;
            if (++n2 < 100) continue;
        }
        return map;
    }

    public static Map<String, Object> execShellCommandsToExpand(Map<String, Object> map) {
        if (map == null) {
            return null;
        }
        LinkedHashMap<String, Object> linkedHashMap = new LinkedHashMap<String, Object>(map);
        map.forEach((string, object) -> {
            String string2;
            if (object instanceof String && !(string2 = FlowVariableExpander.execShellToExpand((String)ObjectUtil.convert((Object)object, String.class))).equals(object)) {
                linkedHashMap.put((String)string, string2);
            }
        });
        return linkedHashMap;
    }

    public static String execShellToExpand(String string) {
        Matcher matcher = Pattern.compile("`(.*)`").matcher(string);
        while (matcher.find()) {
            String string2 = string.substring(matcher.start(), matcher.end());
            String string3 = FlowVariableExpander.shellExec(string2);
            if (string3 == null) continue;
            string = string.replace(string2, string3);
        }
        return string;
    }

    public static String shellExec(String string) {
        if (executedCommands.containsKey(string = string.replace("`", ""))) {
            return executedCommands.get(string);
        }
        StringBuilder stringBuilder = new StringBuilder();
        try {
            FlowShellCommandAction flowShellCommandAction = new FlowShellCommandAction();
            flowShellCommandAction.setExpandedCommand(string);
            FlowShellCommandChange flowShellCommandChange = new FlowShellCommandChange();
            flowShellCommandAction.setCommandChange(flowShellCommandChange);
            flowShellCommandAction.setCommand(string);
            Object object = (String)Scope.getCurrentScope().get(FlowCommandStep.FLOW_SHELL_INTERPRETER.getName(), String.class);
            if (object == null) {
                if (SystemUtil.isWindows()) {
                    flowShellCommandAction.setInterpreter("cmd");
                } else {
                    flowShellCommandAction.setInterpreter("bash");
                }
            } else {
                flowShellCommandAction.setInterpreter((String)object);
            }
            object = (Boolean)Scope.getCurrentScope().get(FlowCommandStep.FLOW_SHELL_KEEP_TEMP_FILES.getName(), Boolean.class);
            if (object == null) {
                object = Boolean.FALSE;
            }
            flowShellCommandAction.run((Boolean)object);
            stringBuilder.append(flowShellCommandChange.getStdout());
        }
        catch (Exception exception) {
            Scope.getCurrentScope().getLog(FlowVariableExpander.class).warning("Unable to execute command: " + string + ": " + exception.getMessage());
            return null;
        }
        executedCommands.put(string, stringBuilder.toString());
        return stringBuilder.toString();
    }

    private static Map<String, Object> expand(Map<String, Object> object, Map<String, Object> map, boolean bl2) {
        LinkedHashMap<String, Object> linkedHashMap = new LinkedHashMap<String, Object>();
        for (Map.Entry<String, Object> entry : object.entrySet()) {
            Object object2;
            if (entry.getValue() instanceof Map) {
                object2 = FlowVariableExpander.expand((Map)entry.getValue(), map, bl2);
                linkedHashMap.put(entry.getKey(), object2);
                continue;
            }
            if (entry.getValue() instanceof List) {
                object2 = new ArrayList();
                for (Object object3 : (List)entry.getValue()) {
                    object3 = FlowVariableExpander.expand(Collections.singletonMap("key", object3), map, bl2);
                    object2.add(object3.get("key"));
                }
                linkedHashMap.put(entry.getKey(), object2);
                continue;
            }
            FlowVariableExpander.expandScalar(map, linkedHashMap, entry, bl2);
        }
        return linkedHashMap;
    }

    private static void expandScalar(Map<String, Object> object, Map<String, Object> map, Map.Entry<String, Object> entry, boolean bl2) {
        Object object22 = entry.getValue();
        if (bl2 && !(object22 instanceof String)) {
            map.put(entry.getKey(), object22);
            return;
        }
        String string = (String)ObjectUtil.convert((Object)object22, String.class);
        map.put(entry.getKey(), string);
        for (Map.Entry<String, Object> entry2 : object.entrySet()) {
            string = FlowVariableExpander.replaceWithExpandedValue(FlowVariableExpander.expandValue(string, entry2), string, entry, map);
        }
        if (string != null && string.contains("${") && string.contains("}")) {
            object = KEY_PATTERN.matcher(string);
            while (((Matcher)object).find()) {
                String string2 = ((Matcher)object).group().replace("$", "").replace("{", "").replace("}", "");
                String string3 = (String)((LiquibaseConfiguration)Scope.getCurrentScope().getSingleton(LiquibaseConfiguration.class)).getCurrentConfiguredValue(null, null, new String[]{string2}).getValue();
                if (string3 == null) continue;
                map.put(entry.getKey(), string3);
                string = FlowVariableExpander.replaceWithExpandedValue(FlowVariableExpander.expandValue(string, string2, string3), string, entry, map);
            }
        }
    }

    private static String replaceWithExpandedValue(String string, String string2, Map.Entry<String, Object> entry, Map<String, Object> map) {
        if (string.equals(string2)) {
            return string2;
        }
        boolean bl2 = entry.getKey().toLowerCase().contains("pass");
        Scope.getCurrentScope().getLog(FlowVariableExpander.class).fine("Replacing '" + entry.getKey() + "' configuration of '" + entry.getValue() + "' with '" + (bl2 ? "*****" : string) + "'");
        map.put(entry.getKey(), string);
        return string;
    }

    private static String expandValue(String string, Map.Entry<String, Object> object) {
        String string2 = String.valueOf(object.getValue());
        object = object.getKey();
        return FlowVariableExpander.expandValue(string, (String)object, string2);
    }

    private static String expandValue(String string, String string2, String string3) {
        return string.replaceAll(Pattern.quote("${" + string2 + "}"), Matcher.quoteReplacement(string3));
    }
}

