/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.logging.structured;

import com.datical.liquibase.ext.config.ExtendedLiquibaseCommandLineConfiguration;
import com.datical.liquibase.ext.flow.action.LiquibaseCommandAction;
import com.datical.liquibase.ext.logging.custommdc.CustomLogDataFile;
import com.datical.liquibase.ext.util.JsonMinifyUtil;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;
import liquibase.Scope;
import liquibase.integration.commandline.LiquibaseCommandLineConfiguration;
import liquibase.logging.LogFormat;
import liquibase.logging.core.NoOpLogService;
import liquibase.logging.mdc.CustomMdcObject;
import liquibase.logging.mdc.MdcManager;
import liquibase.parser.core.yaml.YamlParser;
import liquibase.serializer.core.yaml.YamlSerializer;
import liquibase.util.CollectionUtil;
import liquibase.util.StringUtil;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.SafeConstructor;
import org.yaml.snakeyaml.nodes.Tag;
import org.yaml.snakeyaml.representer.Representer;
import org.yaml.snakeyaml.resolver.Resolver;

public class StructuredLogFormatter
extends Formatter {
    private static final Yaml yaml;
    private static final JsonMinifyUtil minify;
    private static final MdcManager mdcManager;
    private static final AtomicBoolean filterLogMessageElementsErrorOccurred;

    @Override
    public String format(LogRecord object) {
        object = this.buildLogMessageElements((LogRecord)object);
        List<Object> list = null;
        try {
            list = this.filterLogMessageElements((Map<String, Object>)object);
        }
        catch (Exception exception) {
            this.warnAboutFailedFiltering(exception);
        }
        String string = this.jsonifyLogMessage((Map<String, Object>)object);
        if (list != null && !list.isEmpty()) {
            try {
                return this.parseAndFilterJson(string, list);
            }
            catch (Exception exception) {
                this.warnAboutFailedFiltering(exception);
                return string;
            }
        }
        return string;
    }

    private void warnAboutFailedFiltering(Exception exception) {
        if (!filterLogMessageElementsErrorOccurred.getAndSet(true)) {
            Scope.getCurrentScope().getUI().sendErrorMessage("Failed to filter log message elements; suppressing additional exceptions of this type.", (Throwable)exception);
        }
    }

    private String parseAndFilterJson(String object, List<Object> list) {
        object = (Map)yaml.load((String)object);
        this.filterLogMessageElements((Map<String, Object>)object, list);
        return this.jsonifyLogMessage((Map<String, Object>)object);
    }

    private List<Object> filterLogMessageElements(Map<String, Object> map) {
        if (ExtendedLiquibaseCommandLineConfiguration.CUSTOM_LOG_DATA_FILE.getCurrentConfiguredValue().found() && CustomLogDataFile.getResource().exists()) {
            ArrayList<Object> arrayList = new ArrayList<Object>();
            Map<String, Object> map2 = CustomLogDataFile.getFileContents();
            this.processCommandAgnostic(map, arrayList, map2);
            this.processCommandSpecific(map, arrayList, map2);
            return arrayList;
        }
        return Collections.emptyList();
    }

    private void processCommandAgnostic(Map<String, Object> map, List<Object> list, Map<String, Object> object) {
        String string = StructuredLogFormatter.findKeyInMapIgnoreCase("liquibase.excludeData", object);
        if ((object = object.get(string)) instanceof List) {
            list.addAll(this.filterLogMessageElements(map, (List)object));
        }
    }

    private void processCommandSpecific(Map<String, Object> map, List<Object> list, Map<String, Object> object) {
        String string = (String)Scope.getCurrentScope().getMdcManager().getAll().get("liquibaseCommandName");
        if (StringUtil.isNotEmpty((String)string)) {
            try {
                for (Map.Entry entry : object.entrySet()) {
                    Object v2;
                    String string2 = ((String)entry.getKey()).toLowerCase();
                    if (!string2.contains("liquibase.command.")) continue;
                    string2 = string2.replace("liquibase.command.", "");
                    if (!((String[])Scope.child(Collections.singletonMap(Scope.Attr.logService.toString(), new NoOpLogService()), () -> LiquibaseCommandAction.getActualCommandName(string2)))[0].equalsIgnoreCase(string) || !((v2 = entry.getValue()) instanceof List)) continue;
                    Object v3 = ((Map)((List)v2).get(0)).get("excludeData");
                    list.addAll(this.filterLogMessageElements(map, (List)v3));
                }
                return;
            }
            catch (Exception exception) {
                this.warnAboutFailedFiltering(exception);
            }
        }
    }

    private List<Object> filterLogMessageElements(Map<String, Object> map, List<Object> object) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        object = CollectionUtil.createIfNull(object).iterator();
        while (object.hasNext()) {
            String string = String.valueOf(object.next());
            String string2 = StructuredLogFormatter.findKeyInMapIgnoreCase(string, map);
            if (map.remove(string2) != null || StructuredLogFormatter.removeNestedValue(map, string.split("\\."))) continue;
            arrayList.add(string);
        }
        return arrayList;
    }

    public static String findKeyInMapIgnoreCase(String string, Map<String, Object> object) {
        object = object.entrySet().iterator();
        while (object.hasNext()) {
            String string2 = (String)((Map.Entry)object.next()).getKey();
            if (!string2.equalsIgnoreCase(string)) continue;
            return string2;
        }
        return null;
    }

    private static boolean removeNestedValue(Map map, String ... object) {
        object = Arrays.stream(object).iterator();
        while (object.hasNext() && map instanceof Map) {
            String string = (String)object.next();
            string = StructuredLogFormatter.findKeyInMapIgnoreCase(string, map);
            if (!object.hasNext()) {
                return map.remove(string) != null;
            }
            map = map.get(string);
        }
        return false;
    }

    private Map<String, Object> buildLogMessageElements(LogRecord logRecord) {
        LinkedHashMap<String, Object> linkedHashMap = new LinkedHashMap<String, Object>();
        linkedHashMap.put("timestamp", Instant.ofEpochMilli(logRecord.getMillis()).toString());
        linkedHashMap.put("level", logRecord.getLevel().getName());
        if (StringUtil.isNotEmpty((String)logRecord.getSourceClassName())) {
            linkedHashMap.put("class", logRecord.getSourceClassName());
        }
        if (StringUtil.isNotEmpty((String)logRecord.getSourceMethodName())) {
            linkedHashMap.put("method", logRecord.getSourceMethodName());
        }
        linkedHashMap.put("thread", String.valueOf(logRecord.getThreadID()));
        Object object = StringUtil.isEmpty((String)logRecord.getMessage()) ? "" : logRecord.getMessage();
        linkedHashMap.put("message", object);
        if (logRecord.getThrown() != null) {
            object = "";
            if (logRecord.getThrown() != null) {
                object = new StringWriter();
                Map.Entry entry = new PrintWriter((Writer)object);
                ((PrintWriter)((Object)entry)).println();
                logRecord.getThrown().printStackTrace((PrintWriter)((Object)entry));
                ((PrintWriter)((Object)entry)).close();
                object = ((StringWriter)object).toString();
            }
            linkedHashMap.put("exception", object);
        }
        if ((object = mdcManager.getAll()) != null) {
            for (Map.Entry entry : object.entrySet()) {
                logRecord = entry.getValue();
                if (logRecord == null) {
                    linkedHashMap.put((String)entry.getKey(), "");
                    continue;
                }
                linkedHashMap.put((String)entry.getKey(), logRecord);
            }
        }
        return linkedHashMap;
    }

    private String jsonifyLogMessage(Map<String, Object> object) {
        object = YamlSerializer.removeClassTypeMarksFromSerializedJson((String)yaml.dumpAs(object, Tag.MAP, DumperOptions.FlowStyle.FLOW)).replace("!!null \"null\"", "\"null\"");
        if (LiquibaseCommandLineConfiguration.LOG_FORMAT.getCurrentValue() == LogFormat.JSON_PRETTY) {
            return object;
        }
        return minify.minify((String)object) + System.lineSeparator();
    }

    static {
        mdcManager = Scope.getCurrentScope().getMdcManager();
        filterLogMessageElementsErrorOccurred = new AtomicBoolean(false);
        DumperOptions dumperOptions = new DumperOptions();
        dumperOptions.setPrettyFlow(true);
        dumperOptions.setSplitLines(false);
        dumperOptions.setDefaultFlowStyle(DumperOptions.FlowStyle.FLOW);
        dumperOptions.setDefaultScalarStyle(DumperOptions.ScalarStyle.DOUBLE_QUOTED);
        dumperOptions.setWidth(Integer.MAX_VALUE);
        YamlSerializer.LiquibaseRepresenter liquibaseRepresenter = new YamlSerializer.LiquibaseRepresenter(dumperOptions);
        for (CustomMdcObject customMdcObject : Scope.getCurrentScope().getServiceLocator().findInstances(CustomMdcObject.class)) {
            liquibaseRepresenter.addClassTag(customMdcObject.getClass(), Tag.MAP);
        }
        yaml = new Yaml((BaseConstructor)new SafeConstructor(YamlParser.createLoaderOptions()), (Representer)liquibaseRepresenter, dumperOptions, (Resolver)new YamlSerializer.LiquibaseResolver());
        minify = new JsonMinifyUtil();
    }
}

