/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.visitor;

import java.util.Collection;
import java.util.Set;
import liquibase.Labels;
import liquibase.Scope;
import liquibase.changelog.ChangeSet;
import liquibase.changelog.DatabaseChangeLog;
import liquibase.changelog.filter.ChangeSetFilterResult;
import liquibase.changelog.visitor.ChangeSetVisitor;
import liquibase.database.Database;
import liquibase.util.StringUtil;

public class ModifyChangeSetLabelsVisitor
implements ChangeSetVisitor {
    private final String setAsLabels;
    private final boolean forceReplace;

    public ModifyChangeSetLabelsVisitor(String string, boolean bl2) {
        this.setAsLabels = string;
        this.forceReplace = bl2;
    }

    public ChangeSetVisitor.Direction getDirection() {
        return ChangeSetVisitor.Direction.FORWARD;
    }

    public void visit(ChangeSet changeSet, DatabaseChangeLog object, Database database, Set<ChangeSetFilterResult> set) {
        object = changeSet.getLabels().getLabels();
        object = new Labels((Collection)object);
        if (this.forceReplace) {
            if (!object.toString().equalsIgnoreCase(this.setAsLabels)) {
                Scope.getCurrentScope().getLog(ModifyChangeSetLabelsVisitor.class).info(String.format("Change set %s labels set to %s", changeSet, this.setAsLabels));
            }
            changeSet.setLabels(new Labels(this.setAsLabels));
            return;
        }
        StringUtil.splitAndTrim((String)this.setAsLabels, (String)",").forEach(arg_0 -> ((Labels)object).add(arg_0));
        if (!object.toString().equalsIgnoreCase(changeSet.getLabels().toString())) {
            Scope.getCurrentScope().getLog(ModifyChangeSetLabelsVisitor.class).info(String.format("Change set %s labels set to %s", changeSet, object));
        }
        changeSet.setLabels((Labels)object);
    }
}

