/*
 * Decompiled with CFR 0.152.
 */
package liquibase.repackaged.net.sf.jsqlparser.expression;

import java.util.Arrays;
import java.util.List;
import liquibase.repackaged.net.sf.jsqlparser.expression.Expression;
import liquibase.repackaged.net.sf.jsqlparser.expression.ExpressionVisitor;
import liquibase.repackaged.net.sf.jsqlparser.expression.KeepExpression;
import liquibase.repackaged.net.sf.jsqlparser.expression.operators.relational.ExpressionList;
import liquibase.repackaged.net.sf.jsqlparser.expression.operators.relational.NamedExpressionList;
import liquibase.repackaged.net.sf.jsqlparser.parser.ASTNodeAccessImpl;
import liquibase.repackaged.net.sf.jsqlparser.schema.Column;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.OrderByElement;

public class Function
extends ASTNodeAccessImpl
implements Expression {
    private List<String> nameparts;
    private ExpressionList parameters;
    private NamedExpressionList namedParameters;
    private boolean allColumns = false;
    private boolean distinct = false;
    private boolean unique = false;
    private boolean isEscaped = false;
    private Expression attributeExpression;
    private Column attributeColumn = null;
    private List<OrderByElement> orderByElements;
    private KeepExpression keep = null;
    private boolean ignoreNulls = false;

    @Override
    public void accept(ExpressionVisitor expressionVisitor) {
        expressionVisitor.visit(this);
    }

    public String getName() {
        if (this.nameparts == null) {
            return null;
        }
        return String.join((CharSequence)".", this.nameparts);
    }

    public List<String> getMultipartName() {
        return this.nameparts;
    }

    public void setName(String string) {
        this.nameparts = Arrays.asList(string);
    }

    public Function withName(String string) {
        this.setName(string);
        return this;
    }

    public void setName(List<String> list) {
        this.nameparts = list;
    }

    public boolean isAllColumns() {
        return this.allColumns;
    }

    public void setAllColumns(boolean bl2) {
        this.allColumns = bl2;
    }

    public boolean isIgnoreNulls() {
        return this.ignoreNulls;
    }

    public void setIgnoreNulls(boolean bl2) {
        this.ignoreNulls = bl2;
    }

    public boolean isDistinct() {
        return this.distinct;
    }

    public void setDistinct(boolean bl2) {
        this.distinct = bl2;
    }

    public boolean isUnique() {
        return this.unique;
    }

    public void setUnique(boolean bl2) {
        this.unique = bl2;
    }

    public ExpressionList getParameters() {
        return this.parameters;
    }

    public void setParameters(ExpressionList expressionList) {
        this.parameters = expressionList;
    }

    public NamedExpressionList<?> getNamedParameters() {
        return this.namedParameters;
    }

    public void setNamedParameters(NamedExpressionList namedExpressionList) {
        this.namedParameters = namedExpressionList;
    }

    public boolean isEscaped() {
        return this.isEscaped;
    }

    public void setEscaped(boolean bl2) {
        this.isEscaped = bl2;
    }

    public Object getAttribute() {
        if (this.attributeExpression != null) {
            return this.attributeExpression;
        }
        return this.attributeColumn;
    }

    public void setAttribute(Expression expression) {
        this.attributeExpression = expression;
    }

    @Deprecated
    public String getAttributeName() {
        return this.attributeColumn.toString();
    }

    public void setAttributeName(String string) {
        this.attributeColumn = new Column().withColumnName(string);
    }

    public Column getAttributeColumn() {
        return this.attributeColumn;
    }

    public void setAttribute(Column column) {
        this.attributeExpression = null;
        this.attributeColumn = column;
    }

    public Function withAttribute(Column column) {
        this.setAttribute(column);
        return this;
    }

    public KeepExpression getKeep() {
        return this.keep;
    }

    public void setKeep(KeepExpression keepExpression) {
        this.keep = keepExpression;
    }

    public String toString() {
        CharSequence charSequence;
        if (this.parameters != null || this.namedParameters != null) {
            if (this.parameters != null) {
                charSequence = new StringBuilder();
                ((StringBuilder)charSequence).append("(");
                if (this.isDistinct()) {
                    ((StringBuilder)charSequence).append("DISTINCT ");
                } else if (this.isUnique()) {
                    ((StringBuilder)charSequence).append("UNIQUE ");
                }
                if (this.isAllColumns()) {
                    ((StringBuilder)charSequence).append("ALL ");
                }
                ((StringBuilder)charSequence).append(this.parameters);
                if (this.orderByElements != null) {
                    ((StringBuilder)charSequence).append(" ORDER BY ");
                    boolean bl2 = false;
                    for (OrderByElement orderByElement : this.orderByElements) {
                        if (bl2) {
                            ((StringBuilder)charSequence).append(", ");
                        } else {
                            bl2 = true;
                        }
                        ((StringBuilder)charSequence).append(orderByElement);
                    }
                }
                ((StringBuilder)charSequence).append(")");
                charSequence = ((StringBuilder)charSequence).toString();
            } else {
                charSequence = this.namedParameters.toString();
            }
        } else {
            charSequence = "()";
        }
        charSequence = this.getName() + (String)charSequence;
        if (this.attributeExpression != null) {
            charSequence = (String)charSequence + "." + this.attributeExpression;
        } else if (this.attributeColumn != null) {
            charSequence = (String)charSequence + "." + this.attributeColumn;
        }
        if (this.keep != null) {
            charSequence = (String)charSequence + " " + this.keep;
        }
        if (this.isEscaped) {
            charSequence = "{fn " + (String)charSequence + "}";
        }
        return charSequence;
    }

    public Function withAttribute(Expression expression) {
        this.setAttribute(expression);
        return this;
    }

    @Deprecated
    public Function withAttributeName(String string) {
        this.setAttributeName(string);
        return this;
    }

    public Function withKeep(KeepExpression keepExpression) {
        this.setKeep(keepExpression);
        return this;
    }

    public Function withIgnoreNulls(boolean bl2) {
        this.setIgnoreNulls(bl2);
        return this;
    }

    public Function withParameters(ExpressionList expressionList) {
        this.setParameters(expressionList);
        return this;
    }

    public Function withParameters(Expression ... expressionArray) {
        return this.withParameters(new ExpressionList(expressionArray));
    }

    public Function withNamedParameters(NamedExpressionList namedExpressionList) {
        this.setNamedParameters(namedExpressionList);
        return this;
    }

    public Function withAllColumns(boolean bl2) {
        this.setAllColumns(bl2);
        return this;
    }

    public Function withDistinct(boolean bl2) {
        this.setDistinct(bl2);
        return this;
    }

    public Function withUnique(boolean bl2) {
        this.setUnique(bl2);
        return this;
    }

    public List<OrderByElement> getOrderByElements() {
        return this.orderByElements;
    }

    public void setOrderByElements(List<OrderByElement> list) {
        this.orderByElements = list;
    }

    public <E extends Expression> E getAttribute(Class<E> clazz) {
        return (E)((Expression)clazz.cast(this.getAttribute()));
    }
}

