/*
 * Decompiled with CFR 0.152.
 */
package liquibase.repackaged.net.sf.jsqlparser.expression;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import liquibase.repackaged.net.sf.jsqlparser.expression.Expression;
import liquibase.repackaged.net.sf.jsqlparser.expression.ExpressionVisitor;
import liquibase.repackaged.net.sf.jsqlparser.parser.ASTNodeAccessImpl;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.ParenthesedSelect;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.PlainSelect;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.Select;

public class OracleHint
extends ASTNodeAccessImpl
implements Expression {
    private static final Pattern SINGLE_LINE = Pattern.compile("--\\+ *([^ ].*[^ ])");
    private static final Pattern MULTI_LINE = Pattern.compile("\\/\\*\\+ *([^ ].*[^ ]) *\\*+\\/", 40);
    private String value;
    private boolean singleLine = false;

    public static boolean isHintMatch(String string) {
        return SINGLE_LINE.matcher(string).find() || MULTI_LINE.matcher(string).find();
    }

    public final void setComment(String string) {
        Matcher matcher = SINGLE_LINE.matcher(string);
        if (matcher.find()) {
            this.value = matcher.group(1);
            this.singleLine = true;
            return;
        }
        matcher = MULTI_LINE.matcher(string);
        if (matcher.find()) {
            this.value = matcher.group(1);
            this.singleLine = false;
        }
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String string) {
        this.value = string;
    }

    public boolean isSingleLine() {
        return this.singleLine;
    }

    public void setSingleLine(boolean bl2) {
        this.singleLine = bl2;
    }

    @Override
    public void accept(ExpressionVisitor expressionVisitor) {
        expressionVisitor.visit(this);
    }

    public String toString() {
        if (this.singleLine) {
            return "--+ " + this.value + "\n";
        }
        return "/*+ " + this.value + " */";
    }

    public OracleHint withValue(String string) {
        this.setValue(string);
        return this;
    }

    public OracleHint withSingleLine(boolean bl2) {
        this.setSingleLine(bl2);
        return this;
    }

    public static OracleHint getHintFromSelectBody(Select select) {
        while (true) {
            if (select instanceof PlainSelect) {
                return ((PlainSelect)select).getOracleHint();
            }
            if (!(select instanceof ParenthesedSelect)) break;
            select = ((ParenthesedSelect)select).getSelect();
        }
        return null;
    }
}

