/*
 * Decompiled with CFR 0.152.
 */
package liquibase.repackaged.net.sf.jsqlparser.expression.operators.relational;

import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Optional;
import liquibase.repackaged.net.sf.jsqlparser.expression.Expression;
import liquibase.repackaged.net.sf.jsqlparser.expression.ExpressionVisitor;
import liquibase.repackaged.net.sf.jsqlparser.expression.JdbcNamedParameter;
import liquibase.repackaged.net.sf.jsqlparser.expression.JdbcParameter;
import liquibase.repackaged.net.sf.jsqlparser.expression.StringValue;
import liquibase.repackaged.net.sf.jsqlparser.expression.operators.relational.ExpressionList;
import liquibase.repackaged.net.sf.jsqlparser.parser.ASTNodeAccessImpl;
import liquibase.repackaged.net.sf.jsqlparser.schema.Column;

public class FullTextSearch
extends ASTNodeAccessImpl
implements Expression {
    private ExpressionList<Column> _matchColumns;
    private Expression _againstValue;
    private String _searchModifier;

    public void setMatchColumns(ExpressionList<Column> expressionList) {
        this._matchColumns = expressionList;
    }

    public ExpressionList<Column> getMatchColumns() {
        return this._matchColumns;
    }

    public void setAgainstValue(StringValue stringValue) {
        this._againstValue = stringValue;
    }

    public void setAgainstValue(JdbcNamedParameter jdbcNamedParameter) {
        this._againstValue = jdbcNamedParameter;
    }

    public void setAgainstValue(JdbcParameter jdbcParameter) {
        this._againstValue = jdbcParameter;
    }

    public Expression getAgainstValue() {
        return this._againstValue;
    }

    public void setSearchModifier(String string) {
        this._searchModifier = string;
    }

    public String getSearchModifier() {
        return this._searchModifier;
    }

    @Override
    public void accept(ExpressionVisitor expressionVisitor) {
        expressionVisitor.visit(this);
    }

    public String toString() {
        String string = "";
        Iterator iterator = this._matchColumns.iterator();
        while (iterator.hasNext()) {
            Column column = (Column)iterator.next();
            string = string + column.getFullyQualifiedName();
            if (!iterator.hasNext()) continue;
            string = string + ",";
        }
        return "MATCH (" + string + ") AGAINST (" + this._againstValue + (this._searchModifier != null ? " " + this._searchModifier : "") + ")";
    }

    public FullTextSearch withMatchColumns(ExpressionList<Column> expressionList) {
        this.setMatchColumns(expressionList);
        return this;
    }

    public FullTextSearch withAgainstValue(StringValue stringValue) {
        this.setAgainstValue(stringValue);
        return this;
    }

    public FullTextSearch withSearchModifier(String string) {
        this.setSearchModifier(string);
        return this;
    }

    public FullTextSearch addMatchColumns(Column ... columnArray) {
        return this.addMatchColumns(Arrays.asList(columnArray));
    }

    public FullTextSearch addMatchColumns(Collection<? extends Column> collection) {
        ExpressionList expressionList = Optional.ofNullable(this.getMatchColumns()).orElseGet(() -> new ExpressionList((Expression[])new Column[0]));
        expressionList.addAll(collection);
        return this.withMatchColumns(expressionList);
    }
}

