/*
 * Decompiled with CFR 0.152.
 */
package liquibase.repackaged.net.sf.jsqlparser.statement.merge;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import liquibase.repackaged.net.sf.jsqlparser.expression.Alias;
import liquibase.repackaged.net.sf.jsqlparser.expression.Expression;
import liquibase.repackaged.net.sf.jsqlparser.expression.OracleHint;
import liquibase.repackaged.net.sf.jsqlparser.schema.Table;
import liquibase.repackaged.net.sf.jsqlparser.statement.Statement;
import liquibase.repackaged.net.sf.jsqlparser.statement.StatementVisitor;
import liquibase.repackaged.net.sf.jsqlparser.statement.merge.MergeInsert;
import liquibase.repackaged.net.sf.jsqlparser.statement.merge.MergeUpdate;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.FromItem;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.ParenthesedSelect;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.WithItem;

public class Merge
implements Statement {
    private List<WithItem> withItemsList;
    private Table table;
    private OracleHint oracleHint = null;
    private FromItem fromItem;
    private Expression onCondition;
    private MergeInsert mergeInsert;
    private MergeUpdate mergeUpdate;
    private boolean insertFirst = false;

    public List<WithItem> getWithItemsList() {
        return this.withItemsList;
    }

    public void setWithItemsList(List<WithItem> list) {
        this.withItemsList = list;
    }

    public Merge withWithItemsList(List<WithItem> list) {
        this.setWithItemsList(list);
        return this;
    }

    public Merge addWithItemsList(WithItem ... withItemArray) {
        List list = Optional.ofNullable(this.getWithItemsList()).orElseGet(ArrayList::new);
        Collections.addAll(list, withItemArray);
        return this.withWithItemsList(list);
    }

    public Merge addWithItemsList(Collection<? extends WithItem> collection) {
        List list = Optional.ofNullable(this.getWithItemsList()).orElseGet(ArrayList::new);
        list.addAll(collection);
        return this.withWithItemsList(list);
    }

    public Table getTable() {
        return this.table;
    }

    public void setTable(Table table) {
        this.table = table;
    }

    public OracleHint getOracleHint() {
        return this.oracleHint;
    }

    public void setOracleHint(OracleHint oracleHint) {
        this.oracleHint = oracleHint;
    }

    @Deprecated
    public Table getUsingTable() {
        if (this.fromItem instanceof Table) {
            return (Table)this.fromItem;
        }
        return null;
    }

    @Deprecated
    public void setUsingTable(Table table) {
        this.fromItem = table;
    }

    @Deprecated
    public void setUsingSelect(ParenthesedSelect parenthesedSelect) {
        this.fromItem = parenthesedSelect;
    }

    @Deprecated
    public Alias getUsingAlias() {
        return this.fromItem.getAlias();
    }

    @Deprecated
    public void setUsingAlias(Alias alias) {
        this.fromItem.setAlias(alias);
    }

    public FromItem getFromItem() {
        return this.fromItem;
    }

    public void setFromItem(FromItem fromItem) {
        this.fromItem = fromItem;
    }

    public Merge withFromItem(FromItem fromItem) {
        this.setFromItem(fromItem);
        return this;
    }

    public Expression getOnCondition() {
        return this.onCondition;
    }

    public void setOnCondition(Expression expression) {
        this.onCondition = expression;
    }

    public MergeInsert getMergeInsert() {
        return this.mergeInsert;
    }

    public void setMergeInsert(MergeInsert mergeInsert) {
        this.mergeInsert = mergeInsert;
    }

    public MergeUpdate getMergeUpdate() {
        return this.mergeUpdate;
    }

    public void setMergeUpdate(MergeUpdate mergeUpdate) {
        this.mergeUpdate = mergeUpdate;
    }

    @Override
    public void accept(StatementVisitor statementVisitor) {
        statementVisitor.visit(this);
    }

    public boolean isInsertFirst() {
        return this.insertFirst;
    }

    public void setInsertFirst(boolean bl2) {
        this.insertFirst = bl2;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.withItemsList != null && !this.withItemsList.isEmpty()) {
            stringBuilder.append("WITH ");
            Iterator<WithItem> iterator = this.withItemsList.iterator();
            while (iterator.hasNext()) {
                WithItem withItem = iterator.next();
                stringBuilder.append(withItem);
                if (iterator.hasNext()) {
                    stringBuilder.append(",");
                }
                stringBuilder.append(" ");
            }
        }
        stringBuilder.append("MERGE INTO ");
        stringBuilder.append(this.table);
        stringBuilder.append(" USING ");
        stringBuilder.append(this.fromItem);
        stringBuilder.append(" ON (");
        stringBuilder.append(this.onCondition);
        stringBuilder.append(")");
        if (this.insertFirst && this.mergeInsert != null) {
            stringBuilder.append(this.mergeInsert);
        }
        if (this.mergeUpdate != null) {
            stringBuilder.append(this.mergeUpdate);
        }
        if (!this.insertFirst && this.mergeInsert != null) {
            stringBuilder.append(this.mergeInsert);
        }
        return stringBuilder.toString();
    }

    @Deprecated
    public Merge withUsingTable(Table table) {
        this.setUsingTable(table);
        return this;
    }

    @Deprecated
    public Merge withUsingSelect(ParenthesedSelect parenthesedSelect) {
        this.setUsingSelect(parenthesedSelect);
        return this;
    }

    @Deprecated
    public Merge withUsingAlias(Alias alias) {
        this.setUsingAlias(alias);
        return this;
    }

    public Merge withOnCondition(Expression expression) {
        this.setOnCondition(expression);
        return this;
    }

    public Merge withMergeUpdate(MergeUpdate mergeUpdate) {
        this.setMergeUpdate(mergeUpdate);
        return this;
    }

    public Merge withInsertFirst(boolean bl2) {
        this.setInsertFirst(bl2);
        return this;
    }

    public Merge withTable(Table table) {
        this.setTable(table);
        return this;
    }

    public Merge withMergeInsert(MergeInsert mergeInsert) {
        this.setMergeInsert(mergeInsert);
        return this;
    }

    public <E extends Expression> E getOnCondition(Class<E> clazz) {
        return (E)((Expression)clazz.cast(this.getOnCondition()));
    }
}

