/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.checks.basic;

import com.datical.liquibase.ext.checks.basic.AbstractNotAllowedToContainRule;
import com.datical.liquibase.ext.checks.config.cli.RuleParameter;
import com.datical.liquibase.ext.rules.api.ScopeEnum;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import liquibase.change.AbstractSQLChange;
import liquibase.change.Change;
import liquibase.change.core.DropColumnChange;
import liquibase.util.StringUtil;

public class WarnOnColumnDrops
extends AbstractNotAllowedToContainRule {
    private static final String[] NOT_MATCHES = new String[]{"drop foreign", "drop primary", "drop index", "drop key", "drop unique", "drop check", "drop constraint", "drop partition"};

    @Override
    public List<Pattern> getReservedPhrase() {
        return Arrays.asList(Pattern.compile("drop[\\s]+column[\\s]+"), Pattern.compile("drop[\\s]+column[\\s]*\\["));
    }

    @Override
    public String getFailureMessage() {
        return "Liquibase recommends that changesets which result in columns being dropped are reviewed carefully to prevent the unintentional loss of data.  Review this changeset to confirm that the referenced column is being dropped safely.";
    }

    @Override
    public List<ScopeEnum> getScope() {
        return Collections.singletonList(ScopeEnum.CHANGELOG);
    }

    @Override
    public List<String> getTags() {
        return null;
    }

    @Override
    public String getMinLiquibaseVersion() {
        return null;
    }

    @Override
    public String getMaxLiquibaseVersion() {
        return null;
    }

    @Override
    public String getDescription() {
        return "This check warns a user when a column is being dropped so that they can ensure that dropping the column won't lead to unintentional loss of data.";
    }

    @Override
    public String getName() {
        return "Warn when 'DROP COLUMN' detected";
    }

    @Override
    public String getShortName() {
        return "ChangeDropColumnWarn";
    }

    @Override
    public int getPriority() {
        return 40;
    }

    @Override
    public List<RuleParameter<?>> getParameters() {
        return null;
    }

    @Override
    public List<Class<? extends Change>> getOtherCompatibleChangeTypes() {
        return Collections.singletonList(DropColumnChange.class);
    }

    @Override
    public boolean doCheck(AbstractSQLChange change) {
        String sql = this.getSql(change);
        if (StringUtil.isEmpty((String)sql)) {
            return false;
        }
        if (!(sql = StringUtil.stripComments((String)sql).toLowerCase()).contains("alter table") || !sql.contains("drop ")) {
            return false;
        }
        boolean b = super.doCheck(change);
        if (b) {
            return true;
        }
        for (String notMatch : NOT_MATCHES) {
            if (!sql.contains(notMatch)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean doCheck(Change change) {
        return change instanceof DropColumnChange;
    }
}

