/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.checks.snapshot;

import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import liquibase.GlobalConfiguration;
import liquibase.command.CommandResults;
import liquibase.command.CommandScope;
import liquibase.command.core.SnapshotCommandStep;
import liquibase.command.core.helpers.DbUrlConnectionCommandStep;
import liquibase.database.Database;
import liquibase.database.OfflineConnection;
import liquibase.diff.output.ObjectChangeFilter;
import liquibase.diff.output.StandardObjectChangeFilter;
import liquibase.exception.DatabaseException;
import liquibase.snapshot.DatabaseSnapshot;
import liquibase.snapshot.SnapshotControl;
import liquibase.structure.core.DatabaseObjectFactory;

public class DatabaseSnapshotHelper {
    private DatabaseSnapshotHelper() {
    }

    public static DatabaseSnapshot takeSnapshot(String url, Database database, String schemas) throws DatabaseException {
        AtomicReference<DatabaseSnapshot> snapshot = new AtomicReference<DatabaseSnapshot>();
        try {
            CommandScope snapshotCommand = new CommandScope(new String[]{"snapshot"});
            snapshotCommand.addArgumentValue(DbUrlConnectionCommandStep.DATABASE_ARG, (Object)database);
            snapshotCommand.addArgumentValue(SnapshotCommandStep.SCHEMAS_ARG, (Object)schemas);
            snapshotCommand.addArgumentValue(SnapshotCommandStep.SNAPSHOT_CONTROL_ARG, (Object)DatabaseSnapshotHelper.createSnapshotControl(database));
            snapshotCommand.setOutput(null);
            CommandResults results = snapshotCommand.execute();
            snapshot.set((DatabaseSnapshot)results.getResult("snapshot"));
        }
        catch (Exception e) {
            String message = "";
            message = database.getConnection() instanceof OfflineConnection ? "The snapshot specified in the URL property cannot be accessed. Database-scoped checks cannot be completed.\nPlease check all database properties and credentials and try again." : "The database target specified in the URL property cannot be accessed. Database-scoped checks cannot be completed.\nPlease check all database properties and credentials and try again.";
            throw new DatabaseException(message, (Throwable)e);
        }
        return (DatabaseSnapshot)snapshot.get();
    }

    private static SnapshotControl createSnapshotControl(Database database) {
        String databaseChangelogTableName = (String)GlobalConfiguration.DATABASECHANGELOG_TABLE_NAME.getCurrentValue();
        String databaseChangelogLockTableName = (String)GlobalConfiguration.DATABASECHANGELOGLOCK_TABLE_NAME.getCurrentValue();
        StandardObjectChangeFilter filterLiquibaseTables = new StandardObjectChangeFilter(StandardObjectChangeFilter.FilterType.EXCLUDE, "table:(?i)" + databaseChangelogTableName + ", table:(?i)" + databaseChangelogLockTableName);
        Set typesSet = DatabaseObjectFactory.getInstance().getStandardTypes();
        Class[] typesArray = typesSet.toArray(new Class[0]);
        return new SnapshotControl(database, (ObjectChangeFilter)filterLiquibaseTables, typesArray);
    }
}

