/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.command;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Set;
import liquibase.Contexts;
import liquibase.LabelExpression;
import liquibase.RuntimeEnvironment;
import liquibase.Scope;
import liquibase.change.core.RawSQLChange;
import liquibase.changelog.ChangeLogIterator;
import liquibase.changelog.ChangeLogParameters;
import liquibase.changelog.ChangeSet;
import liquibase.changelog.DatabaseChangeLog;
import liquibase.changelog.RanChangeSet;
import liquibase.changelog.filter.AlreadyRanChangeSetFilter;
import liquibase.changelog.filter.ChangeSetFilter;
import liquibase.changelog.filter.ChangeSetFilterResult;
import liquibase.changelog.filter.ContextChangeSetFilter;
import liquibase.changelog.filter.DbmsChangeSetFilter;
import liquibase.changelog.filter.IgnoreChangeSetFilter;
import liquibase.changelog.filter.LabelChangeSetFilter;
import liquibase.changelog.visitor.ChangeExecListener;
import liquibase.changelog.visitor.ChangeSetVisitor;
import liquibase.changelog.visitor.RollbackVisitor;
import liquibase.command.AbstractCommandStep;
import liquibase.command.CommandScope;
import liquibase.command.core.helpers.DatabaseChangelogCommandStep;
import liquibase.database.Database;
import liquibase.exception.CommandValidationException;
import liquibase.exception.LiquibaseException;
import liquibase.logging.mdc.MdcObject;
import liquibase.resource.Resource;
import liquibase.util.StreamUtil;

public abstract class AbstractRollbackOneCommand
extends AbstractCommandStep {
    public static final String EMPTY_ROLLBACK_SCRIPT_MESSAGE = "No rollback logic defined in empty rollback script. Changesets have been removed from the DATABASECHANGELOG table but no other logic was performed.";

    public void validate(CommandScope commandScope) throws CommandValidationException {
        commandScope.addArgumentValue(DatabaseChangelogCommandStep.UPDATE_NULL_CHECKSUMS, (Object)Boolean.FALSE);
    }

    protected ChangeLogIterator createChangeLogIterator(List<RanChangeSet> ranChangeSetList, ChangeSetFilter changeSetFilter, DatabaseChangeLog changeLog, Contexts contexts, LabelExpression labelExpression, Database database) {
        return new ChangeLogIterator(ranChangeSetList, changeLog, new ChangeSetFilter[]{changeSetFilter, new AlreadyRanChangeSetFilter(ranChangeSetList), new ContextChangeSetFilter(contexts), new LabelChangeSetFilter(labelExpression), new IgnoreChangeSetFilter(), new DbmsChangeSetFilter(database)});
    }

    protected RollbackVisitor createRollbackVisitor(List<ChangeSet> processedChangesets, Database database, ChangeExecListener changeExecListener) {
        return new RollbackVisitor(database, changeExecListener, processedChangesets);
    }

    protected RawSQLChange buildRawSQLChange(String rollbackScriptContents) {
        RawSQLChange rollbackChange = new RawSQLChange(rollbackScriptContents);
        rollbackChange.setSplitStatements(Boolean.TRUE);
        rollbackChange.setStripComments(Boolean.TRUE);
        return rollbackChange;
    }

    protected void removeRunStatus(ChangeLogIterator logIterator, Contexts contexts, LabelExpression labelExpression, Database database) throws LiquibaseException {
        logIterator.run(new ChangeSetVisitor(){

            public ChangeSetVisitor.Direction getDirection() {
                return ChangeSetVisitor.Direction.REVERSE;
            }

            public void visit(ChangeSet changeSet, DatabaseChangeLog databaseChangeLog, Database database, Set<ChangeSetFilterResult> filterResults) throws LiquibaseException {
                database.removeRanStatus(changeSet);
                database.commit();
            }
        }, new RuntimeEnvironment(database, contexts, labelExpression));
    }

    protected String getRollbackScriptContents(String rollbackScript, String executor, ChangeLogParameters changeLogParameters, DatabaseChangeLog changeLog) throws LiquibaseException {
        String rollbackScriptContents;
        try {
            Resource resource = Scope.getCurrentScope().getResourceAccessor().get(rollbackScript);
            if (resource == null) {
                throw new LiquibaseException(String.format("WARNING: The rollback script '%s' was not located. Please check your parameters. No rollback was performed.", rollbackScript));
            }
            rollbackScriptContents = StreamUtil.readStreamAsString((InputStream)resource.openInputStream());
        }
        catch (IOException e) {
            throw new LiquibaseException("Error reading rollbackScript " + executor + ": " + e.getMessage());
        }
        return changeLogParameters.expandExpressions(rollbackScriptContents, changeLog);
    }

    protected void logSuccess(DatabaseChangeLog databaseChangeLog) {
        try (MdcObject deploymentOutcomeMdc = Scope.getCurrentScope().getMdcManager().put("deploymentOutcome", "success");
             MdcObject changelogMdc = Scope.getCurrentScope().addMdcValue("changelogFile", databaseChangeLog.getLogicalFilePath());){
            Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass()).info("Rollback command completed successfully.");
        }
    }
}

